/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.form;

import com.silverpeas.form.AbstractForm;
import com.silverpeas.form.DataRecord;
import com.silverpeas.form.Field;
import com.silverpeas.form.FieldDisplayer;
import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.RecordTemplate;
import com.silverpeas.form.TypeManager;
import com.silverpeas.form.Util;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.JspWriter;

public class XmlForm
extends AbstractForm {
    public XmlForm(RecordTemplate template) throws FormException {
        super(template);
    }

    @Override
    public String toString(PagesContext pagesContext, DataRecord record) {
        SilverTrace.info("form", "XmlForm.toString", "root.MSG_GEN_ENTER_METHOD");
        StringWriter sw = new StringWriter();
        String language = pagesContext.getLanguage();
        PrintWriter out = new PrintWriter((Writer)sw, true);
        if (pagesContext.getPrintTitle() && StringUtil.isDefined(this.getTitle())) {
            out.println("<table cellpadding=\"0\" cellspacing=\"2\" border=\"0\" width=\"98%\" class=\"intfdcolor\">");
            out.println("<tr>");
            out.println("<td class=\"intfdcolor4\" nowrap=\"nowrap\">");
            out.println("<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">");
            out.println("<tr>");
            out.println("<td class=\"intfdcolor\" nowrap=\"nowrap\" width=\"100%\">");
            out.println("<img border=\"0\" src=\"" + Util.getIcon("px") + "\" width=\"5\" alt=\"\"/><span class=\"txtNav\">" + this.getTitle() + "</span>");
            out.println("</td>");
            out.println("</tr>");
            out.println("</table>");
            out.println("</td>");
            out.println("</tr>");
            out.println("</table>");
        }
        Iterator<FieldTemplate> itFields = null;
        List<FieldTemplate> listField = this.getFieldTemplates();
        if (listField != null) {
            itFields = listField.iterator();
        }
        boolean mandatory = false;
        if (itFields != null && itFields.hasNext()) {
            String fieldDisplayerName;
            String fieldType;
            String fieldName;
            out.println("<input type=\"hidden\" name=\"id\" value=\"" + record.getId() + "\"/>");
            if (pagesContext.isBorderPrinted()) {
                out.println("<table width=\"98%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"intfdcolor4\">");
                out.println("<tr>");
                out.println("<td nowrap=\"nowrap\">");
                out.println("<table border=\"0\" cellspacing=\"0\" cellpadding=\"5\" class=\"contourintfdcolor\" width=\"100%\">");
            } else {
                out.println("<table border=\"0\" cellspacing=\"0\" cellpadding=\"5\">");
            }
            PagesContext pc = new PagesContext(pagesContext);
            pc.setNbFields(listField.size());
            pc.incCurrentFieldIndex(1);
            int lastFieldIndex = -1;
            lastFieldIndex += Integer.parseInt(pc.getCurrentFieldIndex());
            Field field = null;
            FieldDisplayer fieldDisplayer = null;
            while (itFields.hasNext()) {
                FieldTemplate fieldTemplate = itFields.next();
                if (fieldTemplate == null) continue;
                fieldName = fieldTemplate.getFieldName();
                fieldType = fieldTemplate.getTypeName();
                fieldDisplayerName = fieldTemplate.getDisplayerName();
                field = null;
                if (record != null) {
                    try {
                        field = record.getField(fieldName);
                    }
                    catch (FormException fe) {
                        SilverTrace.error("form", "XmlForm.toString", "form.EXP_UNKNOWN_FIELD", null, fe);
                    }
                }
                if (record != null && (record == null || field == null)) continue;
                try {
                    if (!StringUtil.isDefined(fieldDisplayerName)) {
                        fieldDisplayerName = this.getTypeManager().getDisplayerName(fieldType);
                    }
                    if ((fieldDisplayer = this.getTypeManager().getDisplayer(fieldType, fieldDisplayerName)) == null) continue;
                    lastFieldIndex += fieldDisplayer.getNbHtmlObjectsDisplayed(fieldTemplate, pc);
                }
                catch (FormException fe) {
                    SilverTrace.error("form", "XmlForm.toString", "form.EXP_UNKNOWN_DISPLAYER", null, fe);
                }
            }
            pc.setLastFieldIndex(lastFieldIndex);
            for (FieldTemplate fieldTemplate : listField) {
                if (fieldTemplate == null) continue;
                fieldName = fieldTemplate.getFieldName();
                String fieldLabel = fieldTemplate.getLabel(language);
                fieldType = fieldTemplate.getTypeName();
                fieldDisplayerName = fieldTemplate.getDisplayerName();
                boolean isMandatory = fieldTemplate.isMandatory();
                boolean isDisabled = fieldTemplate.isDisabled();
                boolean isReadOnly = fieldTemplate.isReadOnly();
                boolean isHidden = fieldTemplate.isHidden();
                field = null;
                try {
                    field = record.getField(fieldName);
                }
                catch (FormException fe) {
                    SilverTrace.error("form", "XmlForm.toString", "form.EXP_UNKNOWN_FIELD", null, fe);
                }
                if (field == null) continue;
                try {
                    if (!StringUtil.isDefined(fieldDisplayerName)) {
                        fieldDisplayerName = this.getTypeManager().getDisplayerName(fieldType);
                    }
                    fieldDisplayer = this.getTypeManager().getDisplayer(fieldType, fieldDisplayerName);
                }
                catch (FormException fe) {
                    SilverTrace.error("form", "XmlForm.toString", "form.EXP_UNKNOWN_DISPLAYER", null, fe);
                }
                if (fieldDisplayer == null) continue;
                out.println("<tr align=\"center\">");
                if (StringUtil.isDefined(fieldLabel)) {
                    out.println("<td class=\"intfdcolor4\" valign=\"top\" align=\"left\" nowrap=\"nowrap\">");
                    out.println("<span class=\"txtlibform\">" + fieldLabel + " :</span>");
                    out.println("</td>");
                }
                out.println("<td class=\"intfdcolor4\" valign=\"baseline\" align=\"left\">");
                if (field == null) {
                    try {
                        field = fieldTemplate.getEmptyField();
                    }
                    catch (FormException fe) {
                        SilverTrace.error("form", "XmlForm.toString", "form.EXP_UNKNOWN_FIELD", null, fe);
                    }
                }
                try {
                    fieldDisplayer.display(out, record.getField(fieldName), fieldTemplate, pc);
                }
                catch (FormException fe) {
                    SilverTrace.error("form", "XmlForm.toString", "form.EX_CANT_GET_FORM", null, fe);
                }
                if (isMandatory && !isDisabled && !isReadOnly && !isHidden && fieldDisplayer.isDisplayedMandatory()) {
                    mandatory = true;
                }
                out.println("</td>");
                out.println("</tr>");
                pc.incCurrentFieldIndex(fieldDisplayer.getNbHtmlObjectsDisplayed(fieldTemplate, pc));
            }
            if (mandatory) {
                out.println("<tr align=\"left\">");
                out.println("<td colspan=\"2\">");
                out.println("(<img border=\"0\" src=\"" + Util.getIcon("mandatoryField") + "\" width=\"5\" height=\"5\" alt=\"" + Util.getString("GML.requiredField", language) + "\"/>&nbsp;:&nbsp;" + Util.getString("GML.requiredField", language) + ")");
                out.println("</td>");
                out.println("</tr>");
            }
            if (pagesContext.isBorderPrinted()) {
                out.println("</table>");
                out.println("</td>");
                out.println("</tr>");
            }
            out.println("</table>");
        }
        return sw.getBuffer().toString();
    }

    @Override
    public void display(JspWriter jw, PagesContext pagesContext, DataRecord record) {
        block35: {
            SilverTrace.info("form", "XmlForm.display", "root.MSG_GEN_ENTER_METHOD");
            try {
                String fieldDisplayerName;
                String fieldType;
                String fieldName;
                String language = pagesContext.getLanguage();
                StringWriter sw = new StringWriter();
                PrintWriter out = new PrintWriter((Writer)sw, true);
                if (record != null) {
                    out.println("<input type=\"hidden\" name=\"id\" value=\"" + record.getId() + "\"/>");
                }
                if (pagesContext.getPrintTitle() && this.getTitle() != null && this.getTitle().length() > 0) {
                    out.println("<table cellpadding=\"0\" cellspacing=\"2\" border=\"0\" width=\"98%\" class=\"intfdcolor\">");
                    out.println("<tr>");
                    out.println("<td class=\"intfdcolor4\" nowrap=\"nowrap\">");
                    out.println("<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">");
                    out.println("<tr>");
                    out.println("<td class=\"intfdcolor\" nowrap=\"nowrap\" width=\"100%\">");
                    out.println("<img border=\"0\" src=\"" + Util.getIcon("px") + "\" width=\"5\" alt=\"\"/><span class=\"txtNav\">" + this.getTitle() + "</span>");
                    out.println("</td>");
                    out.println("</tr>");
                    out.println("</table>");
                    out.println("</td>");
                    out.println("</tr>");
                    out.println("</table>");
                }
                Iterator<FieldTemplate> itFields = null;
                List<FieldTemplate> listField = this.getFieldTemplates();
                if (listField != null) {
                    itFields = listField.iterator();
                }
                boolean mandatory = false;
                if (itFields == null || !itFields.hasNext()) break block35;
                if (pagesContext.isBorderPrinted()) {
                    out.println("<table width=\"98%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"intfdcolor4\">");
                    out.println("<tr>");
                    out.println("<td nowrap=\"nowrap\">");
                    out.println("<table border=\"0\" cellspacing=\"0\" cellpadding=\"5\" class=\"contourintfdcolor\" width=\"100%\">");
                } else {
                    out.println("<table border=\"0\" cellspacing=\"0\" cellpadding=\"5\">");
                }
                out.flush();
                jw.write(sw.toString());
                PagesContext pc = new PagesContext(pagesContext);
                pc.setNbFields(listField.size());
                if (record != null) {
                    pc.incCurrentFieldIndex(1);
                }
                int lastFieldIndex = -1;
                lastFieldIndex += Integer.parseInt(pc.getCurrentFieldIndex());
                Field field = null;
                FieldDisplayer fieldDisplayer = null;
                while (itFields.hasNext()) {
                    FieldTemplate fieldTemplate = itFields.next();
                    if (fieldTemplate == null) continue;
                    fieldName = fieldTemplate.getFieldName();
                    fieldType = fieldTemplate.getTypeName();
                    fieldDisplayerName = fieldTemplate.getDisplayerName();
                    field = null;
                    if (record != null) {
                        try {
                            field = record.getField(fieldName);
                        }
                        catch (FormException fe) {
                            SilverTrace.error("form", "XmlForm.display", "form.EXP_UNKNOWN_FIELD", null, fe);
                        }
                    }
                    if (record != null && (record == null || field == null)) continue;
                    try {
                        if (!StringUtil.isDefined(fieldDisplayerName)) {
                            fieldDisplayerName = this.getTypeManager().getDisplayerName(fieldType);
                        }
                        if ((fieldDisplayer = this.getTypeManager().getDisplayer(fieldType, fieldDisplayerName)) == null) continue;
                        lastFieldIndex += fieldDisplayer.getNbHtmlObjectsDisplayed(fieldTemplate, pc);
                    }
                    catch (FormException fe) {
                        SilverTrace.error("form", "XmlForm.display", "form.EXP_UNKNOWN_DISPLAYER", null, fe);
                    }
                }
                pc.setLastFieldIndex(lastFieldIndex);
                for (FieldTemplate fieldTemplate : listField) {
                    Map<String, String> parameters = fieldTemplate.getParameters(language);
                    fieldName = fieldTemplate.getFieldName();
                    String fieldLabel = fieldTemplate.getLabel(language);
                    fieldType = fieldTemplate.getTypeName();
                    fieldDisplayerName = fieldTemplate.getDisplayerName();
                    boolean isMandatory = fieldTemplate.isMandatory();
                    boolean isDisabled = fieldTemplate.isDisabled();
                    boolean isReadOnly = fieldTemplate.isReadOnly();
                    boolean isHidden = fieldTemplate.isHidden();
                    String fieldClass = "";
                    if (parameters.containsKey("classLabel")) {
                        fieldClass = parameters.get("classLabel");
                    }
                    field = null;
                    if (record != null) {
                        try {
                            field = record.getField(fieldName);
                        }
                        catch (FormException fe) {
                            SilverTrace.error("form", "XmlForm.display", "form.EXP_UNKNOWN_FIELD", null, fe);
                        }
                    }
                    if (record != null && (record == null || field == null)) continue;
                    try {
                        if (!StringUtil.isDefined(fieldDisplayerName)) {
                            fieldDisplayerName = this.getTypeManager().getDisplayerName(fieldType);
                        }
                        fieldDisplayer = this.getTypeManager().getDisplayer(fieldType, fieldDisplayerName);
                    }
                    catch (FormException fe) {
                        SilverTrace.error("form", "XmlForm.display", "form.EXP_UNKNOWN_DISPLAYER", null, fe);
                    }
                    if (fieldDisplayer == null) continue;
                    sw = new StringWriter();
                    out = new PrintWriter((Writer)sw, true);
                    out.println("<tr align=\"center\">");
                    out.println("<td class=\"intfdcolor4\" valign=\"top\" align=\"left\">");
                    if (StringUtil.isDefined(fieldLabel)) {
                        if (StringUtil.isDefined(fieldClass)) {
                            out.println("<span class=\"" + fieldClass + "\">" + fieldLabel + " :</span>");
                        } else {
                            out.println("<span class=\"txtlibform\">" + fieldLabel + " :</span>");
                        }
                    } else {
                        out.println("<span class=\"txtlibform\">&nbsp;</span>");
                    }
                    out.println("</td>");
                    out.println("<td class=\"intfdcolor4\" valign=\"baseline\" align=\"left\">");
                    if (field == null) {
                        try {
                            field = fieldTemplate.getEmptyField();
                        }
                        catch (FormException fe) {
                            SilverTrace.error("form", "XmlForm.display", "form.EXP_UNKNOWN_FIELD", null, fe);
                        }
                    }
                    try {
                        fieldDisplayer.display(out, field, fieldTemplate, pc);
                    }
                    catch (FormException fe) {
                        SilverTrace.error("form", "XmlForm.display", "form.EX_CANT_GET_FORM", null, fe);
                    }
                    if (isMandatory && !isDisabled && !isHidden && fieldDisplayer.isDisplayedMandatory() && (!isReadOnly || "jdbcRef".equals(fieldType))) {
                        mandatory = true;
                    }
                    out.println("</td>");
                    out.println("</tr>");
                    out.flush();
                    jw.write(sw.toString());
                    pc.incCurrentFieldIndex(fieldDisplayer.getNbHtmlObjectsDisplayed(fieldTemplate, pc));
                }
                sw = new StringWriter();
                out = new PrintWriter((Writer)sw, true);
                if (mandatory) {
                    out.println("<tr align=\"left\">");
                    out.println("<td colspan=\"2\">");
                    out.println("(<img border=\"0\" src=\"" + Util.getIcon("mandatoryField") + "\" width=\"5\" height=\"5\" alt=\"\"/>&nbsp;:&nbsp;" + Util.getString("GML.requiredField", language) + ")");
                    out.println("</td>");
                    out.println("</tr>");
                }
                if (pagesContext.isBorderPrinted()) {
                    out.println("</table>");
                    out.println("</td>");
                    out.println("</tr>");
                }
                out.println("</table>");
                out.flush();
                jw.write(sw.toString());
            }
            catch (IOException fe) {
                SilverTrace.error("form", "XmlForm.display", "form.EXP_CANT_WRITE", null, fe);
            }
        }
    }

    private TypeManager getTypeManager() {
        return TypeManager.getInstance();
    }
}

