/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.record;

import com.silverpeas.form.DataRecord;
import com.silverpeas.form.Field;
import com.silverpeas.form.FieldDisplayer;
import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.RecordTemplate;
import com.silverpeas.form.TypeManager;
import com.silverpeas.form.record.GenericFieldTemplate;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

public class GenericDataRecord
implements DataRecord,
Serializable {
    private static final long serialVersionUID = 1L;
    private int id = -1;
    private String externalId = null;
    private Field[] fields = null;
    private RecordTemplate template = null;
    private String language = null;
    private Map<String, Field> fieldsByName = null;

    public GenericDataRecord(RecordTemplate template) throws FormException {
        this.template = template;
        String[] fieldNames = template.getFieldNames();
        int size = fieldNames.length;
        this.fields = new Field[size];
        this.fieldsByName = new HashMap<String, Field>();
        for (int i = 0; i < size; ++i) {
            Field field;
            String fieldName = fieldNames[i];
            FieldTemplate fieldTemplate = template.getFieldTemplate(fieldName);
            this.fields[i] = field = fieldTemplate.getEmptyField();
            this.fieldsByName.put(fieldName, field);
        }
    }

    @Override
    public String getId() {
        return this.externalId;
    }

    @Override
    public void setId(String id) {
        this.externalId = id;
    }

    public Field[] getFields() {
        return this.fields;
    }

    @Override
    public Field getField(String fieldName) throws FormException {
        Field result = this.fieldsByName.get(fieldName);
        if (result == null) {
            SilverTrace.warn("form", "GenericDataRecord.getField", "form.EXP_UNKNOWN_FIELD", "fieldName '" + fieldName + "' in DB not found in XML descriptor");
        }
        return result;
    }

    @Override
    public Field getField(int fieldIndex) throws FormException {
        if (fieldIndex >= 0 && fieldIndex < this.fields.length) {
            return this.fields[fieldIndex];
        }
        throw new FormException("DataRecord", "form.EXP_INDEX_OUT_OF_BOUNDS");
    }

    @Override
    public boolean isNew() {
        return this.id == -1;
    }

    int getInternalId() {
        return this.id;
    }

    void setInternalId(int id) {
        this.id = id;
    }

    @Override
    public String[] getFieldNames() {
        return this.template.getFieldNames();
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public void setLanguage(String language) {
        this.language = language;
    }

    @Override
    public Map<String, String> getValues(String language) {
        HashMap<String, String> formValues = new HashMap<String, String>();
        String[] fieldNames = this.getFieldNames();
        PagesContext pageContext = new PagesContext();
        pageContext.setLanguage(language);
        for (String fieldName : fieldNames) {
            try {
                Field field = this.getField(fieldName);
                GenericFieldTemplate fieldTemplate = (GenericFieldTemplate)this.template.getFieldTemplate(fieldName);
                FieldDisplayer fieldDisplayer = TypeManager.getInstance().getDisplayer(fieldTemplate.getTypeName(), "simpletext");
                StringWriter sw = new StringWriter();
                PrintWriter out = new PrintWriter(sw);
                fieldDisplayer.display(out, field, fieldTemplate, pageContext);
                formValues.put(fieldName, sw.toString());
            }
            catch (Exception e) {
                SilverTrace.warn("form", "GenericDataRecord.getValues", "CANT_GET_FIELD_VALUE", "objectId = " + this.externalId + "fieldName = " + fieldName, e);
            }
        }
        return formValues;
    }
}

