/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.record;

import com.silverpeas.form.Field;
import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.FormFatalException;
import com.silverpeas.form.TypeManager;
import com.silverpeas.form.record.Label;
import com.silverpeas.form.record.Parameter;
import com.silverpeas.util.ArrayUtil;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class GenericFieldTemplate
implements FieldTemplate,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String fieldName = null;
    private Class fieldImpl = null;
    private String typeName = null;
    private String displayerName = "";
    private boolean mandatory = false;
    private boolean readOnly = false;
    private boolean disabled = false;
    private boolean hidden = false;
    private String defaultLabel = null;
    private Map<String, String> labels = new HashMap<String, String>();
    private Map<String, String> parameters = new HashMap<String, String>();
    private List<Label> labelsObj = new ArrayList<Label>();
    private List<Parameter> parametersObj = new ArrayList<Parameter>();
    private boolean searchable = false;
    private String templateName = null;
    private boolean usedAsFacet = false;

    public GenericFieldTemplate() {
    }

    public GenericFieldTemplate(String fieldName, String typeName) throws FormException {
        this.fieldName = fieldName;
        this.typeName = typeName;
        this.init();
    }

    public GenericFieldTemplate(String fieldName, Class fieldImpl) throws FormException {
        this.fieldName = fieldName;
        this.fieldImpl = fieldImpl;
        this.init();
    }

    private void init() throws FormException {
        if (this.fieldImpl == null) {
            this.fieldImpl = TypeManager.getInstance().getFieldImplementation(this.typeName);
        }
        Field dummyField = this.getEmptyField();
        if (this.typeName == null) {
            this.typeName = dummyField.getTypeName();
        }
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) throws FormException {
        this.typeName = typeName;
        this.fieldImpl = TypeManager.getInstance().getFieldImplementation(typeName);
    }

    @Override
    public String getDisplayerName() {
        return this.displayerName;
    }

    public void setDisplayerName(String displayerName) {
        this.displayerName = displayerName;
    }

    @Override
    public String getLabel() {
        if (this.defaultLabel != null) {
            return this.defaultLabel;
        }
        return "";
    }

    @Override
    public String getLabel(String language) {
        String label = null;
        if (this.getLabels() != null) {
            label = this.getLabels().get(language);
        }
        if (label == null) {
            return this.getLabel();
        }
        return label;
    }

    public String getParameter(String name, String language) {
        String parameter = null;
        if (this.getParameters(language) != null) {
            parameter = this.getParameters(language).get(name);
        }
        if (parameter == null) {
            return "";
        }
        return parameter;
    }

    public void setLabel(String label) {
        this.defaultLabel = label;
    }

    public void addLabel(String label, String language) {
        if (language == null || language.trim().equals("")) {
            this.setLabel(label);
        } else {
            if (this.labels == null) {
                this.labels = new HashMap<String, String>();
            }
            this.labels.put(language, label);
        }
    }

    public void addParameter(String name, String value) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        this.parameters.put(name, value);
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean isMandatory) {
        this.mandatory = isMandatory;
    }

    public void setMandatory(Boolean isMandatory) {
        this.mandatory = isMandatory;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean isReadOnly) {
        this.readOnly = isReadOnly;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean isDisabled) {
        this.disabled = isDisabled;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean isHidden) {
        this.hidden = isHidden;
    }

    @Override
    public Map<String, String> getParameters(String language) {
        for (Parameter parameter : this.parametersObj) {
            this.addParameter(parameter.getName(), parameter.getValue(language));
        }
        return this.parameters;
    }

    public Map<String, String> getKeyValuePairs(String language) {
        HashMap<String, String> keyValuePairs;
        block5: {
            String values;
            String keys;
            block6: {
                block4: {
                    keyValuePairs = new HashMap<String, String>();
                    Map<String, String> theParameters = this.getParameters(language);
                    if (theParameters == null) {
                        return keyValuePairs;
                    }
                    keys = theParameters.get("keys");
                    values = theParameters.get("values");
                    if (keys == null || values == null) break block4;
                    StringTokenizer kTokenizer = new StringTokenizer(keys, "##");
                    StringTokenizer vTokenizer = new StringTokenizer(values, "##");
                    while (kTokenizer.hasMoreTokens()) {
                        String key = kTokenizer.nextToken();
                        String value = vTokenizer.nextToken();
                        keyValuePairs.put(key, value);
                    }
                    break block5;
                }
                if (keys == null || values != null) break block6;
                StringTokenizer kTokenizer = new StringTokenizer(keys, "##");
                while (kTokenizer.hasMoreTokens()) {
                    String key = kTokenizer.nextToken();
                    keyValuePairs.put(key, key);
                }
                break block5;
            }
            if (keys != null || values == null) break block5;
            StringTokenizer vTokenizer = new StringTokenizer(values, "##");
            while (vTokenizer.hasMoreTokens()) {
                String value = vTokenizer.nextToken();
                keyValuePairs.put(value, value);
            }
        }
        return keyValuePairs;
    }

    public Map<String, String> getLabels() {
        if (this.labels == null || this.labels.isEmpty()) {
            for (Label label : this.labelsObj) {
                this.addLabel(label.getLabel(), label.getLanguage());
            }
        }
        return this.labels;
    }

    @Override
    public Field getEmptyField() throws FormException {
        try {
            Class[] noParameterClass = ArrayUtil.EMPTY_CLASS_ARRAY;
            Constructor constructor = this.fieldImpl.getConstructor(noParameterClass);
            Object[] noParameter = ArrayUtil.EMPTY_OBJECT_ARRAY;
            Field field = (Field)constructor.newInstance(noParameter);
            return field;
        }
        catch (NoSuchMethodException e) {
            throw new FormFatalException("TypeManager", "form.EXP_MISSING_EMPTY_CONSTRUCTOR", this.fieldImpl.getName(), (Exception)e);
        }
        catch (ClassCastException e) {
            throw new FormFatalException("TypeManager", "form.EXP_NOT_A_FIELD", this.fieldImpl.getName(), (Exception)e);
        }
        catch (Exception e) {
            throw new FormFatalException("TypeManager", "form.EXP_FIELD_CONSTRUCTION_FAILED", this.fieldImpl.getName(), e);
        }
    }

    public boolean equals(Object obj) {
        try {
            if (obj instanceof String) {
                return obj.equals(this.getFieldName());
            }
            if (obj instanceof GenericFieldTemplate) {
                return ((GenericFieldTemplate)obj).getFieldName().equals(this.getFieldName());
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public int hashCode() {
        return this.getFieldName().hashCode();
    }

    @Override
    public String[] getLanguages() {
        if (this.labels == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> langs = new ArrayList<String>();
        for (String lang : this.labels.keySet()) {
            langs.add(this.labels.get(lang));
        }
        return langs.toArray(new String[langs.size()]);
    }

    public List<Label> getLabelsObj() {
        return this.labelsObj;
    }

    public void setLabelsObj(List<Label> labelsObj) {
        this.labelsObj = labelsObj;
    }

    @Override
    public List<Parameter> getParametersObj() {
        return this.parametersObj;
    }

    public void setParametersObj(List<Parameter> parametersObj) {
        this.parametersObj = parametersObj;
    }

    @Override
    public boolean isSearchable() {
        return this.searchable;
    }

    public void setSearchable(boolean searchable) {
        this.searchable = searchable;
    }

    @Override
    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    @Override
    public boolean isUsedAsFacet() {
        return this.usedAsFacet;
    }

    public void setUsedAsFacet(boolean usedAsFacet) {
        this.usedAsFacet = usedAsFacet;
    }

    public GenericFieldTemplate clone() {
        GenericFieldTemplate clone = null;
        try {
            clone = new GenericFieldTemplate();
            clone.setDisabled(this.isDisabled());
            clone.setDisplayerName(this.getDisplayerName());
            clone.setFieldName(this.getFieldName());
            clone.setHidden(this.isHidden());
            clone.setLabel(this.getLabel());
            clone.setLabelsObj(this.getLabelsObj());
            clone.setMandatory(this.isMandatory());
            clone.setParametersObj(this.getParametersObj());
            clone.setReadOnly(this.isReadOnly());
            clone.setSearchable(this.isSearchable());
            clone.setTemplateName(this.getTemplateName());
            clone.setTypeName(this.getTypeName());
            clone.setUsedAsFacet(this.isUsedAsFacet());
        }
        catch (FormException e) {
            throw new RuntimeException(e);
        }
        return clone;
    }
}

