/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.jcrutil.converter;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.util.DateUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;

public class ConverterUtil {
    public static final String SPACE_TOKEN = "__";
    public static final String PATH_SEPARATOR = "/";
    private static final String OPENING_BRACKET = "[";
    private static final String CLOSING_BRACKET = "]";

    public static final String encodeJcrPath(String path) {
        return ISO9075.encodePath((String)ConverterUtil.convertToJcrPath(path));
    }

    public static String convertToJcrPath(String name) {
        String coolName = name.replaceAll(" ", SPACE_TOKEN);
        StringBuilder buffer = new StringBuilder(coolName.length() + 10);
        StringTokenizer tokenizer = new StringTokenizer(coolName, PATH_SEPARATOR, true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (PATH_SEPARATOR.equals(token)) {
                buffer.append(token);
                continue;
            }
            buffer.append(Text.escapeIllegalJcrChars((String)token));
        }
        return buffer.toString();
    }

    public static String escapeIllegalJcrChars(String name) {
        return StringUtil.escapeQuote(name).replace(OPENING_BRACKET, " ").replace(CLOSING_BRACKET, " ");
    }

    public static String unescapeQuote(String text) {
        return text.replaceAll("%39", "'");
    }

    public static String convertFromJcrPath(String name) {
        return Text.unescapeIllegalJcrChars((String)name.replaceAll(SPACE_TOKEN, " "));
    }

    public static Date parseDate(String date) throws ParseException {
        return DateUtil.parse(date);
    }

    public static String formatDate(Date date) {
        return DateUtil.formatDate(date);
    }

    public static String formatDate(Calendar calend) {
        return DateUtil.formatDate(calend);
    }

    public static void setTime(Calendar calend, String time) {
        DateUtil.setTime(calend, time);
    }

    public static String formatTime(Date date) {
        return DateUtil.formatTime(date);
    }

    public static String formatTime(Calendar calend) {
        return DateUtil.formatTime(calend);
    }

    public static String formatDateForXpath(Date date) {
        return "xs:dateTime('" + ConverterUtil.getXpathFormattedDate(date) + 'T' + ConverterUtil.getXpathFormattedTime(date) + ConverterUtil.getTimeZone(date) + "')";
    }

    public static String formatCalendarForXpath(Calendar date) {
        return "xs:dateTime('" + ConverterUtil.getXpathFormattedDate(date.getTime()) + 'T' + ConverterUtil.getXpathFormattedTime(date.getTime()) + ConverterUtil.getTimeZone(date.getTime()) + "')";
    }

    protected static String getTimeZone(Date date) {
        SimpleDateFormat xpathTimezoneFormat = new SimpleDateFormat("Z");
        String timeZone = xpathTimezoneFormat.format(date);
        return timeZone.substring(0, timeZone.length() - 2) + ':' + timeZone.substring(timeZone.length() - 2);
    }

    protected static String getXpathFormattedTime(Date date) {
        SimpleDateFormat xpathTimeFormatter = new SimpleDateFormat("HH:mm:ss.SSS");
        return xpathTimeFormatter.format(date);
    }

    protected static String getXpathFormattedDate(Date date) {
        SimpleDateFormat xpathDateFormatter = new SimpleDateFormat("yyyy-MM-dd");
        return xpathDateFormatter.format(date);
    }
}

