/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.notification.delayed;

import com.silverpeas.notification.delayed.DelayedNotification;
import com.silverpeas.notification.delayed.constant.DelayedNotificationFrequency;
import com.silverpeas.notification.delayed.model.DelayedNotificationData;
import com.silverpeas.notification.delayed.model.DelayedNotificationUserSetting;
import com.silverpeas.notification.delayed.repository.DelayedNotificationRepository;
import com.silverpeas.notification.delayed.repository.DelayedNotificationUserSettingRepository;
import com.silverpeas.notification.model.NotificationResourceData;
import com.silverpeas.notification.repository.NotificationResourceRepository;
import com.silverpeas.util.CollectionUtil;
import com.silverpeas.util.MapUtil;
import com.stratelia.silverpeas.notificationManager.constant.NotifChannel;
import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.ResourceLocator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DelayedNotificationManager
implements DelayedNotification {
    private static final Object SYNCHRONIZED = new Object();
    private final ResourceLocator settings = new ResourceLocator("com.stratelia.silverpeas.notificationManager.settings.notificationManagerSettings", "");
    private static Set<DelayedNotificationFrequency> POSSIBLE_FREQUENCIES;
    private static final Set<NotifChannel> WIRED_CHANNELS;
    @Inject
    private DelayedNotificationRepository dnRepository;
    @Inject
    private NotificationResourceRepository nrRepository;
    @Inject
    private DelayedNotificationUserSettingRepository dnUserSettingRepository;

    @Override
    @Transactional(readOnly=true)
    public Map<NotifChannel, List<DelayedNotificationData>> findDelayedNotificationByUserIdGroupByChannel(int userId, Set<NotifChannel> aimedChannels) {
        LinkedHashMap<NotifChannel, List<DelayedNotificationData>> result = new LinkedHashMap<NotifChannel, List<DelayedNotificationData>>();
        for (DelayedNotificationData data : this.dnRepository.findByUserId(userId, NotifChannel.toIds(aimedChannels))) {
            MapUtil.putAddList(result, data.getChannel(), data);
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public List<Integer> findAllUsersToBeNotified(Set<NotifChannel> aimedChannels) {
        return this.dnRepository.findAllUsersToBeNotified(NotifChannel.toIds(aimedChannels));
    }

    @Override
    @Transactional(readOnly=true)
    public List<Integer> findUsersToBeNotified(Date date, Set<NotifChannel> aimedChannels, DelayedNotificationFrequency defaultDelayedNotificationFrequency) {
        Date dateOfDay = DateUtil.getBeginOfDay(date);
        HashSet<DelayedNotificationFrequency> aimedFrequencies = new HashSet<DelayedNotificationFrequency>();
        aimedFrequencies.add(DelayedNotificationFrequency.DAILY);
        if (2 == DateUtil.getDayNumberInWeek(dateOfDay)) {
            aimedFrequencies.add(DelayedNotificationFrequency.WEEKLY);
        }
        if (DateUtil.getFirstDateOfMonth(dateOfDay).compareTo(dateOfDay) == 0) {
            aimedFrequencies.add(DelayedNotificationFrequency.MONTHLY);
        }
        return this.dnRepository.findUsersToBeNotified(aimedChannels, aimedFrequencies, aimedFrequencies.contains((Object)defaultDelayedNotificationFrequency));
    }

    @Override
    public void saveDelayedNotification(DelayedNotificationData delayedNotificationData) {
        if (delayedNotificationData.getResource().getId() == null) {
            NotificationResourceData existingResource = this.getExistingResource(delayedNotificationData.getResource().getResourceId(), delayedNotificationData.getResource().getResourceType(), delayedNotificationData.getResource().getComponentInstanceId());
            if (existingResource != null) {
                existingResource.fillFrom(delayedNotificationData.getResource());
                this.nrRepository.saveAndFlush(existingResource);
                delayedNotificationData.setResource(existingResource);
                if (delayedNotificationData.getId() == null) {
                    List exists = this.dnRepository.findDelayedNotification(delayedNotificationData);
                    if (exists.size() == 1) {
                        delayedNotificationData.setId(((DelayedNotificationData)exists.get(0)).getId());
                    } else {
                        this.dnRepository.saveAndFlush(delayedNotificationData);
                    }
                } else {
                    this.dnRepository.saveAndFlush(delayedNotificationData);
                }
            } else {
                this.nrRepository.save(delayedNotificationData.getResource());
                this.dnRepository.saveAndFlush(delayedNotificationData);
            }
        } else {
            this.dnRepository.saveAndFlush(delayedNotificationData);
        }
    }

    @Override
    public int deleteDelayedNotifications(Collection<Long> ids) {
        int nbDeletes = 0;
        if (CollectionUtil.isNotEmpty(ids)) {
            for (Collection<Long> idLot : CollectionUtil.split(ids)) {
                nbDeletes += this.dnRepository.deleteByIds(idLot);
            }
            this.nrRepository.deleteResources();
            this.dnRepository.flush();
        }
        return nbDeletes;
    }

    @Override
    @Transactional(readOnly=true)
    public NotificationResourceData getExistingResource(String resourceId, String resourceType, String componentInstanceId) {
        return this.nrRepository.getExistingResource(resourceId, resourceType, componentInstanceId);
    }

    @Override
    @Transactional(readOnly=true)
    public DelayedNotificationUserSetting getDelayedNotificationUserSetting(int id) {
        return (DelayedNotificationUserSetting)this.dnUserSettingRepository.findOne(Integer.valueOf(id));
    }

    @Override
    @Transactional(readOnly=true)
    public List<DelayedNotificationUserSetting> findDelayedNotificationUserSettingByUserId(int userId) {
        return this.dnUserSettingRepository.findByUserId(userId);
    }

    @Override
    @Transactional(readOnly=true)
    public DelayedNotificationUserSetting getDelayedNotificationUserSettingByUserIdAndChannel(int userId, NotifChannel channel) {
        List<DelayedNotificationUserSetting> userSettings = this.dnUserSettingRepository.findByUserIdAndChannel(userId, channel.getId());
        DelayedNotificationUserSetting result = null;
        if (!userSettings.isEmpty()) {
            result = userSettings.iterator().next();
        }
        return result;
    }

    @Override
    public DelayedNotificationUserSetting saveDelayedNotificationUserSetting(int userId, NotifChannel channel, DelayedNotificationFrequency frequency) {
        DelayedNotificationUserSetting userSettings = this.getDelayedNotificationUserSettingByUserIdAndChannel(userId, channel);
        if (userSettings == null) {
            userSettings = new DelayedNotificationUserSetting();
            userSettings.setUserId(userId);
            userSettings.setChannel(channel);
        }
        userSettings.setFrequency(frequency);
        this.dnUserSettingRepository.saveAndFlush(userSettings);
        return userSettings;
    }

    @Override
    public void deleteDelayedNotificationUserSetting(int id) {
        this.dnUserSettingRepository.delete(Integer.valueOf(id));
        this.dnUserSettingRepository.flush();
    }

    @Override
    public void deleteDelayedNotificationUserSetting(DelayedNotificationUserSetting delayedNotificationUserSetting) {
        this.dnUserSettingRepository.delete(delayedNotificationUserSetting);
        this.dnUserSettingRepository.flush();
    }

    @Override
    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public Set<NotifChannel> getWiredChannels() {
        return WIRED_CHANNELS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public Set<DelayedNotificationFrequency> getPossibleFrequencies() {
        if (POSSIBLE_FREQUENCIES == null) {
            Object object = SYNCHRONIZED;
            synchronized (object) {
                if (POSSIBLE_FREQUENCIES == null) {
                    HashSet<DelayedNotificationFrequency> possibleFrequencies = new HashSet<DelayedNotificationFrequency>();
                    String frequencyChoiceList = this.settings.getString("DELAYED_NOTIFICATION_FREQUENCY_CHOICE_LIST", "").replaceAll(" ", "");
                    if (StringUtils.isNotBlank((CharSequence)frequencyChoiceList)) {
                        for (String frequencyCode : frequencyChoiceList.split("[,;|]")) {
                            if ("*".equals(frequencyCode)) {
                                possibleFrequencies.addAll(Arrays.asList(DelayedNotificationFrequency.values()));
                                continue;
                            }
                            possibleFrequencies.add(DelayedNotificationFrequency.decode(frequencyCode));
                        }
                    }
                    possibleFrequencies.remove(null);
                    POSSIBLE_FREQUENCIES = new TreeSet<DelayedNotificationFrequency>(possibleFrequencies);
                }
            }
        }
        return POSSIBLE_FREQUENCIES;
    }

    @Override
    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public DelayedNotificationFrequency getDefaultDelayedNotificationFrequency() {
        DelayedNotificationFrequency defaultFrequency = DelayedNotificationFrequency.decode(this.settings.getString("DEFAULT_DELAYED_NOTIFICATION_FREQUENCY"));
        if (defaultFrequency == null) {
            defaultFrequency = DelayedNotificationFrequency.NONE;
        }
        return defaultFrequency;
    }

    @Override
    @Transactional(readOnly=true)
    public DelayedNotificationFrequency getUserFrequency(Integer userId, NotifChannel channel) {
        DelayedNotificationFrequency result = DelayedNotificationFrequency.NONE;
        if (this.getWiredChannels().contains((Object)channel)) {
            DelayedNotificationUserSetting dnus = userId != null ? this.getDelayedNotificationUserSettingByUserIdAndChannel(userId, channel) : null;
            result = dnus == null || !this.getPossibleFrequencies().contains((Object)dnus.getFrequency()) ? this.getDefaultDelayedNotificationFrequency() : dnus.getFrequency();
        }
        return result;
    }

    static {
        WIRED_CHANNELS = new HashSet<NotifChannel>();
        WIRED_CHANNELS.add(NotifChannel.SMTP);
    }
}

