/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.notification.jms;

import com.silverpeas.notification.NotificationPublisher;
import com.silverpeas.notification.NotificationTopic;
import com.silverpeas.notification.PublishingException;
import com.silverpeas.notification.SilverpeasNotification;
import com.silverpeas.notification.jms.access.JMSAccessObject;
import com.silverpeas.util.ExecutionAttempts;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.TopicPublisher;

@Named(value="notificationPublisher")
public class JMSPublishingService
implements NotificationPublisher {
    @Inject
    private JMSAccessObject jmsService;

    @Override
    public void publish(final SilverpeasNotification notification, final NotificationTopic onTopic) {
        try {
            ExecutionAttempts.retry(2, new ExecutionAttempts.Job(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void execute() throws Exception {
                    TopicPublisher publisher = null;
                    try {
                        String topicName = onTopic.getName();
                        publisher = JMSPublishingService.this.jmsService.createTopicPublisher(topicName);
                        ObjectMessage message = JMSPublishingService.this.jmsService.createObjectMessageFor(publisher);
                        message.setObject((Serializable)notification);
                        publisher.publish((Message)message);
                    }
                    finally {
                        try {
                            if (publisher != null) {
                                JMSPublishingService.this.jmsService.disposeTopicPublisher(publisher);
                            }
                        }
                        catch (JMSException ex) {
                            Logger.getLogger(JMSPublishingService.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
            });
        }
        catch (Exception ex) {
            throw new PublishingException(ex);
        }
    }
}

