/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.notification.jms;

import com.silverpeas.notification.NotificationSubscriber;
import com.silverpeas.notification.NotificationTopic;
import com.silverpeas.notification.PublishingException;
import com.silverpeas.notification.SilverpeasNotification;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;

public class SilverpeasMessageListener
implements MessageListener {
    private NotificationSubscriber subscriber;
    private String topic;

    public static SilverpeasMessageListener mapMessageListenerTo(NotificationSubscriber theSubscriber) {
        return new SilverpeasMessageListener(theSubscriber);
    }

    public void onMessage(Message msg) {
        ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            ObjectMessage message = (ObjectMessage)msg;
            SilverpeasNotification notification = (SilverpeasNotification)message.getObject();
            this.subscriber.onNotification(notification, NotificationTopic.onTopic(this.topic));
        }
        catch (JMSException ex) {
            throw new PublishingException(ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalTCCL);
        }
    }

    public SilverpeasMessageListener forTopic(String topicName) {
        this.topic = topicName;
        return this;
    }

    public String getTopic() {
        return this.topic;
    }

    private SilverpeasMessageListener(NotificationSubscriber subscriber) {
        this.subscriber = subscriber;
    }
}

