/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.publicationTemplate;

import com.silverpeas.form.AbstractForm;
import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.Form;
import com.silverpeas.form.FormException;
import com.silverpeas.form.RecordSet;
import com.silverpeas.form.RecordTemplate;
import com.silverpeas.form.dummy.DummyRecordSet;
import com.silverpeas.form.dummy.DummyRecordTemplate;
import com.silverpeas.form.form.HtmlForm;
import com.silverpeas.form.form.XmlForm;
import com.silverpeas.form.form.XmlSearchForm;
import com.silverpeas.form.record.GenericFieldTemplate;
import com.silverpeas.form.record.GenericRecordSetManager;
import com.silverpeas.form.record.GenericRecordTemplate;
import com.silverpeas.publicationTemplate.PublicationTemplate;
import com.silverpeas.publicationTemplate.PublicationTemplateException;
import com.silverpeas.publicationTemplate.PublicationTemplateManager;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.FileRepositoryManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.xml.sax.InputSource;

@XmlRootElement(name="publicationTemplate")
@XmlAccessorType(value=XmlAccessType.NONE)
public class PublicationTemplateImpl
implements PublicationTemplate {
    @XmlElement(required=true)
    private String name = "";
    @XmlElement
    private String description = "";
    @XmlElement(name="image")
    private String thumbnail = "";
    @XmlElement(required=true, defaultValue="false")
    private boolean visible = false;
    @XmlElement(required=true, defaultValue="false")
    private boolean dataEncrypted = false;
    @XmlElementWrapper(name="spaces")
    @XmlElement(name="space")
    private List<String> spaces;
    @XmlElementWrapper(name="applications")
    @XmlElement(name="application")
    private List<String> applications;
    @XmlElementWrapper(name="instances")
    @XmlElement(name="instance")
    private List<String> instances;
    @XmlElement
    private String viewFileName = "";
    @XmlElement
    private String updateFileName = "";
    @XmlElement
    private String searchFileName = "";
    @XmlElement
    private String dataFileName = "";
    @XmlElement
    private String viewTypeFile = "";
    @XmlElement
    private String updateTypeFile = "";
    private String fileName = "";
    private String externalId = "";
    private String searchResultFileName = "";
    private RecordTemplate template = null;
    private RecordTemplate searchTemplate = null;
    private RecordTemplate viewTemplate = null;
    private RecordTemplate updateTemplate = null;
    private RecordTemplate searchResultTemplate = null;
    private RecordSet recordSet = null;
    private Form updateForm = null;
    private Form viewForm = null;
    private Form searchResultForm = null;
    public static final int LAYER_ACTION_NONE = 0;
    public static final int LAYER_ACTION_ADD = 1;
    public static final int LAYER_ACTION_REMOVE = 2;
    private int viewLayerAction = 0;
    private int updateLayerAction = 0;
    private String viewLayerFileName = "";
    private String updateLayerFileName = "";

    public RecordTemplate getRecordTemplate(boolean loadIfNull) throws PublicationTemplateException {
        if (this.template != null || !loadIfNull) {
            return this.template;
        }
        RecordTemplate tmpl = this.loadRecordTemplate(this.dataFileName);
        if (tmpl != null && !(tmpl instanceof DummyRecordTemplate)) {
            this.template = tmpl;
        }
        return tmpl;
    }

    @Override
    public RecordTemplate getRecordTemplate() throws PublicationTemplateException {
        return this.getRecordTemplate(true);
    }

    @Override
    public RecordSet getRecordSet() throws PublicationTemplateException {
        try {
            if (this.recordSet != null) {
                return this.recordSet;
            }
            RecordSet rs = this.getGenericRecordSetManager().getRecordSet(this.externalId);
            if (rs != null && !(rs instanceof DummyRecordSet)) {
                this.recordSet = rs;
            }
            if (this.template != null && rs instanceof DummyRecordSet) {
                rs = new DummyRecordSet(this.template);
            }
            return rs;
        }
        catch (FormException e) {
            throw new PublicationTemplateException("PublicationTemplateImpl.getUpdateForm", "form.EX_CANT_GET_RECORDSET", null, (Exception)e);
        }
    }

    @Override
    public Form getUpdateForm() throws PublicationTemplateException {
        if (this.updateForm == null) {
            this.updateForm = this.getForm(this.updateFileName, this.updateTypeFile);
        }
        return this.updateForm;
    }

    @Override
    public Form getViewForm() throws PublicationTemplateException {
        if (this.viewForm == null) {
            this.viewForm = this.getForm(this.viewFileName, this.viewTypeFile);
        }
        return this.viewForm;
    }

    public RecordTemplate getSearchTemplate(boolean loadIfNull) throws PublicationTemplateException {
        if (this.searchTemplate == null && loadIfNull) {
            this.searchTemplate = this.loadRecordTemplate(this.searchFileName);
        }
        return this.searchTemplate;
    }

    public RecordTemplate getSearchTemplate() throws PublicationTemplateException {
        return this.getSearchTemplate(true);
    }

    public RecordTemplate getViewTemplate() throws PublicationTemplateException {
        return this.viewTemplate;
    }

    public RecordTemplate getUpdateTemplate() throws PublicationTemplateException {
        return this.updateTemplate;
    }

    public RecordTemplate getDataTemplate() throws PublicationTemplateException {
        return this.getRecordTemplate(false);
    }

    @Override
    public Form getSearchForm() throws PublicationTemplateException {
        XmlSearchForm searchForm = null;
        if (this.isSearchable()) {
            RecordTemplate templateForm = this.loadRecordTemplate(this.searchFileName);
            try {
                searchForm = new XmlSearchForm(templateForm);
            }
            catch (FormException e) {
                throw new PublicationTemplateException("PublicationTemplateImpl.getUpdateForm", "form.EX_CANT_GET_FORM", null, (Exception)e);
            }
        }
        return searchForm;
    }

    private Form getForm(String fileName, String fileType) throws PublicationTemplateException {
        AbstractForm form = null;
        String currentFileName = fileName;
        String typeFile = FileRepositoryManager.getFileExtension(currentFileName);
        if (StringUtil.isDefined(fileType)) {
            typeFile = fileType.trim().toLowerCase();
        }
        if (StringUtil.isDefined(currentFileName) && "xml".equals(typeFile)) {
            RecordTemplate templateForm = this.loadRecordTemplate(currentFileName);
            this.mergeTemplate(templateForm);
            try {
                form = new XmlForm(templateForm);
            }
            catch (FormException e) {
                throw new PublicationTemplateException("PublicationTemplateImpl.getForm", "form.EX_CANT_GET_FORM", null, (Exception)e);
            }
        }
        String htmlFileName = PublicationTemplateManager.makePath(PublicationTemplateManager.templateDir, currentFileName);
        currentFileName = currentFileName.replaceAll(".html", ".xml");
        RecordTemplate templateForm = this.loadRecordTemplate(currentFileName);
        this.mergeTemplate(templateForm);
        try {
            HtmlForm viewFormHtml = new HtmlForm(templateForm);
            viewFormHtml.setFileName(htmlFileName);
            form = viewFormHtml;
        }
        catch (FormException e) {
            throw new PublicationTemplateException("PublicationTemplateImpl.getForm", "form.EX_CANT_GET_FORM", null, (Exception)e);
        }
        return form;
    }

    private void mergeTemplate(RecordTemplate formTemplate) throws PublicationTemplateException {
        RecordTemplate dataTemplate = this.getRecordTemplate();
        if (formTemplate != null && dataTemplate != null) {
            for (String fieldName : formTemplate.getFieldNames()) {
                SilverTrace.info("form", "PublicationTemplateImpl.mergeTemplates", "root.MSG_GEN_PARAM_VALUE", "fieldName = " + fieldName);
                try {
                    GenericFieldTemplate formFieldTemplate = (GenericFieldTemplate)formTemplate.getFieldTemplate(fieldName);
                    GenericFieldTemplate dataFieldTemplate = (GenericFieldTemplate)dataTemplate.getFieldTemplate(fieldName);
                    formFieldTemplate.setTypeName(dataFieldTemplate.getTypeName());
                    formFieldTemplate.setParametersObj(dataFieldTemplate.getParametersObj());
                }
                catch (FormException e) {
                    SilverTrace.error("form", "PublicationTemplateImpl.mergeTemplates", "form.EXP_UNKNOWN_FIELD", null, e);
                }
            }
        }
    }

    public void setViewFileName(String viewFileName) {
        this.viewFileName = viewFileName;
    }

    public String getViewFileName() {
        return this.viewFileName;
    }

    public void setUpdateFileName(String updateFileName) {
        this.updateFileName = updateFileName;
    }

    public String getUpdateTypeFile() {
        return this.updateTypeFile;
    }

    public void setUpdateTypeFile(String updateTypeFile) {
        this.updateTypeFile = updateTypeFile;
    }

    public String getViewTypeFile() {
        return this.viewTypeFile;
    }

    public void setViewTypeFile(String viewTypeFile) {
        this.viewTypeFile = viewTypeFile;
    }

    public String getUpdateFileName() {
        return this.updateFileName;
    }

    public void setDataFileName(String dataFileName) {
        this.dataFileName = dataFileName;
    }

    public String getDataFileName() {
        return this.dataFileName;
    }

    @Override
    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    @Override
    public String getExternalId() {
        return this.externalId;
    }

    public RecordTemplate loadRecordTemplate(String xmlFileName) throws PublicationTemplateException {
        if (!StringUtil.isDefined(xmlFileName)) {
            return null;
        }
        Mapping mapping = new Mapping();
        try {
            String filePath = PublicationTemplateManager.makePath(PublicationTemplateManager.templateDir, xmlFileName);
            mapping.loadMapping(PublicationTemplateManager.mappingRecordTemplateFilePath);
            Unmarshaller unmar = new Unmarshaller(mapping);
            GenericRecordTemplate recordTemplate = (GenericRecordTemplate)unmar.unmarshal(new InputSource(new FileInputStream(filePath)));
            recordTemplate.setTemplateName(this.fileName.substring(0, this.fileName.lastIndexOf(46)));
            return recordTemplate;
        }
        catch (MappingException me) {
            throw new PublicationTemplateException("PublicationTemplateImpl.loadPublicationTemplate", "form.EX_ERR_CASTOR_LOAD_XML_MAPPING", "Publication Template FileName : " + xmlFileName, (Exception)((Object)me));
        }
        catch (MarshalException me) {
            throw new PublicationTemplateException("PublicationTemplateImpl.loadPublicationTemplate", "form.EX_ERR_CASTOR_UNMARSHALL_PUBLICATION_TEMPLATE", "Publication Template FileName : " + xmlFileName, (Exception)((Object)me));
        }
        catch (ValidationException ve) {
            throw new PublicationTemplateException("PublicationTemplateImpl.loadPublicationTemplate", "form.EX_ERR_CASTOR_INVALID_XML_PUBLICATION_TEMPLATE", "Publication Template FileName : " + xmlFileName, (Exception)((Object)ve));
        }
        catch (IOException ioe) {
            throw new PublicationTemplateException("PublicationTemplateImpl.loadPublicationTemplate", "form.EX_ERR_CASTOR_LOAD_PUBLICATION_TEMPLATE", "Publication Template FileName : " + xmlFileName, (Exception)ioe);
        }
    }

    public void saveRecordTemplates() throws PublicationTemplateException {
        String subDir = this.fileName.substring(0, this.fileName.lastIndexOf(46)) + File.separator;
        if (this.template != null) {
            this.saveRecordTemplate(this.template, subDir, "data.xml");
        }
        if (this.viewTemplate != null) {
            this.saveRecordTemplate(this.viewTemplate, subDir, "view.xml");
        }
        if (this.updateTemplate != null) {
            this.saveRecordTemplate(this.updateTemplate, subDir, "update.xml");
        }
        if (this.searchTemplate != null) {
            this.saveRecordTemplate(this.searchTemplate, subDir, "search.xml");
        }
        if (this.searchResultTemplate != null) {
            this.saveRecordTemplate(this.searchResultTemplate, subDir, "searchresult.xml");
        }
    }

    private void saveRecordTemplate(RecordTemplate recordTemplate, String subDir, String xmlFileName) throws PublicationTemplateException {
        Mapping mapping = new Mapping();
        try {
            String xmlFilePath = PublicationTemplateManager.makePath(PublicationTemplateManager.templateDir, subDir + xmlFileName);
            mapping.loadMapping(PublicationTemplateManager.mappingRecordTemplateFilePath);
            String encoding = "UTF-8";
            FileOutputStream fos = new FileOutputStream(xmlFilePath);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, encoding);
            Marshaller mar = new Marshaller((Writer)osw);
            mar.setEncoding(encoding);
            mar.setMapping(mapping);
            mar.marshal((Object)recordTemplate);
        }
        catch (MappingException me) {
            throw new PublicationTemplateException("PublicationTemplateImpl.loadPublicationTemplate", "form.EX_ERR_CASTOR_LOAD_XML_MAPPING", "Publication Template FileName : " + xmlFileName, (Exception)((Object)me));
        }
        catch (MarshalException me) {
            throw new PublicationTemplateException("PublicationTemplateImpl.loadPublicationTemplate", "form.EX_ERR_CASTOR_UNMARSHALL_PUBLICATION_TEMPLATE", "Publication Template FileName : " + xmlFileName, (Exception)((Object)me));
        }
        catch (ValidationException ve) {
            throw new PublicationTemplateException("PublicationTemplateImpl.loadPublicationTemplate", "form.EX_ERR_CASTOR_INVALID_XML_PUBLICATION_TEMPLATE", "Publication Template FileName : " + xmlFileName, (Exception)((Object)ve));
        }
        catch (IOException ioe) {
            throw new PublicationTemplateException("PublicationTemplateImpl.loadPublicationTemplate", "form.EX_ERR_CASTOR_LOAD_PUBLICATION_TEMPLATE", "Publication Template FileName : " + xmlFileName, (Exception)ioe);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(String thumbnail) {
        this.thumbnail = thumbnail;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public String getSearchFileName() {
        return this.searchFileName;
    }

    public void setSearchFileName(String searchFileName) {
        this.searchFileName = searchFileName;
    }

    public void setSearchTemplate(RecordTemplate searchTemplate) {
        this.searchTemplate = searchTemplate;
    }

    public void setTemplate(RecordTemplate template) {
        this.template = template;
    }

    public void setUpdateTemplate(RecordTemplate updateTemplate) {
        this.updateTemplate = updateTemplate;
    }

    public void setViewTemplate(RecordTemplate viewTemplate) {
        this.viewTemplate = viewTemplate;
    }

    public String getSearchResultFileName() {
        return this.searchResultFileName;
    }

    public void setSearchResultFileName(String searchResultFileName) {
        this.searchResultFileName = searchResultFileName;
    }

    @Override
    public boolean isSearchable() {
        return this.searchFileName != null && this.searchFileName.trim().length() > 0;
    }

    public RecordTemplate getSearchResultTemplate() {
        return this.searchResultTemplate;
    }

    public void setSearchResultTemplate(RecordTemplate searchResultTemplate) {
        this.searchResultTemplate = searchResultTemplate;
    }

    public PublicationTemplateImpl basicClone() {
        PublicationTemplateImpl cloneTemplate = new PublicationTemplateImpl();
        cloneTemplate.setName(this.getName());
        cloneTemplate.setDescription(this.getDescription());
        cloneTemplate.setThumbnail(this.getThumbnail());
        cloneTemplate.setFileName(this.getFileName());
        cloneTemplate.setVisible(this.isVisible());
        cloneTemplate.setDataEncrypted(this.isDataEncrypted());
        cloneTemplate.setViewFileName(this.getViewFileName());
        cloneTemplate.setUpdateFileName(this.getUpdateFileName());
        cloneTemplate.setSearchFileName(this.getSearchFileName());
        cloneTemplate.setDataFileName(this.getDataFileName());
        cloneTemplate.setViewTypeFile(this.getViewTypeFile());
        cloneTemplate.setUpdateTypeFile(this.getUpdateTypeFile());
        cloneTemplate.setExternalId(this.getExternalId());
        cloneTemplate.setSearchResultFileName(this.getSearchResultFileName());
        cloneTemplate.setSpaces(this.getSpaces());
        cloneTemplate.setApplications(this.getApplications());
        cloneTemplate.setInstances(this.getInstances());
        return cloneTemplate;
    }

    protected GenericRecordSetManager getGenericRecordSetManager() {
        return GenericRecordSetManager.getInstance();
    }

    @Override
    public Form getSearchResultForm() throws PublicationTemplateException {
        if (this.searchResultForm == null) {
            this.searchResultForm = this.getForm(this.searchResultFileName, null);
        }
        return this.searchResultForm;
    }

    @Override
    public List<String> getFieldsForFacets() {
        ArrayList<String> fieldNames = new ArrayList<String>();
        try {
            FieldTemplate[] fieldTemplates;
            for (FieldTemplate fieldTemplate : fieldTemplates = this.getRecordTemplate().getFieldTemplates()) {
                if (!fieldTemplate.isUsedAsFacet()) continue;
                fieldNames.add(fieldTemplate.getFieldName());
            }
        }
        catch (Exception e) {
            SilverTrace.warn("form", "PublicationTemplateImpl.getFieldsForFacets", "form.CANT_GET_FIELDS_FOR_FACETS", e);
        }
        return fieldNames;
    }

    @Override
    public List<String> getSpaces() {
        return this.spaces;
    }

    @Override
    public boolean isRestrictedVisibilityToSpace() {
        return this.getSpaces() != null && !this.getSpaces().isEmpty();
    }

    @Override
    public boolean isRestrictedVisibilityToApplication() {
        return this.getApplications() != null && !this.getApplications().isEmpty();
    }

    @Override
    public boolean isRestrictedVisibilityToInstance() {
        return this.getInstances() != null && !this.getInstances().isEmpty();
    }

    public void setSpaces(List<String> spaces) {
        this.spaces = spaces;
    }

    @Override
    public List<String> getApplications() {
        return this.applications;
    }

    public void setApplications(List<String> applications) {
        this.applications = applications;
    }

    @Override
    public List<String> getInstances() {
        return this.instances;
    }

    public void setInstances(List<String> instances) {
        this.instances = instances;
    }

    @Override
    public boolean isRestrictedVisibility() {
        return this.isRestrictedVisibilityToSpace() || this.isRestrictedVisibilityToApplication() || this.isRestrictedVisibilityToInstance();
    }

    public void setDataEncrypted(boolean dataEncrypted) {
        this.dataEncrypted = dataEncrypted;
    }

    @Override
    public boolean isDataEncrypted() {
        return this.dataEncrypted;
    }

    public int getViewLayerAction() {
        return this.viewLayerAction;
    }

    public void setViewLayerAction(int viewLayerAction) {
        this.viewLayerAction = viewLayerAction;
    }

    public int getUpdateLayerAction() {
        return this.updateLayerAction;
    }

    public void setUpdateLayerAction(int updateLayerAction) {
        this.updateLayerAction = updateLayerAction;
    }

    public String getViewLayerFileName() {
        return this.viewLayerFileName;
    }

    public void setViewLayerFileName(String viewLayerFileName) {
        this.viewLayerFileName = viewLayerFileName;
    }

    public String getUpdateLayerFileName() {
        return this.updateLayerFileName;
    }

    public void setUpdateLayerFileName(String updateLayerFileName) {
        this.updateLayerFileName = updateLayerFileName;
    }

    public boolean isViewLayerDefined() {
        return StringUtil.isDefined(this.viewLayerFileName);
    }

    public boolean isUpdateLayerDefined() {
        return StringUtil.isDefined(this.updateLayerFileName);
    }

    @Override
    public boolean isViewLayerExist() {
        return this.getViewFileName().endsWith(".html");
    }

    @Override
    public boolean isUpdateLayerExist() {
        return this.getUpdateFileName().endsWith(".html");
    }
}

