/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.session;

import com.stratelia.webactiv.beans.admin.UserDetail;
import java.util.HashMap;
import java.util.Map;

public class SessionInfo {
    private String sessionId;
    private String ipAddress;
    private UserDetail userDetail;
    private long openingTimestamp;
    private long lastAccessTimestamp;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private long idleTimestamp;

    public SessionInfo(String sessionId, UserDetail user) {
        this.sessionId = sessionId;
        this.userDetail = user;
        this.openingTimestamp = this.lastAccessTimestamp = System.currentTimeMillis();
        this.idleTimestamp = 0L;
    }

    public void setIPAddress(String ip) {
        this.ipAddress = ip;
    }

    public String getIPAddress() {
        return this.ipAddress;
    }

    public long getLastAccessTimestamp() {
        return this.lastAccessTimestamp;
    }

    public long getOpeningTimestamp() {
        return this.openingTimestamp;
    }

    public long getLastIdleDuration() {
        return System.currentTimeMillis() - this.idleTimestamp;
    }

    public void setAsIdle() {
        this.idleTimestamp = System.currentTimeMillis();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public UserDetail getUserDetail() {
        return this.userDetail;
    }

    public void updateLastAccess() {
        this.lastAccessTimestamp = System.currentTimeMillis();
        this.idleTimestamp = 0L;
    }

    public <T> void setAttribute(String name, T value) {
        this.attributes.put(name, value);
    }

    public <T> T getAttribute(String name) {
        return (T)this.attributes.get(name);
    }

    public void unsetAttribute(String name) {
        this.attributes.remove(name);
    }

    public void onClosed() {
        this.attributes.clear();
    }
}

