/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.socialnetwork.provider;

import com.silverpeas.calendar.Date;
import com.silverpeas.socialnetwork.SocialNetworkException;
import com.silverpeas.socialnetwork.model.SocialInformation;
import com.silverpeas.socialnetwork.model.SocialInformationType;
import com.silverpeas.socialnetwork.provider.ProviderSwitchInterface;
import com.silverpeas.socialnetwork.provider.SocialEventsInterface;
import com.silverpeas.socialnetwork.provider.SocialGalleryInterface;
import com.silverpeas.socialnetwork.provider.SocialPublicationsInterface;
import com.silverpeas.socialnetwork.provider.SocialRelationShipsInterface;
import com.silverpeas.socialnetwork.provider.SocialStatusInterface;
import com.stratelia.webactiv.util.exception.SilverpeasException;
import java.util.ArrayList;
import java.util.List;

public class ProviderSwitch
implements ProviderSwitchInterface {
    private SocialEventsInterface socialEventsInterface;
    private SocialGalleryInterface socialGalleryInterface;
    private SocialPublicationsInterface socialPublicationsInterface;
    private SocialStatusInterface socialStatusInterface;
    private SocialRelationShipsInterface socialRelationShipsInterface;

    @Override
    public SocialEventsInterface getSocialEventsInterface() {
        return this.socialEventsInterface;
    }

    @Override
    public void setSocialEventsInterface(SocialEventsInterface socialEventsInterface) {
        this.socialEventsInterface = socialEventsInterface;
    }

    @Override
    public SocialGalleryInterface getSocialGalleryInterface() {
        return this.socialGalleryInterface;
    }

    @Override
    public void setSocialGalleryInterface(SocialGalleryInterface socialGalleryInterface) {
        this.socialGalleryInterface = socialGalleryInterface;
    }

    @Override
    public List<SocialInformation> getSocialInformationsList(SocialInformationType socialInformationType, String userId, String classification, Date begin, Date end) throws SocialNetworkException {
        List<SocialInformation> listResult = new ArrayList<SocialInformation>();
        try {
            switch (socialInformationType) {
                case EVENT: {
                    listResult = this.getSocialEventsInterface().getSocialInformationsList(userId, classification, begin, end);
                    break;
                }
                case PHOTO: {
                    listResult = this.getSocialGalleryInterface().getSocialInformationsList(userId, begin, end);
                    break;
                }
                case PUBLICATION: {
                    listResult = this.getSocialPublicationsInterface().getSocialInformationsList(userId, begin, end);
                    break;
                }
                case STATUS: {
                    listResult = this.getSocialStatusInterface().getSocialInformationsList(userId, begin, end);
                    break;
                }
                case RELATIONSHIP: {
                    listResult = this.getSocialRelationShipsInterface().getSocialInformationsList(userId, begin, end);
                    break;
                }
                case LASTEVENT: {
                    listResult = this.getSocialEventsInterface().getMyLastSocialInformationsList(userId, begin, end);
                    break;
                }
                case ALL: {
                    for (SocialInformationType type : SocialInformationType.values()) {
                        List<SocialInformation> listAll;
                        if (SocialInformationType.ALL == type || SocialInformationType.EVENT == type || (listAll = this.getSocialInformationsList(type, userId, classification, begin, end)) == null) continue;
                        listResult.addAll(listAll);
                    }
                    break;
                }
            }
        }
        catch (SilverpeasException ex) {
            throw new SocialNetworkException("ProviderSwitch.getSocialInformationsList", 4, "root.EX_CANT_GET_REMOTE_OBJECT", ex);
        }
        return listResult;
    }

    @Override
    public SocialPublicationsInterface getSocialPublicationsInterface() {
        return this.socialPublicationsInterface;
    }

    @Override
    public void setSocialPublicationsInterface(SocialPublicationsInterface socialPublicationsInterface) {
        this.socialPublicationsInterface = socialPublicationsInterface;
    }

    @Override
    public SocialStatusInterface getSocialStatusInterface() {
        return this.socialStatusInterface;
    }

    @Override
    public void setSocialStatusInterface(SocialStatusInterface socialStatusInterface) {
        this.socialStatusInterface = socialStatusInterface;
    }

    @Override
    public void setSocialRelationShipsInterface(SocialRelationShipsInterface socialRelationShipsInterface) {
        this.socialRelationShipsInterface = socialRelationShipsInterface;
    }

    @Override
    public SocialRelationShipsInterface getSocialRelationShipsInterface() {
        return this.socialRelationShipsInterface;
    }

    @Override
    public List<SocialInformation> getSocialInformationsListOfMyContacts(SocialInformationType socialInformationType, String myId, List<String> myContactsIds, Date begin, Date end) throws SilverpeasException {
        List<SocialInformation> list = new ArrayList<SocialInformation>();
        try {
            switch (socialInformationType) {
                case EVENT: {
                    list = this.getSocialEventsInterface().getSocialInformationsListOfMyContacts(myId, myContactsIds, begin, end);
                    break;
                }
                case PHOTO: {
                    list = this.getSocialGalleryInterface().getSocialInformationsListOfMyContacts(myId, myContactsIds, begin, end);
                    break;
                }
                case PUBLICATION: {
                    list = this.getSocialPublicationsInterface().getSocialInformationsListOfMyContacts(myId, myContactsIds, begin, end);
                    break;
                }
                case STATUS: {
                    list = this.getSocialStatusInterface().getSocialInformationsListOfMyContacts(myContactsIds, begin, end);
                    break;
                }
                case RELATIONSHIP: {
                    list = this.getSocialRelationShipsInterface().getSocialInformationsListOfMyContacts(myId, myContactsIds, begin, end);
                    break;
                }
                case LASTEVENT: {
                    list = this.getSocialEventsInterface().getLastSocialInformationsListOfMyContacts(myId, myContactsIds, begin, end);
                    break;
                }
                case ALL: {
                    for (SocialInformationType type : SocialInformationType.values()) {
                        List<SocialInformation> listAll;
                        if (SocialInformationType.ALL == type || SocialInformationType.EVENT == type || (listAll = this.getSocialInformationsListOfMyContacts(type, myId, myContactsIds, begin, end)) == null) continue;
                        list.addAll(listAll);
                    }
                    break;
                }
            }
        }
        catch (SilverpeasException ex) {
            throw new SocialNetworkException("ProviderSwitch.getSocialInformationsListOfMyContacts", 4, "root.EX_CANT_GET_REMOTE_OBJECT", ex);
        }
        return list;
    }
}

