/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.socialnetwork.status;

import com.silverpeas.socialnetwork.model.SocialInformation;
import com.silverpeas.socialnetwork.model.SocialInformationType;
import com.silverpeas.socialnetwork.status.Status;
import java.sql.Timestamp;
import java.util.Date;

public class SocialInformationStatus
implements SocialInformation {
    private final SocialInformationType type = SocialInformationType.STATUS;
    private String title;
    private String description;
    private String author;
    private Timestamp date;
    private String url;
    private String icon;

    public SocialInformationStatus(Status status) {
        this.description = status.getDescription();
        this.title = this.author = Integer.toString(status.getUserId());
        this.date = new Timestamp(status.getCreationDate().getTime());
        this.url = "#";
        this.icon = this.type.toString() + ".gif";
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public boolean isUpdeted() {
        return false;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getType() {
        return this.type.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.author == null ? 0 : this.author.hashCode());
        result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.icon == null ? 0 : this.icon.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SocialInformationStatus)) {
            return false;
        }
        SocialInformationStatus other = (SocialInformationStatus)obj;
        if (this.author == null ? other.author != null : !this.author.equals(other.author)) {
            return false;
        }
        if (this.date == null ? other.date != null : !this.date.equals(other.date)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.icon == null ? other.icon != null : !this.icon.equals(other.icon)) {
            return false;
        }
        if (this.title == null ? other.title != null : !this.title.equals(other.title)) {
            return false;
        }
        if (this.type == null ? other.type != null : this.type != other.type) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }

    @Override
    public int compareTo(SocialInformation o) {
        return this.getDate().compareTo(o.getDate()) * -1;
    }
}

