/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.util;

import com.silverpeas.util.ExtractionComplexList;
import com.silverpeas.util.ExtractionList;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtils;

public class CollectionUtil {
    public static <T> boolean isEmpty(Collection<T> collection) {
        return !CollectionUtil.isNotEmpty(collection);
    }

    public static <T> boolean isNotEmpty(Collection<T> collection) {
        return collection != null && !collection.isEmpty();
    }

    public static <T> Collection<Collection<T>> split(Collection<T> collection) {
        return CollectionUtil.split(collection, 500);
    }

    public static <T> Collection<Collection<T>> split(Collection<T> collection, int collectionSizeMax) {
        List<Collection<T>> result = null;
        try {
            if (CollectionUtil.isNotEmpty(collection)) {
                if (collectionSizeMax > 0 && collection.size() > collectionSizeMax) {
                    int size = collection.size() / collectionSizeMax;
                    if (collection.size() % collectionSizeMax != 0) {
                        ++size;
                    }
                    result = new ArrayList<Collection<T>>(size);
                    ArrayList<T> curLot = null;
                    for (T element : collection) {
                        if (curLot == null || curLot.size() >= collectionSizeMax) {
                            curLot = new ArrayList<T>(collectionSizeMax);
                            result.add(curLot);
                        }
                        curLot.add(element);
                    }
                } else {
                    result = Collections.singletonList(collection);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (result == null) {
                result = new ArrayList<Collection<T>>();
            }
        }
        return result;
    }

    public static <T, K, V> HashMap<K, V> listToMap(Collection<T> collection, ExtractionList<T, K, V> extractor) {
        LinkedHashMap<K, V> result;
        if (collection == null) {
            result = null;
        } else if (collection.isEmpty()) {
            result = new LinkedHashMap<K, V>();
        } else {
            result = new LinkedHashMap((int)((float)collection.size() * 0.75f));
            if (extractor instanceof ExtractionComplexList) {
                ((ExtractionComplexList)extractor).setMap(result);
            }
            for (T toPerform : collection) {
                result.put(extractor.getKey(toPerform), extractor.getValue(toPerform));
            }
        }
        return result;
    }

    public static <T> Collection<T> extractFrom(Class<T> aClass, Collection<?> collection, String propertyName) {
        return CollectionUtil.extractFrom(collection, propertyName, false, 0);
    }

    public static <T> Collection<T> extractFrom(Collection<?> collection, String propertyName) {
        return CollectionUtil.extractFrom(collection, propertyName, false, 0);
    }

    public static <T> Collection<T> extractFrom(Collection<?> collection, String propertyName, boolean isListOfArray, int numberColumn) {
        HashSet<Object> result;
        block4: {
            result = null;
            if (collection == null) break block4;
            result = new HashSet<Object>(collection.size());
            if (!isListOfArray) {
                for (Object object : collection) {
                    result.add(CollectionUtil.getPropertyAsObject(object, propertyName));
                }
            } else {
                for (Object[] myObject : collection) {
                    result.add(myObject[numberColumn]);
                }
            }
        }
        return result;
    }

    public static <T> Collection<T> extractFrom(Class<T> aClass, Collection<?> collection, String propertyNameToExtract, String propertyNameToCompare, Object givenValueToCompare, boolean nullValueExtracted) {
        HashSet<Object> result = null;
        if (collection != null) {
            result = new HashSet<Object>(collection.size());
            for (Object element : collection) {
                Object valueToExtract;
                Object valueToCompare = CollectionUtil.getPropertyAsObject(element, propertyNameToCompare);
                if ((givenValueToCompare != null || valueToCompare != null) && (givenValueToCompare == null || !givenValueToCompare.equals(valueToCompare)) || (valueToExtract = CollectionUtil.getPropertyAsObject(element, propertyNameToExtract)) == null && !nullValueExtracted) continue;
                result.add(valueToExtract);
            }
        }
        return result;
    }

    private static synchronized Object getPropertyAsObject(Object bean, String propertyName) {
        Object property = null;
        try {
            property = PropertyUtils.getProperty((Object)bean, (String)propertyName);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (NestedNullException e) {
            property = null;
        }
        if (property == null) {
            return null;
        }
        return property;
    }

    public static <T> List<T> asList(T ... values) {
        return new ArrayList<T>(Arrays.asList(values));
    }

    public static <T> Set<T> asSet(T ... values) {
        return new HashSet<T>(Arrays.asList(values));
    }
}

