/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.util;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.util.DateUtil;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;

public class MetaData {
    private final Metadata metadata;

    MetaData(Metadata metadata) {
        this.metadata = metadata;
    }

    public String getValue(String name) {
        return this.metadata.get(name);
    }

    public List<String> getAvailablePropertyNames() {
        return Arrays.asList(this.metadata.names());
    }

    public String getTitle() {
        return this.cleanString(this.metadata.get(TikaCoreProperties.TITLE));
    }

    public String getSubject() {
        return this.cleanString(this.metadata.get("subject"));
    }

    public String getAuthor() {
        String author = this.metadata.get("Author");
        if (author == null) {
            author = this.metadata.get("creator");
        }
        return this.cleanString(author);
    }

    public String getComments() {
        String comments = this.metadata.get("Comments");
        if (!StringUtil.isDefined(comments)) {
            comments = this.metadata.get("description");
        }
        return this.cleanString(comments);
    }

    public int getSecurity() {
        return this.metadata.getInt(Property.internalInteger((String)"Security"));
    }

    public String[] getKeywords() {
        return this.cleanString(this.metadata.getValues("Keywords"));
    }

    public String getSilverId() {
        return this.cleanString(this.metadata.get("SILVERID"));
    }

    public String getSilverName() {
        return this.metadata.get("SILVERNAME");
    }

    public Date getLastSaveDateTime() {
        Date date = this.parseDate(Metadata.LAST_SAVED);
        if (date == null) {
            return this.parseDate(Metadata.LAST_MODIFIED);
        }
        return date;
    }

    public Date getCreationDate() {
        Date result = this.getDate(TikaCoreProperties.CREATED);
        if (result == null) {
            result = this.metadata.getDate(TikaCoreProperties.CREATED);
        }
        if (result == null) {
            result = this.metadata.getDate(Metadata.DATE);
        }
        return result;
    }

    protected Date getDate(Property property) {
        Date result = this.metadata.getDate(property);
        if (result == null) {
            return this.parseDate(property);
        }
        return result;
    }

    protected Date parseDate(Property property) {
        String date = this.metadata.get(property);
        if (date != null) {
            try {
                return DateUtil.parse(date, "yyyy-MM-dd'T'HH:mm:ss'Z'");
            }
            catch (ParseException ex) {
                return null;
            }
        }
        return null;
    }

    private String[] cleanString(String[] values) {
        String[] result = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = this.cleanString(values[i]);
        }
        return result;
    }

    private String cleanString(String value) {
        if (StringUtil.isDefined(value)) {
            return value.replace("\u0000", "").replace("\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd", "").trim();
        }
        return value;
    }
}

