/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.util;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.exception.UtilException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class ZipManager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long compressFile(String filePath, String zipFilePath) throws IOException {
        ZipArchiveOutputStream zos = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(zipFilePath));
        FileInputStream in = new FileInputStream(filePath);
        try {
            zos = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(zipFilePath));
            zos.setFallbackToUTF8(true);
            zos.setCreateUnicodeExtraFields(ZipArchiveOutputStream.UnicodeExtraFieldPolicy.NOT_ENCODEABLE);
            zos.setEncoding("UTF-8");
            String entryName = FilenameUtils.getName((String)filePath);
            entryName = entryName.replace(File.separatorChar, '/');
            zos.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(entryName));
            IOUtils.copy((InputStream)in, (OutputStream)zos);
            zos.closeArchiveEntry();
            long l = new File(zipFilePath).length();
            return l;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)zos);
        }
    }

    public static long compressPathToZip(String folderToZip, String zipFile) throws IOException {
        return ZipManager.compressPathToZip(new File(folderToZip), new File(zipFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long compressPathToZip(File folderToZip, File zipFile) throws IOException {
        ZipArchiveOutputStream zos = null;
        try {
            zos = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(zipFile));
            zos.setFallbackToUTF8(true);
            zos.setCreateUnicodeExtraFields(ZipArchiveOutputStream.UnicodeExtraFieldPolicy.NOT_ENCODEABLE);
            zos.setEncoding("UTF-8");
            Collection folderContent = FileUtils.listFiles((File)folderToZip, null, (boolean)true);
            for (File file : folderContent) {
                String entryName = file.getPath().substring(folderToZip.getParent().length() + 1);
                entryName = FilenameUtils.separatorsToUnix((String)entryName);
                zos.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(entryName));
                FileInputStream in = new FileInputStream(file);
                IOUtils.copy((InputStream)in, (OutputStream)zos);
                zos.closeArchiveEntry();
                IOUtils.closeQuietly((InputStream)in);
            }
            if (zos == null) return zipFile.length();
        }
        catch (Throwable throwable) {
            if (zos == null) throw throwable;
            IOUtils.closeQuietly(zos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)zos);
        return zipFile.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void compressStreamToZip(InputStream inputStream, String filePathNameToCreate, String outfilename) throws IOException {
        ZipArchiveOutputStream zos = null;
        try {
            zos = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(outfilename));
            zos.setFallbackToUTF8(true);
            zos.setCreateUnicodeExtraFields(ZipArchiveOutputStream.UnicodeExtraFieldPolicy.NOT_ENCODEABLE);
            zos.setEncoding("UTF-8");
            zos.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(filePathNameToCreate));
            IOUtils.copy((InputStream)inputStream, (OutputStream)zos);
            zos.closeArchiveEntry();
            if (zos == null) return;
        }
        catch (Throwable throwable) {
            if (zos == null) throw throwable;
            IOUtils.closeQuietly(zos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)zos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extract(File source, File dest) throws UtilException {
        if (source == null) {
            throw new UtilException("Expand.execute()", 4, "util.EXE_SOURCE_FILE_ATTRIBUTE_MUST_BE_SPECIFIED");
        }
        if (dest == null) {
            throw new UtilException("Expand.execute()", 4, "util.EXE_DESTINATION_FILE_ATTRIBUTE_MUST_BE_SPECIFIED");
        }
        BufferedInputStream in = null;
        ArchiveInputStream archiveStream = null;
        try {
            ArchiveEntry archiveEntry;
            in = new BufferedInputStream(new FileInputStream(source));
            try {
                archiveStream = new ArchiveStreamFactory().createArchiveInputStream((InputStream)in);
            }
            catch (ArchiveException aex) {
                archiveStream = FilenameUtils.getExtension((String)source.getName()).toLowerCase().endsWith("gz") ? new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)in)) : new TarArchiveInputStream((InputStream)new BZip2CompressorInputStream((InputStream)in));
            }
            while ((archiveEntry = archiveStream.getNextEntry()) != null) {
                File currentFile = new File(dest, archiveEntry.getName());
                try {
                    currentFile.getParentFile().mkdirs();
                    if (archiveEntry.isDirectory()) {
                        currentFile.mkdirs();
                        continue;
                    }
                    currentFile.getParentFile().mkdirs();
                    FileOutputStream fos = new FileOutputStream(currentFile);
                    IOUtils.copy((InputStream)archiveStream, (OutputStream)fos);
                    IOUtils.closeQuietly((OutputStream)fos);
                }
                catch (FileNotFoundException ex) {
                    SilverTrace.warn("util", "ZipManager.extractFile()", "root.EX_FILE_NOT_FOUND", "file = " + currentFile.getPath(), ex);
                }
            }
        }
        catch (IOException ioe) {
            try {
                SilverTrace.warn("util", "ZipManager.extractFile()", "util.EXE_ERROR_WHILE_EXTRACTING_FILE", "sourceFile = " + source.getPath(), ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(archiveStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((InputStream)archiveStream);
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((InputStream)archiveStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNbFiles(File archive) {
        ZipFile zipFile = null;
        int nbFiles = 0;
        try {
            zipFile = new ZipFile(archive);
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry ze = (ZipArchiveEntry)entries.nextElement();
                if (ze.isDirectory()) continue;
                ++nbFiles;
            }
        }
        catch (IOException ioe) {
            SilverTrace.warn("util", "ZipManager.getNbFiles()", "util.EXE_ERROR_WHILE_COUNTING_FILE", "sourceFile = " + archive.getPath(), ioe);
        }
        finally {
            if (zipFile != null) {
                ZipFile.closeQuietly((ZipFile)zipFile);
            }
        }
        return nbFiles;
    }
}

