/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.util.csv;

import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.exception.UtilException;
import java.text.ParseException;
import java.util.Date;

public final class Variant {
    public static final String TYPE_STRING = "STRING";
    public static final String TYPE_INT = "INT";
    public static final String TYPE_BOOLEAN = "BOOLEAN";
    public static final String TYPE_FLOAT = "FLOAT";
    public static final String TYPE_DATEFR = "DATEFR";
    public static final String TYPE_DATEUS = "DATEUS";
    public static final String TYPE_STRING_ARRAY = "SARRAY";
    public static final String TYPE_LONG = "LONG";
    protected String m_type;
    protected String[] m_asValue = new String[0];
    protected String m_sValue = "";
    protected int m_iValue = 0;
    protected boolean m_bValue = false;
    protected float m_fValue = 0.0f;
    protected Date m_dValue = new Date();
    protected long m_lValue = 0L;

    public static boolean isArrayType(String type) {
        boolean valret = false;
        if (TYPE_STRING_ARRAY.equals(type)) {
            valret = true;
        }
        return valret;
    }

    public Variant(String value, String type) throws UtilException {
        this.m_type = type;
        this.m_sValue = value;
        if (TYPE_INT.equals(this.m_type)) {
            this.m_sValue = value.trim();
            this.setValueInteger(value);
        }
        if (TYPE_LONG.equals(this.m_type)) {
            this.m_sValue = value.trim();
            this.setValueLong(value);
        }
        if (TYPE_BOOLEAN.equals(this.m_type)) {
            this.m_sValue = value.trim();
            this.setValueBoolean(value);
        }
        if (TYPE_FLOAT.equals(this.m_type)) {
            this.m_sValue = value.trim().replace(',', '.');
            this.setValueFloat(value);
        }
        if (TYPE_DATEFR.equals(this.m_type) || TYPE_DATEUS.equals(this.m_type)) {
            this.m_sValue = value.trim();
            this.setValueDate(value);
        }
    }

    public Variant(String[] values, String type) {
        this.m_type = type;
        if (TYPE_STRING_ARRAY.equals(this.m_type)) {
            this.setValueStringArray(values);
        }
    }

    public String getDefaultType() {
        return this.m_type;
    }

    public String[] getValueStringArray() {
        return this.m_asValue;
    }

    public String getValueString() {
        return this.m_sValue;
    }

    public int getValueInteger() {
        return this.m_iValue;
    }

    public long getValueLong() {
        return this.m_lValue;
    }

    public boolean getValueBoolean() {
        return this.m_bValue;
    }

    public float getValueFloat() {
        return this.m_fValue;
    }

    public Date getValueDate() {
        return this.m_dValue;
    }

    protected String[] setValueStringArray(String[] asValue) {
        this.m_asValue = asValue != null ? (String[])asValue.clone() : new String[0];
        return this.m_asValue;
    }

    protected int setValueInteger(String value) throws UtilException {
        try {
            this.m_iValue = Integer.parseInt(value.trim());
        }
        catch (NumberFormatException e) {
            throw new UtilException("Variant.setValueInteger", 4, "root.EX_INVALID_ARG", "Value=" + value + " Type=" + this.m_type, e);
        }
        return this.m_iValue;
    }

    protected long setValueLong(String value) throws UtilException {
        try {
            this.m_lValue = Long.parseLong(value.trim());
        }
        catch (NumberFormatException e) {
            throw new UtilException("Variant.setValueLong", 4, "root.EX_INVALID_ARG", "Value=" + value + " Type=" + this.m_type, e);
        }
        return this.m_lValue;
    }

    protected boolean setValueBoolean(String value) throws UtilException {
        boolean error = false;
        if (value != null) {
            if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("oui") || value.equalsIgnoreCase("1")) {
                this.m_bValue = true;
            } else if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no") || value.equalsIgnoreCase("non") || value.equalsIgnoreCase("0")) {
                this.m_bValue = false;
            } else {
                error = true;
            }
        } else {
            error = true;
        }
        if (error) {
            throw new UtilException("Variant.setValueBoolean", 4, "root.EX_INVALID_ARG", "Value=" + value + " Type=" + this.m_type);
        }
        return this.m_bValue;
    }

    protected float setValueFloat(String value) throws UtilException {
        try {
            this.m_fValue = Float.parseFloat(value.trim().replace(',', '.'));
        }
        catch (NumberFormatException e) {
            throw new UtilException("Variant.setValueFloat", 4, "root.EX_INVALID_ARG", "Value=" + value + " Type=" + this.m_type, e);
        }
        return this.m_fValue;
    }

    protected Date setValueDate(String value) throws UtilException {
        try {
            this.m_dValue = TYPE_DATEUS.equals(this.m_type) ? DateUtil.stringToDate(value, "en") : DateUtil.stringToDate(value, "fr");
        }
        catch (ParseException e) {
            throw new UtilException("Variant.setValueDate", 4, "root.EX_INVALID_ARG", "Value=" + value + " Type=" + this.m_type, e);
        }
        return this.m_dValue;
    }
}

