/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.util.i18n;

import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NBean;
import com.silverpeas.util.i18n.I18NHelper;
import com.silverpeas.util.i18n.Translation;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractI18NBean
implements I18NBean,
Serializable {
    private static final long serialVersionUID = 756146888448232764L;
    private String language = null;
    private String translationId = null;
    private Map<String, Translation> translations = new HashMap<String, Translation>(3);
    private boolean removeTranslation = false;

    public String getLanguage() {
        return this.language;
    }

    @Override
    public void setLanguage(String language) {
        this.language = language;
    }

    public boolean isRemoveTranslation() {
        return this.removeTranslation;
    }

    @Override
    public void setRemoveTranslation(boolean removeTranslation) {
        this.removeTranslation = removeTranslation;
    }

    public String getTranslationId() {
        return this.translationId;
    }

    @Override
    public void setTranslationId(String translationId) {
        this.translationId = translationId;
    }

    public Iterator<String> getLanguages() {
        return this.translations.keySet().iterator();
    }

    @Override
    public Map<String, Translation> getTranslations() {
        return this.translations;
    }

    public void setTranslations(Map<String, Translation> translations) {
        this.translations = translations;
    }

    public void setTranslations(Collection<Translation> translations) {
        if (translations != null && !translations.isEmpty()) {
            for (Translation translation : translations) {
                this.addTranslation(translation);
            }
        }
    }

    public void setTranslations(List<Translation> translations) {
        if (translations != null && !translations.isEmpty()) {
            for (Translation translation : translations) {
                this.addTranslation(translation);
            }
        }
    }

    @Override
    public Translation getTranslation(String language) {
        return this.translations.get(language);
    }

    public void addTranslation(Translation translation) {
        String language = translation.getLanguage();
        if (!StringUtil.isDefined(language)) {
            language = I18NHelper.defaultLanguage;
            translation.setLanguage(language);
        }
        this.translations.put(language, translation);
    }

    @Override
    public Translation getNextTranslation() {
        Iterator<String> languages = I18NHelper.getLanguages();
        Translation translation = null;
        while (translation == null && languages.hasNext()) {
            translation = this.getTranslations().get(languages.next());
        }
        return translation;
    }

    public String getLanguageToDisplay(String language) {
        String languageToDisplay = language;
        Translation translation = this.getTranslation(language);
        if (translation == null && (translation = this.getNextTranslation()) != null) {
            languageToDisplay = translation.getLanguage();
        }
        return languageToDisplay;
    }
}

