/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.util.template;

import com.silverpeas.util.template.SilverpeasTemplate;
import com.silverpeas.util.template.renderer.DateRenderer;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.antlr.stringtemplate.AttributeRenderer;
import org.antlr.stringtemplate.AutoIndentWriter;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateWriter;
import org.apache.commons.io.IOUtils;

public class SilverpeasStringTemplate
implements SilverpeasTemplate {
    public Map<String, Object> attributes = new HashMap<String, Object>();
    public Properties templateConfig;

    public SilverpeasStringTemplate(Properties templateConfig) {
        this.templateConfig = templateConfig;
    }

    @Override
    public String applyFileTemplate(String fileName) {
        StringTemplateGroup group;
        String physicalName;
        String customersRootDir = this.templateConfig.getProperty("template.customer.dir");
        File file = new File(customersRootDir, physicalName = (group = new StringTemplateGroup(fileName, customersRootDir)).getFileNameFromTemplateName(fileName));
        if (!file.exists() || !file.isFile()) {
            String rootRootDir = this.templateConfig.getProperty("template.root.dir");
            file = new File(rootRootDir, physicalName);
            group = new StringTemplateGroup(fileName, rootRootDir);
        }
        if (file.exists() && file.length() == 0L) {
            return "";
        }
        group.setFileCharEncoding("UTF-8");
        StringTemplate template = group.getInstanceOf(fileName);
        return this.applyAttributes(template);
    }

    @Override
    public String applyStringTemplate(String label) {
        StringTemplate template = new StringTemplate(label);
        return this.applyAttributes(template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String applyAttributes(StringTemplate template) {
        template.registerRenderer(Date.class, (AttributeRenderer)new DateRenderer());
        for (Map.Entry<String, Object> attribute : this.attributes.entrySet()) {
            template.setAttribute(attribute.getKey(), attribute.getValue());
        }
        StringWriter writer = new StringWriter();
        AutoIndentWriter out = new AutoIndentWriter((Writer)writer, "\n");
        try {
            template.write((StringTemplateWriter)out);
        }
        catch (IOException e) {
            String string = template.toString();
            return string;
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
        return writer.toString();
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public String applyFileTemplateOnComponent(String componentName, String fileName) {
        return this.applyFileTemplate("/" + componentName.toLowerCase() + "/" + fileName);
    }

    @Override
    public boolean isCustomTemplateExists(String componentName, String fileName) {
        StringTemplateGroup group;
        String physicalName;
        String filePath = "/" + componentName.toLowerCase() + "/" + fileName;
        String customersRootDir = this.templateConfig.getProperty("template.customer.dir");
        File file = new File(customersRootDir, physicalName = (group = new StringTemplateGroup(filePath, customersRootDir)).getFileNameFromTemplateName(filePath));
        return file.exists() && file.isFile();
    }
}

