/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.util.web.servlet;

import com.silverpeas.util.FileUtil;
import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.util.exception.UtilException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.SilverpeasDiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileUtils;

public class FileUploadUtil {
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new SilverpeasDiskFileItemFactory());

    public static boolean isRequestMultipart(HttpServletRequest request) {
        return ServletFileUpload.isMultipartContent((HttpServletRequest)request);
    }

    public static List<FileItem> parseRequest(HttpServletRequest request) throws UtilException {
        try {
            return upload.parseRequest(request);
        }
        catch (FileUploadException fuex) {
            throw new UtilException("FileUploadUtil.parseRequest", "Error uploading files", (Exception)((Object)fuex));
        }
    }

    public static String getParameter(List<FileItem> items, String parameterName, String defaultValue, String encoding) {
        for (FileItem item : items) {
            if (!item.isFormField() || !parameterName.equals(item.getFieldName())) continue;
            try {
                return item.getString(encoding);
            }
            catch (UnsupportedEncodingException e) {
                return item.getString();
            }
        }
        return defaultValue;
    }

    public static String getParameter(List<FileItem> items, String parameterName, String defaultValue) {
        return FileUploadUtil.getParameter(items, parameterName, defaultValue, DEFAULT_ENCODING);
    }

    public static String getParameter(List<FileItem> items, String parameterName) {
        return FileUploadUtil.getParameter(items, parameterName, null);
    }

    public static String getOldParameter(List items, String parameterName) {
        return FileUploadUtil.getParameter(items, parameterName, null);
    }

    public static String getOldParameter(List items, String parameterName, String defaultValue) {
        return FileUploadUtil.getParameter(items, parameterName, defaultValue);
    }

    public static FileItem getOldFile(List items, String parameterName) {
        return FileUploadUtil.getFile(items, parameterName);
    }

    public static FileItem getFile(List<FileItem> items, String parameterName) {
        for (FileItem item : items) {
            if (item.isFormField() || !parameterName.equals(item.getFieldName())) continue;
            return item;
        }
        return null;
    }

    public static FileItem getFile(List<FileItem> items) {
        for (FileItem item : items) {
            if (item.isFormField()) continue;
            return item;
        }
        return null;
    }

    public static FileItem getFile(HttpServletRequest request) throws UtilException {
        List<FileItem> items = FileUploadUtil.parseRequest(request);
        return FileUploadUtil.getFile(items);
    }

    public static String getFileName(FileItem file) {
        if (file == null || !StringUtil.isDefined(file.getName())) {
            return "";
        }
        return FileUtil.getFilename(file.getName());
    }

    public static void saveToFile(File file, FileItem item) throws IOException {
        FileUtils.copyInputStreamToFile((InputStream)item.getInputStream(), (File)file);
    }

    private FileUploadUtil() {
    }
}

