/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.wysiwyg.dynamicvalue.control;

import com.silverpeas.util.EncodeHelper;
import com.silverpeas.wysiwyg.dynamicvalue.dao.DynamicValueDAO;
import com.silverpeas.wysiwyg.dynamicvalue.model.DynamicValue;
import com.silverpeas.wysiwyg.dynamicvalue.pool.ConnectionPoolFactory;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.FileServerUtils;
import com.stratelia.webactiv.util.ResourceLocator;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DynamicValueReplacement {
    static final String REGEX = "\\(%(.*?)%\\)";
    private String updatedString;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String buildHTMLSelect(String language, String fieldName) {
        String HTMLCodeFramgment;
        block9: {
            HTMLCodeFramgment = "";
            Connection conn = null;
            try {
                conn = ConnectionPoolFactory.getConnection();
                List<DynamicValue> list = DynamicValueDAO.getAllValidDynamicValue(conn);
                if (list == null) break block9;
                ResourceLocator message = null;
                StringBuilder builder = new StringBuilder();
                String firstOption = " ------------------";
                try {
                    message = new ResourceLocator("org.silverpeas.wysiwyg.multilang.wysiwygBundle", language);
                    if (message != null) {
                        firstOption = message.getString("DynamicValues");
                    }
                }
                catch (Exception ex) {
                    SilverTrace.error("wysiwiy", DynamicValueReplacement.class.toString(), "root.EX_CANT_GET_LANGUAGE_RESOURCE ", ex);
                }
                builder.append(" <select id=\"dynamicValues_").append(fieldName).append("\" name=\"dynamicValues\" onchange=\"chooseDynamicValues").append(FileServerUtils.replaceAccentChars(fieldName.replace(' ', '_'))).append("();this.selectedIndex=0;\">").append("<option value=\"\">").append(firstOption).append("</option>");
                for (DynamicValue dynamicValue : list) {
                    builder.append("<option value=\"").append(dynamicValue.getKey()).append("\">").append(dynamicValue.getKey()).append("</option>");
                }
                builder.append(" </select>");
                HTMLCodeFramgment = builder.toString();
            }
            catch (Exception e) {
                SilverTrace.error("wysiwiy", DynamicValueReplacement.class.toString(), "root.EX_SQL_QUERY_FAILED", e);
            }
            finally {
                DBUtil.close(conn);
            }
        }
        return HTMLCodeFramgment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String replaceKeyByValue(String wysiwygText) {
        Connection conn = null;
        this.updatedString = wysiwygText;
        Pattern pattern = Pattern.compile(REGEX);
        Matcher matcher = pattern.matcher(this.updatedString);
        if (matcher.find()) {
            try {
                conn = ConnectionPoolFactory.getConnection();
                this.searchReplaceKeys(this.updatedString, conn, matcher, null);
            }
            catch (SQLException e) {
                SilverTrace.error("wysiwyg", DynamicValueReplacement.class.toString(), "root.EX_SQL_QUERY_FAILED", e);
            }
            finally {
                DBUtil.close(conn);
            }
        }
        SilverTrace.debug("wysiwyg", DynamicValueReplacement.class.toString(), "content after  key replacement by value : " + this.updatedString);
        return this.updatedString;
    }

    private String searchReplaceKeys(String wysiwygText, Connection conn, Matcher matcher, String oldMach) throws SQLException {
        String escapementStr = "";
        SilverTrace.debug("wysiwyg", DynamicValueReplacement.class.toString(), " character matching " + matcher.toString());
        SilverTrace.debug("wysiwyg", DynamicValueReplacement.class.toString(), " complete tag : " + matcher.group());
        SilverTrace.debug("wysiwyg", DynamicValueReplacement.class.toString(), " key to use to get the dynamic value : " + EncodeHelper.htmlStringToJavaString(matcher.group(1)));
        DynamicValue value = DynamicValueDAO.getValidDynamicValue(conn, EncodeHelper.htmlStringToJavaString(matcher.group(1)));
        if (value != null) {
            SilverTrace.debug("wysiwyg", DynamicValueReplacement.class.toString(), "key : " + value.getKey() + "  value :" + value.getValue());
            escapementStr = matcher.group().replaceAll("\\\\", "\\\\\\\\");
            escapementStr = escapementStr.replaceAll("\\(", "\\\\(");
            escapementStr = escapementStr.replaceAll("\\)", "\\\\)");
            SilverTrace.debug("wysiwyg", DynamicValueReplacement.class.toString(), " result after escaping special characters : " + escapementStr);
            this.updatedString = wysiwygText.replaceAll(escapementStr, value.getValue());
        } else {
            SilverTrace.debug("wysiwyg", DynamicValueReplacement.class.toString(), " key not found in database : " + EncodeHelper.htmlStringToJavaString(matcher.group(1)));
        }
        matcher.reset(this.updatedString);
        if (matcher.find() && !escapementStr.equalsIgnoreCase(oldMach)) {
            this.searchReplaceKeys(this.updatedString, conn, matcher, escapementStr);
        }
        return this.updatedString;
    }

    public static boolean isActivate() {
        ResourceLocator resource = new ResourceLocator("org.silverpeas.wysiwyg.settings.wysiwygSettings", "");
        return resource.getBoolean("activateDynamicValue", false);
    }
}

