/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.wysiwyg.dynamicvalue.dao;

import com.silverpeas.util.ConfigurationControl;
import com.silverpeas.util.StringUtil;
import com.silverpeas.wysiwyg.dynamicvalue.exception.PropertyNotFoundRuntimeException;
import com.silverpeas.wysiwyg.dynamicvalue.model.DynamicValue;
import com.stratelia.webactiv.util.DBUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;

public class DynamicValueDAO {
    private static String tableName = null;
    private static String keyColumnName = null;
    private static String valueColumnName = null;
    private static String startDateColumnName = null;
    private static String endDateColumnName = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicValue getValidDynamicValue(Connection conn, String id) throws SQLException {
        DynamicValueDAO.checkTableInfos();
        DynamicValue value = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            String query = "SELECT " + keyColumnName + "," + valueColumnName + "," + startDateColumnName + "," + endDateColumnName + " FROM " + tableName + " WHERE (" + endDateColumnName + " >= ? " + " OR " + endDateColumnName + " IS NULL )  AND (" + startDateColumnName + " <= ?  OR " + startDateColumnName + " IS NULL )  AND " + keyColumnName + " = ?";
            pst = conn.prepareStatement(query);
            java.sql.Date sqlToday = DynamicValueDAO.getTodayDate();
            pst.setString(3, id);
            pst.setDate(1, sqlToday);
            pst.setDate(2, sqlToday);
            rs = pst.executeQuery();
            if (rs.next()) {
                value = new DynamicValue(rs.getString(keyColumnName), rs.getString(valueColumnName), rs.getDate(startDateColumnName), rs.getDate(endDateColumnName));
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, pst);
            throw throwable;
        }
        DBUtil.close(rs, pst);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DynamicValue> getAllValidDynamicValue(Connection conn) throws SQLException {
        DynamicValueDAO.checkTableInfos();
        ArrayList<DynamicValue> values = new ArrayList<DynamicValue>();
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            String query = "SELECT " + keyColumnName + "," + valueColumnName + "," + startDateColumnName + "," + endDateColumnName + " FROM " + tableName + " WHERE (" + endDateColumnName + " >= ? " + " OR " + endDateColumnName + " IS NULL ) AND (" + startDateColumnName + " <= ?  OR " + startDateColumnName + " IS NULL ) ORDER BY " + keyColumnName;
            pst = conn.prepareStatement(query);
            java.sql.Date currentDate = DynamicValueDAO.getTodayDate();
            pst.setDate(1, currentDate);
            pst.setDate(2, currentDate);
            rs = pst.executeQuery();
            while (rs.next()) {
                DynamicValue value = new DynamicValue(rs.getString(keyColumnName), rs.getString(valueColumnName), rs.getDate(startDateColumnName), rs.getDate(endDateColumnName));
                values.add(value);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, pst);
            throw throwable;
        }
        DBUtil.close(rs, pst);
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DynamicValue> searchValidDynamicValue(Connection conn, String criterion) throws SQLException {
        DynamicValueDAO.checkTableInfos();
        ArrayList<DynamicValue> values = new ArrayList<DynamicValue>();
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            String query = "SELECT " + keyColumnName + "," + valueColumnName + "," + startDateColumnName + "," + endDateColumnName + " FROM " + tableName + " WHERE (" + endDateColumnName + " >= ? " + " OR " + endDateColumnName + " IS NULL ) AND (" + startDateColumnName + " <= ?  OR " + startDateColumnName + " IS NULL ) AND " + keyColumnName + " like ? ORDER BY " + keyColumnName;
            pst = conn.prepareStatement(query);
            java.sql.Date currentDate = DynamicValueDAO.getTodayDate();
            pst.setDate(1, currentDate);
            pst.setDate(2, currentDate);
            pst.setString(3, "%" + criterion + "%");
            rs = pst.executeQuery();
            while (rs.next()) {
                DynamicValue value = new DynamicValue(rs.getString(keyColumnName), rs.getString(valueColumnName), rs.getDate(startDateColumnName), rs.getDate(endDateColumnName));
                values.add(value);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, pst);
            throw throwable;
        }
        DBUtil.close(rs, pst);
        return values;
    }

    private static void initTableInfos() {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("com.silverpeas.wysiwyg.dynamicvalue.settings.dynamicValueSettings", new ConfigurationControl());
            tableName = bundle.getString("tableName").trim();
            keyColumnName = bundle.getString("keyColumnName").trim();
            valueColumnName = bundle.getString("valueColumnName").trim();
            startDateColumnName = bundle.getString("startDateColumnName").trim();
            endDateColumnName = bundle.getString("endDateColumnName").trim();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void checkTableInfos() throws PropertyNotFoundRuntimeException {
        if (!(StringUtil.isDefined(tableName) && StringUtil.isDefined(keyColumnName) && StringUtil.isDefined(valueColumnName) && StringUtil.isDefined(startDateColumnName))) {
            throw new PropertyNotFoundRuntimeException("DynamicValueDAO", 4, "wysiwyg.DAO_INITILIZATION_FAILED");
        }
    }

    private static java.sql.Date getTodayDate() {
        Date today = new Date();
        return new java.sql.Date(today.getTime());
    }

    static {
        DynamicValueDAO.initTableInfos();
    }
}

