/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.contentManager;

import com.silverpeas.util.i18n.AbstractI18NBean;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.silverpeas.contentManager.GlobalSilverContentI18N;
import com.stratelia.silverpeas.contentManager.SilverContentInterface;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.silverpeas.search.searchEngine.model.MatchingIndexEntry;

public class GlobalSilverContent
extends AbstractI18NBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name = "";
    private String description = "";
    private String url = "";
    private String location = "";
    private String id = "";
    private String instanceId = "";
    private String date = "";
    private String creationDate = "";
    private String icon_url = "";
    private String thumbnailURL = "";
    private String thumbnailMimeType = "";
    private String thumbnailWidth = "";
    private String thumbnailHeight = "";
    private String userId = "";
    private String creatorFirstName = "";
    private String creatorLastName = "";
    private Map<String, String> sortableXMLFormFields = null;
    private String spaceId = "";
    private float score = 0.0f;
    private String type = "";

    public void init(String name, String desc, String url, String location, String id, String instanceId, String date, String icon, String userId) {
        this.name = name;
        this.description = desc;
        this.url = url;
        this.location = location;
        this.id = id;
        this.instanceId = instanceId;
        this.date = date;
        this.icon_url = icon;
        this.userId = userId;
        GlobalSilverContentI18N gscI18N = new GlobalSilverContentI18N(I18NHelper.defaultLanguage, name, this.description);
        this.addTranslation(gscI18N);
    }

    public GlobalSilverContent(String name, String desc, String id, String spaceId, String instanceId, String date, String userId) {
        this.init(name, desc, null, null, id, instanceId, date, null, userId);
        this.spaceId = spaceId;
    }

    public GlobalSilverContent(MatchingIndexEntry mie) {
        this.init(mie.getTitle(), mie.getPreView(), null, null, mie.getObjectId(), mie.getComponent(), mie.getLastModificationDate(), null, mie.getCreationUser());
        this.setCreationDate(mie.getCreationDate());
        this.sortableXMLFormFields = mie.getSortableXMLFormFields();
        Iterator<String> languages = mie.getLanguages();
        while (languages.hasNext()) {
            String language = languages.next();
            GlobalSilverContentI18N gscI18N = new GlobalSilverContentI18N(language, mie.getTitle(language), mie.getPreview(language));
            this.addTranslation(gscI18N);
        }
    }

    public GlobalSilverContent(SilverContentInterface sci, String location) {
        this.init(sci.getName(), sci.getDescription(), sci.getURL(), location, sci.getId(), sci.getInstanceId(), sci.getDate(), sci.getIconUrl(), sci.getCreatorId());
        this.creationDate = sci.getSilverCreationDate();
        this.processLanguages(sci);
    }

    public GlobalSilverContent(SilverContentInterface sci, String location, String creatorFirstName, String creatorLastName) {
        this.init(sci.getName(), sci.getDescription(), sci.getURL(), location, sci.getId(), sci.getInstanceId(), sci.getDate(), sci.getIconUrl(), sci.getCreatorId());
        this.creationDate = sci.getSilverCreationDate();
        this.creatorFirstName = creatorFirstName;
        this.creatorLastName = creatorLastName;
        this.processLanguages(sci);
    }

    private void processLanguages(SilverContentInterface sci) {
        Iterator<String> languages = sci.getLanguages();
        while (languages != null && languages.hasNext()) {
            String language = languages.next();
            GlobalSilverContentI18N gscI18N = new GlobalSilverContentI18N(language, sci.getName(language), sci.getDescription(language));
            this.addTranslation(gscI18N);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getName(String language) {
        if (!I18NHelper.isI18N) {
            return this.getName();
        }
        GlobalSilverContentI18N s = (GlobalSilverContentI18N)this.getTranslations().get(language);
        if (s == null) {
            s = (GlobalSilverContentI18N)this.getNextTranslation();
        }
        return s.getName();
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescription(String language) {
        if (!I18NHelper.isI18N) {
            return this.getDescription();
        }
        GlobalSilverContentI18N s = (GlobalSilverContentI18N)this.getTranslations().get(language);
        if (s == null) {
            s = (GlobalSilverContentI18N)this.getNextTranslation();
        }
        return s.getDescription();
    }

    public String getURL() {
        return this.url;
    }

    public String getLocation() {
        return this.location;
    }

    public String getId() {
        return this.id;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getSpaceId() {
        return this.spaceId;
    }

    public void setSpaceId(String spaceId) {
        this.spaceId = spaceId;
    }

    public String getTitle() {
        return this.getName();
    }

    public String getDate() {
        return this.date;
    }

    public String getIconUrl() {
        return this.icon_url;
    }

    public void setIconUrl(String iconURL) {
        this.icon_url = iconURL;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getCreatorFirstName() {
        return this.creatorFirstName;
    }

    public String getCreatorLastName() {
        return this.creatorLastName;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public float getRawScore() {
        return this.score;
    }

    public String getScore() {
        return Float.toString(this.score * 100.0f);
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public void setTitle(String title) {
        this.name = title;
    }

    public String getThumbnailHeight() {
        return this.thumbnailHeight;
    }

    public void setThumbnailHeight(String iconHeight) {
        this.thumbnailHeight = iconHeight;
    }

    public String getThumbnailWidth() {
        return this.thumbnailWidth;
    }

    public void setThumbnailWidth(String iconWidth) {
        this.thumbnailWidth = iconWidth;
    }

    public String getThumbnailURL() {
        return this.thumbnailURL;
    }

    public void setThumbnailURL(String thumbnailURL) {
        this.thumbnailURL = thumbnailURL;
    }

    public String getThumbnailMimeType() {
        return this.thumbnailMimeType;
    }

    public void setThumbnailMimeType(String thumbnailMimeType) {
        this.thumbnailMimeType = thumbnailMimeType;
    }

    public Map<String, String> getSortableXMLFormFields() {
        return this.sortableXMLFormFields;
    }

    public void setSortableXMLFormFields(Map<String, String> sortableXMLFormFields) {
        this.sortableXMLFormFields = sortableXMLFormFields;
    }
}

