/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.domains.ldapdriver;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPModification;
import com.stratelia.silverpeas.domains.ldapdriver.AbstractLDAPGroup;
import com.stratelia.silverpeas.domains.ldapdriver.AbstractLDAPTimeStamp;
import com.stratelia.silverpeas.domains.ldapdriver.LDAPSettings;
import com.stratelia.silverpeas.domains.ldapdriver.LDAPSynchroCache;
import com.stratelia.silverpeas.domains.ldapdriver.LDAPUser;
import com.stratelia.silverpeas.domains.ldapdriver.LDAPUtility;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AbstractDomainDriver;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.DomainProperty;
import com.stratelia.webactiv.beans.admin.Group;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.beans.admin.UserFull;
import com.stratelia.webactiv.util.ResourceLocator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.silverpeas.authentication.exception.AuthenticationBadCredentialException;

public class LDAPDriver
extends AbstractDomainDriver {
    LDAPSettings driverSettings = new LDAPSettings();
    LDAPSynchroCache synchroCache = new LDAPSynchroCache();
    LDAPUser userTranslator = null;
    AbstractLDAPGroup groupTranslator = null;
    boolean synchroInProcess = false;

    @Override
    public void initFromProperties(ResourceLocator rs) throws AdminException {
        this.driverSettings.initFromProperties(rs);
        this.synchroCache.init(this.driverSettings);
        this.userTranslator = this.driverSettings.newLDAPUser();
        this.userTranslator.init(this.driverSettings, this, this.synchroCache);
        this.groupTranslator = this.driverSettings.newLDAPGroup();
        this.groupTranslator.init(this.driverSettings, this.synchroCache);
    }

    @Override
    public void addPropertiesToImport(List<DomainProperty> props) {
        this.addPropertiesToImport(props, null);
    }

    @Override
    public void addPropertiesToImport(List<DomainProperty> props, Map<String, String> descriptions) {
        props.add(this.getProperty("lastName", this.driverSettings.getUsersLastNameField(), descriptions));
        props.add(this.getProperty("firstName", this.driverSettings.getUsersFirstNameField(), descriptions));
        props.add(this.getProperty("email", this.driverSettings.getUsersEmailField(), descriptions));
        props.add(this.getProperty("login", this.driverSettings.getUsersLoginField(), descriptions));
    }

    private DomainProperty getProperty(String name, String mapParameter, Map<String, String> descriptions) {
        DomainProperty property = new DomainProperty();
        property.setName(name);
        property.setMapParameter(mapParameter);
        if (descriptions != null) {
            property.setDescription(descriptions.get(name));
        }
        return property;
    }

    @Override
    public long getDriverActions() {
        if (this.x509Enabled) {
            return 65031L;
        }
        return 32263L;
    }

    @Override
    public boolean isSynchroOnLoginEnabled() {
        SilverTrace.info("admin", "LDAPDriver.isSynchroOnLoginEnabled", "root.MSG_GEN_ENTER_METHOD", "Enabled = " + this.driverSettings.isSynchroAutomatic() + " - Synchro In Process = " + this.synchroInProcess);
        return this.driverSettings.isSynchroAutomatic();
    }

    @Override
    public boolean isSynchroOnLoginRecursToGroups() {
        SilverTrace.info("admin", "LDAPDriver.isSynchroOnLoginRecursToGroups", "root.MSG_GEN_ENTER_METHOD", "RecursToGroups = " + this.driverSettings.isSynchroRecursToGroups() + " - Synchro In Process = " + this.synchroInProcess);
        return this.driverSettings.isSynchroRecursToGroups();
    }

    @Override
    public boolean isGroupsInheritProfiles() {
        SilverTrace.info("admin", "LDAPDriver.isGroupsInheritProfiles", "root.MSG_GEN_ENTER_METHOD", "GroupsInheritProfiles = " + this.driverSettings.isGroupsInheritProfiles() + " - Synchro In Process = " + this.synchroInProcess);
        return this.driverSettings.isGroupsInheritProfiles();
    }

    @Override
    public boolean mustImportUsers() {
        SilverTrace.info("admin", "LDAPDriver.mustImportUsers", "root.MSG_GEN_ENTER_METHOD", "MustImportUsers = " + this.driverSettings.mustImportUsers() + " - Synchro In Process = " + this.synchroInProcess);
        return this.driverSettings.mustImportUsers();
    }

    @Override
    public boolean isSynchroThreaded() {
        SilverTrace.info("admin", "LDAPDriver.isGroupsInheritProfiles", "root.MSG_GEN_ENTER_METHOD", "GroupsInheritProfiles = " + this.driverSettings.isGroupsInheritProfiles() + " - Synchro In Process = " + this.synchroInProcess);
        return this.driverSettings.isSynchroThreaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTimeStamp(String minTimeStamp) throws AdminException {
        if (this.driverSettings.getTimeStampVar().length() > 0) {
            String ld = LDAPUtility.openConnection(this.driverSettings);
            SilverTrace.info("admin", "LDAPDriver.getTimeStamp", "root.MSG_GEN_ENTER_METHOD");
            try {
                AbstractLDAPTimeStamp timeStampU = this.userTranslator.getMaxTimeStamp(ld, minTimeStamp);
                AbstractLDAPTimeStamp timeStampG = this.groupTranslator.getMaxTimeStamp(ld, minTimeStamp);
                SilverTrace.info("admin", "LDAPDriver.getTimeStamp", "root.MSG_GEN_PARAM_VALUE", "timeStampU=" + timeStampU + " AND timeStampG=" + timeStampG);
                if (timeStampU.compareTo(timeStampG) >= 0) {
                    String string = timeStampU.toString();
                    return string;
                }
                String string = timeStampG.toString();
                return string;
            }
            finally {
                LDAPUtility.closeConnection(ld);
            }
        }
        return "0";
    }

    @Override
    public String getTimeStampField() {
        String timeStampField = this.driverSettings.getTimeStampVar();
        if (timeStampField != null && timeStampField.trim().length() > 0) {
            return timeStampField;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserDetail[] getAllChangedUsers(String fromTimeStamp, String toTimeStamp) throws AdminException {
        UserDetail[] usersReturned;
        String ld = LDAPUtility.openConnection(this.driverSettings);
        SilverTrace.info("admin", "LDAPDriver.getAllChangedUsers()", "root.MSG_GEN_ENTER_METHOD");
        try {
            usersReturned = this.driverSettings.getTimeStampVar().length() > 0 ? this.userTranslator.getAllUsers(ld, "(|(&(" + this.driverSettings.getTimeStampVar() + ">=" + fromTimeStamp + ")(" + this.driverSettings.getTimeStampVar() + "<=" + toTimeStamp + "))" + "(!(" + this.driverSettings.getTimeStampVar() + "=*)))") : this.userTranslator.getAllUsers(ld, "");
        }
        finally {
            LDAPUtility.closeConnection(ld);
        }
        return usersReturned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group[] getAllChangedGroups(String fromTimeStamp, String toTimeStamp) throws AdminException {
        String ld = LDAPUtility.openConnection(this.driverSettings);
        SilverTrace.info("admin", "LDAPDriver.getAllChangedGroups", "root.MSG_GEN_ENTER_METHOD");
        try {
            if (this.driverSettings.getTimeStampVar().length() > 0) {
                Group[] groupArray = this.groupTranslator.getAllChangedGroups(ld, "(&(" + this.driverSettings.getTimeStampVar() + ">=" + fromTimeStamp + ")(" + this.driverSettings.getTimeStampVar() + "<=" + toTimeStamp + "))");
                return groupArray;
            }
            Group[] groupArray = this.groupTranslator.getAllChangedGroups(ld, "");
            return groupArray;
        }
        finally {
            LDAPUtility.closeConnection(ld);
        }
    }

    @Override
    public void beginSynchronization() throws Exception {
        this.synchroInProcess = true;
        this.synchroCache.beginSynchronization();
        this.userTranslator.beginSynchronization();
        this.groupTranslator.beginSynchronization();
    }

    public String endSynchronization() throws Exception {
        StringBuilder valret = new StringBuilder("");
        this.synchroCache.endSynchronization();
        String result = this.userTranslator.endSynchronization();
        if (result != null && result.length() > 0) {
            valret.append("LDAP Domain User specific errors :\n").append(result).append("\n\n");
        }
        if ((result = this.groupTranslator.endSynchronization()) != null && result.length() > 0) {
            valret.append("LDAP Domain Group specific errors :\n").append(result).append("\n\n");
        }
        this.synchroInProcess = false;
        return valret.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserDetail importUser(String userLogin) throws AdminException {
        String ld = LDAPUtility.openConnection(this.driverSettings);
        SilverTrace.info("admin", "LDAPDriver.importUser", "root.MSG_GEN_ENTER_METHOD", "UserId = " + userLogin);
        try {
            UserDetail userDetail = this.userTranslator.getUserByLogin(ld, userLogin);
            return userDetail;
        }
        finally {
            LDAPUtility.closeConnection(ld);
        }
    }

    @Override
    public void removeUser(String userId) throws AdminException {
    }

    @Override
    public UserDetail synchroUser(String userId) throws Exception {
        SilverTrace.info("admin", "LDAPDriver.synchroUser", "root.MSG_GEN_ENTER_METHOD", "UserId = " + userId);
        return this.getUser(userId);
    }

    @Override
    public String createUser(UserDetail user) throws Exception {
        return null;
    }

    @Override
    public void deleteUser(String userId) throws Exception {
    }

    @Override
    public void updateUserFull(UserFull user) throws AdminException {
        String ld = null;
        try {
            ld = LDAPUtility.openConnection(this.driverSettings);
            LDAPConnection connection = LDAPUtility.getConnection(ld);
            LDAPEntry theEntry = LDAPUtility.getFirstEntryFromSearch(ld, this.driverSettings.getLDAPUserBaseDN(), this.driverSettings.getScope(), this.driverSettings.getUsersIdFilter(user.getSpecificId()), this.driverSettings.getUserAttributes());
            if (theEntry == null) {
                throw new AuthenticationBadCredentialException("LDAPDriver.updateUserFull()", 4, "admin.EX_USER_NOT_FOUND", "User=" + user.getSpecificId() + ";IdField=" + this.driverSettings.getUsersIdField());
            }
            String userFullDN = theEntry.getDN();
            ArrayList<LDAPModification> modifications = new ArrayList<LDAPModification>();
            LDAPAttribute attribute = new LDAPAttribute(this.driverSettings.getUsersFirstNameField(), user.getFirstName());
            modifications.add(new LDAPModification(2, attribute));
            attribute = new LDAPAttribute(this.driverSettings.getUsersLastNameField(), user.getLastName());
            modifications.add(new LDAPModification(2, attribute));
            attribute = new LDAPAttribute(this.driverSettings.getUsersEmailField(), user.geteMail());
            modifications.add(new LDAPModification(2, attribute));
            for (String propertyName : user.getPropertiesNames()) {
                DomainProperty property = user.getProperty(propertyName);
                if (!property.isUpdateAllowedToAdmin() && !property.isUpdateAllowedToUser()) continue;
                LDAPModification modification = new LDAPModification(2, new LDAPAttribute(property.getMapParameter(), user.getValue(propertyName)));
                modifications.add(modification);
            }
            connection.modify(userFullDN, modifications.toArray(new LDAPModification[modifications.size()]));
        }
        catch (Exception ex) {
            throw new AdminException("LDAPDriver.updateUserFull()", 4, "admin.EX_LDAP_ACCESS_ERROR", ex);
        }
        finally {
            try {
                if (ld != null) {
                    LDAPUtility.closeConnection(ld);
                }
            }
            catch (AdminException closeEx) {
                SilverTrace.error("admin", "LDAPDriver.updateUserFull", "root.EX_EMERGENCY_CONNECTION_CLOSE_FAILED", "", closeEx);
            }
        }
    }

    @Override
    public void updateUserDetail(UserDetail user) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserFull getUserFull(String userId) throws AdminException {
        String ld = LDAPUtility.openConnection(this.driverSettings);
        SilverTrace.info("admin", "LDAPDriver.getUser", "root.MSG_GEN_ENTER_METHOD", "UserId = " + userId);
        try {
            UserFull userFull = this.userTranslator.getUserFull(ld, userId);
            return userFull;
        }
        finally {
            LDAPUtility.closeConnection(ld);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserDetail getUser(String userId) throws AdminException {
        String ld = LDAPUtility.openConnection(this.driverSettings);
        SilverTrace.info("admin", "LDAPDriver.getUser", "root.MSG_GEN_ENTER_METHOD", "UserId = " + userId);
        try {
            UserDetail userDetail = this.userTranslator.getUser(ld, userId);
            return userDetail;
        }
        finally {
            LDAPUtility.closeConnection(ld);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserDetail[] getAllUsers() throws AdminException {
        String ld = LDAPUtility.openConnection(this.driverSettings);
        SilverTrace.info("admin", "LDAPDriver.getAllUsers()", "root.MSG_GEN_ENTER_METHOD");
        try {
            UserDetail[] userDetailArray = this.userTranslator.getAllUsers(ld, "");
            return userDetailArray;
        }
        finally {
            LDAPUtility.closeConnection(ld);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserDetail[] getUsersBySpecificProperty(String propertyName, String propertyValue) throws AdminException {
        DomainProperty property = this.getProperty(propertyName);
        if (property == null) {
            return null;
        }
        String ld = LDAPUtility.openConnection(this.driverSettings);
        try {
            String extraFilter = "(" + property.getMapParameter() + "=" + propertyValue + ")";
            UserDetail[] userDetailArray = this.userTranslator.getAllUsers(ld, extraFilter);
            return userDetailArray;
        }
        finally {
            LDAPUtility.closeConnection(ld);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserDetail[] getUsersByQuery(Map<String, String> query) throws AdminException {
        String extraFilter = "";
        for (String propertyName : query.keySet()) {
            extraFilter = extraFilter + "(" + propertyName + "=" + query.get(propertyName) + ")";
        }
        String ld = LDAPUtility.openConnection(this.driverSettings);
        try {
            UserDetail[] userDetailArray = this.userTranslator.getAllUsers(ld, extraFilter);
            return userDetailArray;
        }
        finally {
            LDAPUtility.closeConnection(ld);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getUserMemberGroupIds(String userId) throws AdminException {
        String ld = LDAPUtility.openConnection(this.driverSettings);
        SilverTrace.info("admin", "LDAPDriver.getUserMemberGroupIds", "root.MSG_GEN_ENTER_METHOD", "userId = " + userId);
        try {
            String[] stringArray = this.groupTranslator.getUserMemberGroupIds(ld, userId);
            return stringArray;
        }
        finally {
            LDAPUtility.closeConnection(ld);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group importGroup(String groupName) throws AdminException {
        String ld = LDAPUtility.openConnection(this.driverSettings);
        SilverTrace.info("admin", "LDAPDriver.getGroup", "root.MSG_GEN_ENTER_METHOD", "GroupName = " + groupName);
        try {
            Group group = this.groupTranslator.getGroupByName(ld, groupName);
            return group;
        }
        finally {
            LDAPUtility.closeConnection(ld);
        }
    }

    @Override
    public void removeGroup(String groupId) throws AdminException {
    }

    @Override
    public Group synchroGroup(String groupId) throws AdminException {
        SilverTrace.info("admin", "LDAPDriver.importGroup", "root.MSG_GEN_ENTER_METHOD", "GroupId = " + groupId);
        return this.getGroup(groupId);
    }

    @Override
    public String createGroup(Group m_Group) throws AdminException {
        return null;
    }

    @Override
    public void deleteGroup(String groupId) throws AdminException {
    }

    @Override
    public void updateGroup(Group m_Group) throws AdminException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group getGroup(String groupId) throws AdminException {
        String ld = LDAPUtility.openConnection(this.driverSettings);
        SilverTrace.info("admin", "LDAPDriver.getGroup", "root.MSG_GEN_ENTER_METHOD", "GroupId = " + groupId);
        try {
            Group group = this.groupTranslator.getGroup(ld, groupId);
            return group;
        }
        finally {
            LDAPUtility.closeConnection(ld);
        }
    }

    @Override
    public Group getGroupByName(String groupName) throws AdminException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group[] getGroups(String groupId) throws AdminException {
        String ld = LDAPUtility.openConnection(this.driverSettings);
        SilverTrace.info("admin", "LDAPDriver.getGroups", "root.MSG_GEN_ENTER_METHOD", "FatherGroupId = " + groupId);
        try {
            Group[] groupArray = this.groupTranslator.getGroups(ld, groupId, "");
            return groupArray;
        }
        finally {
            LDAPUtility.closeConnection(ld);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group[] getAllGroups() throws AdminException {
        String ld = LDAPUtility.openConnection(this.driverSettings);
        SilverTrace.info("admin", "LDAPDriver.getAllGroups", "root.MSG_GEN_ENTER_METHOD");
        try {
            Group[] groupArray = this.groupTranslator.getAllGroups(ld, "");
            return groupArray;
        }
        finally {
            LDAPUtility.closeConnection(ld);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group[] getAllRootGroups() throws AdminException {
        String ld = LDAPUtility.openConnection(this.driverSettings);
        SilverTrace.info("admin", "LDAPDriver.getAllRootGroups", "root.MSG_GEN_ENTER_METHOD");
        try {
            Group[] groupArray = this.groupTranslator.getGroups(ld, null, "");
            return groupArray;
        }
        finally {
            LDAPUtility.closeConnection(ld);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getGroupMemberGroupIds(String groupId) throws AdminException {
        String ld = LDAPUtility.openConnection(this.driverSettings);
        SilverTrace.info("admin", "LDAPDriver.getGroupMemberGroupIds", "root.MSG_GEN_ENTER_METHOD", "groupId = " + groupId);
        try {
            String[] stringArray = this.groupTranslator.getGroupMemberGroupIds(ld, groupId);
            return stringArray;
        }
        finally {
            LDAPUtility.closeConnection(ld);
        }
    }

    @Override
    public void startTransaction(boolean bAutoCommit) {
    }

    @Override
    public void commit() throws AdminException {
    }

    @Override
    public void rollback() throws AdminException {
    }

    @Override
    public List<String> getUserAttributes() throws AdminException {
        return Arrays.asList(this.userTranslator.getUserAttributes());
    }

    @Override
    public void resetPassword(UserDetail user, String password) throws Exception {
    }

    @Override
    public void resetEncryptedPassword(UserDetail user, String encryptedPassword) throws Exception {
    }
}

