/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.domains.ldapdriver;

import com.novell.ldap.LDAPConstraints;
import com.novell.ldap.LDAPSearchConstraints;
import com.silverpeas.util.ArrayUtil;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.domains.DriverSettings;
import com.stratelia.silverpeas.domains.ldapdriver.AbstractLDAPGroup;
import com.stratelia.silverpeas.domains.ldapdriver.AbstractLDAPTimeStamp;
import com.stratelia.silverpeas.domains.ldapdriver.LDAPTimeStampMSAD;
import com.stratelia.silverpeas.domains.ldapdriver.LDAPTimeStampNDS;
import com.stratelia.silverpeas.domains.ldapdriver.LDAPUser;
import com.stratelia.silverpeas.domains.ldapdriver.LDAPUtility;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.util.ResourceLocator;
import org.silverpeas.util.Charsets;
import org.silverpeas.util.LdapConfiguration;

public class LDAPSettings
extends DriverSettings {
    public static final String TIME_STAMP_MSAD = "uSNChanged";
    public static final String TIME_STAMP_MSAD_TT = "whenChanged";
    public static final String TIME_STAMP_NDS = "modifyTimeStamp";
    protected final LdapConfiguration configuration = new LdapConfiguration();
    protected String LDAPImpl = null;
    protected int LDAPProtocolVer = 3;
    protected boolean LDAPOpAttributesUsed = false;
    protected String LDAPUserBaseDN = null;
    protected boolean LDAPSearchRecurs = false;
    protected LDAPConstraints LDAPDefaultConstraints = null;
    protected LDAPSearchConstraints LDAPDefaultSearchConstraints = null;
    protected int LDAPMaxMsClientTimeLimit = 0;
    protected int LDAPMaxSecServerTimeLimit = 0;
    protected int LDAPMaxNbEntryReturned = 5000;
    protected int LDAPMaxNbReferrals = 0;
    protected int LDAPBatchSize = 1;
    protected boolean sortControlSupported = true;
    protected boolean SYNCHROautomatic = false;
    protected boolean SYNCHRORecursToGroups = true;
    protected boolean SYNCHROthreaded = false;
    protected String SYNCHROtimeStampVar = "uSNChanged";
    protected boolean SYNCHROCacheEnabled = true;
    protected boolean SYNCHROImportUsers = true;
    protected String usersClassName = null;
    protected String usersFilter = null;
    protected String usersType = null;
    protected String usersIdField = null;
    protected String usersLoginField = null;
    protected String usersFirstNameField = null;
    protected String usersLastNameField = null;
    protected String usersEmailField = null;
    protected String groupsType = null;
    protected String groupsClassName = null;
    protected boolean groupsInheritProfiles = false;
    protected String groupsFilter = null;
    protected int groupsNamingDepth = 0;
    protected String groupsIdField = null;
    protected boolean groupsIncludeEmptyGroups = true;
    protected String groupsSpecificGroupsBaseDN = null;
    protected String groupsMemberField = null;
    protected String groupsNameField = null;
    protected String groupsDescriptionField = null;
    protected boolean ihmImportUsers = true;
    protected boolean ihmImportGroups = true;

    public void initFromProperties(ResourceLocator rs) {
        this.LDAPImpl = rs.getString("database.LDAPImpl", null);
        this.configuration.setLdapHost(rs.getString("database.LDAPHost", null));
        this.configuration.setLdapPort(this.getIntValue(rs, "database.LDAPPort", this.configuration.getLdapPort()));
        this.LDAPProtocolVer = this.getIntValue(rs, "database.LDAPProtocolVer", 3);
        this.LDAPOpAttributesUsed = this.getBooleanValue(rs, "database.LDAPOpAttributesUsed", this.LDAPOpAttributesUsed);
        this.LDAPProtocolVer = 3;
        this.configuration.setUsername(rs.getString("database.LDAPAccessLoginDN", null));
        this.configuration.setPassword(rs.getString("database.LDAPAccessPasswd", "").getBytes(Charsets.UTF_8));
        this.LDAPUserBaseDN = rs.getString("database.LDAPUserBaseDN", null);
        this.LDAPMaxMsClientTimeLimit = this.getIntValue(rs, "database.LDAPMaxMsClientTimeLimit", this.LDAPMaxMsClientTimeLimit);
        this.LDAPMaxSecServerTimeLimit = this.getIntValue(rs, "database.LDAPMaxSecServerTimeLimit", this.LDAPMaxSecServerTimeLimit);
        this.LDAPMaxNbEntryReturned = this.getIntValue(rs, "database.LDAPMaxNbEntryReturned", this.LDAPMaxNbEntryReturned);
        this.LDAPMaxNbReferrals = this.getIntValue(rs, "database.LDAPMaxNbReferrals", this.LDAPMaxNbReferrals);
        this.LDAPBatchSize = this.getIntValue(rs, "database.LDAPBatchSize", this.LDAPBatchSize);
        this.LDAPSearchRecurs = this.getBooleanValue(rs, "database.LDAPSearchRecurs", this.LDAPSearchRecurs);
        this.configuration.setSecure(this.getBooleanValue(rs, "database.LDAPSecured", false));
        if (this.configuration.isSecure()) {
            this.configuration.setLdapPort(this.getIntValue(rs, "database.LDAPPortSecured", 636));
        }
        this.sortControlSupported = this.getBooleanValue(rs, "database.SortControlSupported", !"openldap".equalsIgnoreCase(this.LDAPImpl));
        this.LDAPDefaultSearchConstraints = this.getSearchConstraints(true);
        this.LDAPDefaultConstraints = this.getConstraints(true);
        this.SYNCHROautomatic = this.getBooleanValue(rs, "synchro.Automatic", this.SYNCHROautomatic);
        this.SYNCHRORecursToGroups = this.getBooleanValue(rs, "synchro.RecursToGroups", this.SYNCHRORecursToGroups);
        this.SYNCHROthreaded = this.getBooleanValue(rs, "synchro.Threaded", this.SYNCHROthreaded);
        this.SYNCHROtimeStampVar = this.getStringValue(rs, "synchro.timeStampVar", this.SYNCHROtimeStampVar);
        this.SYNCHROCacheEnabled = this.getBooleanValue(rs, "synchro.CacheEnabled", this.SYNCHROCacheEnabled);
        this.SYNCHROImportUsers = this.getBooleanValue(rs, "synchro.importUsers", true);
        this.usersType = rs.getString("users.Type", null);
        this.usersClassName = rs.getString("users.ClassName", null);
        this.usersFilter = rs.getString("users.Filter", null);
        this.usersIdField = rs.getString("users.IdField", null);
        this.usersLoginField = rs.getString("users.LoginField", null);
        this.usersFirstNameField = rs.getString("users.FirstNameField", null);
        this.usersLastNameField = rs.getString("users.LastNameField", null);
        this.usersEmailField = this.getSureString(rs, "users.EmailField");
        this.groupsType = rs.getString("groups.Type", null);
        this.groupsClassName = rs.getString("groups.ClassName", null);
        this.groupsInheritProfiles = this.getBooleanValue(rs, "groups.InheritProfiles", this.groupsInheritProfiles);
        this.groupsFilter = rs.getString("groups.Filter", null);
        this.groupsNamingDepth = this.getIntValue(rs, "groups.NamingDepth", this.groupsNamingDepth);
        this.groupsIdField = rs.getString("groups.IdField", null);
        this.groupsIncludeEmptyGroups = this.getBooleanValue(rs, "groups.IncludeEmptyGroups", this.groupsIncludeEmptyGroups);
        this.groupsSpecificGroupsBaseDN = this.getSureString(rs, "groups.SpecificGroupsBaseDN");
        this.groupsMemberField = this.getSureString(rs, "groups.MemberField");
        this.groupsNameField = this.getSureString(rs, "groups.NameField");
        this.groupsDescriptionField = this.getSureString(rs, "groups.DescriptionField");
        this.ihmImportUsers = this.getBooleanValue(rs, "ihm.importUsers", true);
        this.ihmImportGroups = this.getBooleanValue(rs, "ihm.importGroups", true);
    }

    public boolean isSynchroAutomatic() {
        return this.SYNCHROautomatic;
    }

    public boolean isSynchroRecursToGroups() {
        return this.SYNCHRORecursToGroups;
    }

    public boolean isSynchroThreaded() {
        return this.SYNCHROthreaded;
    }

    public String getTimeStampVar() {
        return this.SYNCHROtimeStampVar;
    }

    public boolean isSynchroCacheEnabled() {
        return this.SYNCHROCacheEnabled;
    }

    public boolean mustImportUsers() {
        return this.SYNCHROImportUsers;
    }

    public AbstractLDAPTimeStamp newLDAPTimeStamp(String theValue) {
        if (TIME_STAMP_MSAD.equalsIgnoreCase(this.getTimeStampVar())) {
            return new LDAPTimeStampMSAD(this, theValue);
        }
        return new LDAPTimeStampNDS(this, theValue);
    }

    public String getLDAPImpl() {
        return this.LDAPImpl;
    }

    public String getLDAPHost() {
        return this.configuration.getLdapHost();
    }

    public int getLDAPPort() {
        return this.configuration.getLdapPort();
    }

    public int getLDAPProtocolVer() {
        return this.LDAPProtocolVer;
    }

    public boolean isLDAPOpAttributesUsed() {
        return this.LDAPOpAttributesUsed;
    }

    public String getLDAPAccessLoginDN() {
        return this.configuration.getUsername();
    }

    public byte[] getLDAPAccessPasswd() {
        return this.configuration.getPassword();
    }

    public String getLDAPUserBaseDN() {
        return this.LDAPUserBaseDN;
    }

    public boolean getLDAPSearchRecurs() {
        return this.LDAPSearchRecurs;
    }

    public boolean isLDAPSecured() {
        return this.configuration.isSecure();
    }

    public int getScope() {
        if (this.LDAPSearchRecurs) {
            return 2;
        }
        return 1;
    }

    public LDAPSearchConstraints getSearchConstraints(boolean allocateNew) {
        if (allocateNew) {
            boolean doReferrals = true;
            if (this.LDAPMaxNbReferrals == 0) {
                doReferrals = false;
            }
            return new LDAPSearchConstraints(this.LDAPMaxMsClientTimeLimit, this.LDAPMaxSecServerTimeLimit, 0, this.LDAPMaxNbEntryReturned, doReferrals, this.LDAPBatchSize, null, this.LDAPMaxNbReferrals);
        }
        return this.LDAPDefaultSearchConstraints;
    }

    public LDAPConstraints getConstraints(boolean allocateNew) {
        if (allocateNew) {
            boolean doReferrals = true;
            if (this.LDAPMaxNbReferrals == 0) {
                doReferrals = false;
            }
            return new LDAPConstraints(this.LDAPMaxMsClientTimeLimit, doReferrals, null, this.LDAPMaxNbReferrals);
        }
        return this.LDAPDefaultConstraints;
    }

    public LDAPUser newLDAPUser() throws AdminException {
        try {
            if (this.usersType != null) {
                return (LDAPUser)Class.forName(this.usersType).newInstance();
            }
            return new LDAPUser();
        }
        catch (Exception e) {
            throw new AdminException("LDAPSettings.newLDAPUser", 4, "admin.EX_ERR_CANT_INSTANCIATE_USER_CLASS", this.usersType, e);
        }
    }

    public String getUsersClassName() {
        return this.usersClassName;
    }

    public String getUsersFilter() {
        return this.usersFilter;
    }

    public String getUsersFullFilter() {
        if (StringUtil.isDefined(this.usersFilter)) {
            return "(&(objectClass=" + this.usersClassName + ")" + this.usersFilter + ")";
        }
        return "(objectClass=" + this.usersClassName + ")";
    }

    public String getUsersIdField() {
        return this.usersIdField;
    }

    public String getUsersLoginField() {
        return this.usersLoginField;
    }

    public String getUsersFirstNameField() {
        return this.usersFirstNameField;
    }

    public String getUsersLastNameField() {
        return this.usersLastNameField;
    }

    public String getUsersEmailField() {
        return this.usersEmailField;
    }

    public String getUsersIdFilter(String value) {
        if (LDAPUtility.isAGuid(this.getUsersIdField()) && value != null) {
            char[] vca;
            StringBuilder singleSlashValue = new StringBuilder(value.length());
            boolean bIsFirst = true;
            for (char aVca : vca = value.toCharArray()) {
                if (aVca == '\\') {
                    if (bIsFirst) {
                        singleSlashValue.append(aVca);
                    }
                    bIsFirst = !bIsFirst;
                    continue;
                }
                bIsFirst = true;
                singleSlashValue.append(aVca);
            }
            return "(&" + this.getUsersFullFilter() + "(" + this.getUsersIdField() + "=" + singleSlashValue.toString() + "))";
        }
        return "(&" + this.getUsersFullFilter() + "(" + this.getUsersIdField() + "=" + LDAPUtility.normalizeFilterValue(value) + "))";
    }

    public String getUsersLoginFilter(String value) {
        return "(&" + this.getUsersFullFilter() + "(" + this.getUsersLoginField() + "=" + value + "))";
    }

    public AbstractLDAPGroup newLDAPGroup() throws AdminException {
        try {
            return (AbstractLDAPGroup)Class.forName(this.groupsType).newInstance();
        }
        catch (Exception e) {
            throw new AdminException("LDAPSettings.newLDAPGroup", 4, "admin.EX_ERR_CANT_INSTANCIATE_GROUP_CLASS", this.groupsType, e);
        }
    }

    public String getGroupsClassName() {
        return this.groupsClassName;
    }

    public boolean isGroupsInheritProfiles() {
        return this.groupsInheritProfiles;
    }

    public String getGroupsFilter() {
        return this.groupsFilter;
    }

    public int getGroupsNamingDepth() {
        return this.groupsNamingDepth;
    }

    public String getGroupsFullFilter() {
        if (this.groupsFilter != null && this.groupsFilter.length() > 0) {
            return "(&(objectClass=" + this.groupsClassName + ")" + this.groupsFilter + ")";
        }
        return "(objectClass=" + this.groupsClassName + ")";
    }

    public String getGroupsMemberField() {
        return this.groupsMemberField;
    }

    public String getGroupsSpecificGroupsBaseDN() {
        if (!StringUtil.isDefined(this.groupsSpecificGroupsBaseDN)) {
            return this.LDAPUserBaseDN;
        }
        if (this.groupsSpecificGroupsBaseDN.equalsIgnoreCase("root")) {
            return "";
        }
        return this.groupsSpecificGroupsBaseDN;
    }

    public String getGroupsIdField() {
        return this.groupsIdField;
    }

    public boolean getGroupsIncludeEmptyGroups() {
        return this.groupsIncludeEmptyGroups;
    }

    public String getGroupsNameField() {
        return this.groupsNameField;
    }

    public String getGroupsDescriptionField() {
        return this.groupsDescriptionField;
    }

    public String getGroupsIdFilter(String value) {
        if (LDAPUtility.isAGuid(this.getGroupsIdField()) && value != null) {
            char[] vca;
            StringBuilder singleSlashValue = new StringBuilder(value.length());
            boolean bIsFirst = true;
            for (char aVca : vca = value.toCharArray()) {
                if (aVca == '\\') {
                    if (bIsFirst) {
                        singleSlashValue.append(aVca);
                    }
                    bIsFirst = !bIsFirst;
                    continue;
                }
                bIsFirst = true;
                singleSlashValue.append(aVca);
            }
            return "(&" + this.getGroupsFullFilter() + "(" + this.getGroupsIdField() + "=" + singleSlashValue.toString() + "))";
        }
        return "(&" + this.getGroupsFullFilter() + "(" + this.getGroupsIdField() + "=" + LDAPUtility.normalizeFilterValue(value) + "))";
    }

    public String getGroupsNameFilter(String value) {
        return "(&" + this.getGroupsFullFilter() + "(" + this.getGroupsNameField() + "=" + value + "))";
    }

    protected String[] getUserAttributes() {
        if (this.isLDAPOpAttributesUsed()) {
            String[] attrs = new String[]{this.getUsersIdField(), this.getUsersEmailField(), this.getUsersFirstNameField(), this.getUsersLastNameField(), this.getUsersLoginField()};
            return attrs;
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    protected String[] getGroupAttributes() {
        if (this.isLDAPOpAttributesUsed()) {
            String[] attrs = new String[]{this.getGroupsDescriptionField(), this.getGroupsIdField(), this.getGroupsMemberField(), this.getGroupsNameField()};
            return attrs;
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public boolean displayImportUsers() {
        return this.ihmImportUsers;
    }

    public boolean displayImportGroups() {
        return this.ihmImportGroups;
    }

    public boolean isSortControlSupported() {
        return this.sortControlSupported;
    }
}

