/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.notificationManager;

import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminReference;
import com.stratelia.webactiv.beans.admin.Domain;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.ResourceLocator;
import java.net.URLEncoder;

public class AbstractNotification {
    private ResourceLocator notifResources = new ResourceLocator("com.stratelia.silverpeas.notificationManager.settings.notificationManagerSettings", "");

    public String getApplicationURL() {
        return URLManager.getApplicationURL();
    }

    public String computeURL(Integer userId, String urlBase) {
        return this.computeURL(Integer.toString(userId), urlBase);
    }

    public String computeURL(String userId, String urlBase) {
        return urlBase.startsWith("http") ? urlBase : this.getUserAutoRedirectURL(userId, urlBase);
    }

    public String getUserAutoRedirectURL(String userId, String target) {
        try {
            return this.getUserAutoRedirectURL(userId) + URLEncoder.encode(target, "UTF-8");
        }
        catch (Exception e) {
            SilverTrace.error("peasCore", "URLManager.getUserAutoRedirectURL(userId)", "root.EX_NO_MESSAGE", "Cannot encode '" + target + "'", e);
            return null;
        }
    }

    public String getUserAutoRedirectURL(String userId) {
        try {
            UserDetail ud = AdminReference.getAdminService().getUserDetail(userId);
            Domain dom = AdminReference.getAdminService().getDomain(ud.getDomainId());
            return dom.getSilverpeasServerURL() + this.getApplicationURL() + "/autoRedirect.jsp?domainId=" + dom.getId() + "&goto=";
        }
        catch (Exception ae) {
            SilverTrace.error("peasCore", "URLManager.getUserAutoRedirectURL(userId)", "admin.EX_ERR_GET_USER_DETAILS", "user id: '" + userId + "'", ae);
            return "ErrorGettingDomainServer";
        }
    }

    protected ResourceLocator getNotificationResources() {
        return this.notifResources;
    }

    public void setNotificationResources(ResourceLocator resourceLocator) {
        this.notifResources = resourceLocator;
    }
}

