/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.notificationManager;

import com.silverpeas.notification.delayed.delegate.DelayedNotificationDelegate;
import com.silverpeas.notification.delayed.model.DelayedNotificationData;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.notificationManager.AbstractNotification;
import com.stratelia.silverpeas.notificationManager.NotificationManagerException;
import com.stratelia.silverpeas.notificationManager.NotificationParameterNames;
import com.stratelia.silverpeas.notificationManager.NotificationParameters;
import com.stratelia.silverpeas.notificationManager.UserRecipient;
import com.stratelia.silverpeas.notificationManager.constant.NotifChannel;
import com.stratelia.silverpeas.notificationManager.model.NotifAddressRow;
import com.stratelia.silverpeas.notificationManager.model.NotifAddressTable;
import com.stratelia.silverpeas.notificationManager.model.NotifChannelRow;
import com.stratelia.silverpeas.notificationManager.model.NotifChannelTable;
import com.stratelia.silverpeas.notificationManager.model.NotifDefaultAddressRow;
import com.stratelia.silverpeas.notificationManager.model.NotifDefaultAddressTable;
import com.stratelia.silverpeas.notificationManager.model.NotifPreferenceRow;
import com.stratelia.silverpeas.notificationManager.model.NotifPreferenceTable;
import com.stratelia.silverpeas.notificationManager.model.NotifSchema;
import com.stratelia.silverpeas.notificationserver.NotificationData;
import com.stratelia.silverpeas.notificationserver.NotificationServer;
import com.stratelia.silverpeas.notificationserver.NotificationServerException;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.AdminReference;
import com.stratelia.webactiv.beans.admin.ComponentInst;
import com.stratelia.webactiv.beans.admin.SpaceInst;
import com.stratelia.webactiv.beans.admin.SpaceInstLight;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.exception.UtilException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.silverpeas.admin.user.constant.UserAccessLevel;

public class NotificationManager
extends AbstractNotification
implements NotificationParameterNames {
    public static final String FROM_NO = " ";
    public static final String FROM_UID = "I";
    public static final String FROM_EMAIL = "E";
    public static final String FROM_NAME = "N";
    private ResourceLocator m_Multilang = null;

    public NotificationManager(String language) {
        String safeLanguage = language;
        if (language == null || language.length() <= 0) {
            safeLanguage = "fr";
        }
        this.m_Multilang = new ResourceLocator("com.stratelia.silverpeas.notificationManager.multilang.notificationManagerBundle", safeLanguage);
    }

    public ArrayList<Properties> getNotificationAddresses(int aUserId) throws NotificationManagerException {
        ArrayList<Properties> adresses = new ArrayList<Properties>();
        NotifSchema schema = null;
        try {
            NotifAddressRow[] nar;
            schema = new NotifSchema();
            NotifAddressTable nat = schema.notifAddress;
            NotificationParameters params = new NotificationParameters();
            params.iMediaType = -10;
            boolean isMultiChannelSupported = this.isMultiChannelNotification();
            adresses.add(this.notifAddressRowToProperties(this.getNotifAddressRow(params, aUserId, schema), false, false, true, this.isDefaultAddress(-10, aUserId, schema, isMultiChannelSupported), schema));
            params.iMediaType = -12;
            adresses.add(this.notifAddressRowToProperties(this.getNotifAddressRow(params, aUserId, schema), false, false, true, this.isDefaultAddress(-12, aUserId, schema, isMultiChannelSupported), schema));
            params.iMediaType = -13;
            adresses.add(this.notifAddressRowToProperties(this.getNotifAddressRow(params, aUserId, schema), false, false, true, this.isDefaultAddress(-13, aUserId, schema, isMultiChannelSupported), schema));
            params.iMediaType = -11;
            adresses.add(this.notifAddressRowToProperties(this.getNotifAddressRow(params, aUserId, schema), false, false, false, this.isDefaultAddress(-11, aUserId, schema, isMultiChannelSupported), schema));
            for (NotifAddressRow aNar : nar = nat.getAllByUserId(aUserId)) {
                adresses.add(this.notifAddressRowToProperties(aNar, true, true, true, this.isDefaultAddress(aNar.getId(), aUserId, schema, isMultiChannelSupported), schema));
            }
        }
        catch (UtilException e) {
            throw new NotificationManagerException("NotificationManager.getNotificationAddresses()", 4, "notificationManager.EX_CANT_GET_NOTIF_ADDRESSES", "UserId=" + Integer.toString(aUserId), e);
        }
        finally {
            this.closeSchema(schema);
        }
        return adresses;
    }

    public Properties getNotificationAddress(int aNotificationAddressId, int aUserId) throws NotificationManagerException {
        NotifSchema schema = null;
        Properties p = null;
        try {
            schema = new NotifSchema();
            NotificationParameters params = new NotificationParameters();
            params.iMediaType = aNotificationAddressId;
            p = this.notifAddressRowToProperties(this.getNotifAddressRow(params, aUserId, schema), true, true, true, this.isDefaultAddress(aNotificationAddressId, aUserId, schema, false), schema);
        }
        catch (UtilException e) {
            throw new NotificationManagerException("NotificationManager.getNotificationAddress()", 4, "notificationManager.EX_CANT_GET_NOTIF_ADDRESS", "UserId=" + Integer.toString(aUserId) + ",NotifAddId=" + Integer.toString(aNotificationAddressId), e);
        }
        finally {
            this.closeSchema(schema);
        }
        return p;
    }

    public ArrayList<Properties> getDefaultAddresses(int aUserId) throws NotificationManagerException {
        NotifSchema schema = null;
        ArrayList<Properties> ar = new ArrayList<Properties>();
        NotifAddressRow row = null;
        Properties p = null;
        NotificationParameters params = new NotificationParameters();
        try {
            schema = new NotifSchema();
            params.iMediaType = -10;
            row = this.getNotifAddressRow(params, aUserId, schema);
            p = new Properties();
            p.setProperty("id", String.valueOf(row.getId()));
            p.setProperty("name", this.getSureString(row.getNotifName()));
            ar.add(p);
            params.iMediaType = -11;
            row = this.getNotifAddressRow(params, aUserId, schema);
            p = new Properties();
            p.setProperty("id", String.valueOf(row.getId()));
            p.setProperty("name", this.getSureString(row.getNotifName()));
            ar.add(p);
            params.iMediaType = -12;
            row = this.getNotifAddressRow(params, aUserId, schema);
            p = new Properties();
            p.setProperty("id", String.valueOf(row.getId()));
            p.setProperty("name", this.getSureString(row.getNotifName()));
            ar.add(p);
            params.iMediaType = -13;
            row = this.getNotifAddressRow(params, aUserId, schema);
            p = new Properties();
            p.setProperty("id", String.valueOf(row.getId()));
            p.setProperty("name", this.getSureString(row.getNotifName()));
            ar.add(p);
        }
        catch (UtilException e) {
            throw new NotificationManagerException("NotificationManager.getDefaultAddresses()", 4, "notificationManager.EX_CANT_GET_DEFAULT_ADDRESSES", "UserId=" + Integer.toString(aUserId), e);
        }
        finally {
            this.closeSchema(schema);
        }
        return ar;
    }

    public int getDefaultAddress(int aUserId) throws NotificationManagerException {
        NotifSchema schema = null;
        int addressId = -1;
        try {
            schema = new NotifSchema();
            NotifDefaultAddressTable ndat = schema.notifDefaultAddress;
            NotifDefaultAddressRow[] ndars = null;
            ndars = ndat.getAllByUserId(aUserId);
            if (ndars.length > 0) {
                addressId = ndars[0].getNotifAddressId();
            } else {
                List<Integer> defaultAddresses = this.getDefaultNotificationAddresses();
                addressId = defaultAddresses.get(0);
            }
        }
        catch (UtilException e) {
            throw new NotificationManagerException("NotificationManager.getDefaultAddress()", 4, "notificationManager.EX_CANT_GET_DEFAULT_ADDRESS", "UserId=" + Integer.toString(aUserId), e);
        }
        finally {
            this.closeSchema(schema);
        }
        return addressId;
    }

    public ArrayList<Properties> getNotifPriorities() {
        ArrayList<Properties> priorities = new ArrayList<Properties>();
        Properties priority = new Properties();
        priority.setProperty("id", Integer.toString(0));
        priority.setProperty("name", this.m_Multilang.getString("messagePriority" + Integer.toString(0)));
        priorities.add(priority);
        priority = new Properties();
        priority.setProperty("id", Integer.toString(1));
        priority.setProperty("name", this.m_Multilang.getString("messagePriority" + Integer.toString(1)));
        priorities.add(priority);
        priority = new Properties();
        priority.setProperty("id", Integer.toString(2));
        priority.setProperty("name", this.m_Multilang.getString("messagePriority" + Integer.toString(2)));
        priorities.add(priority);
        return priorities;
    }

    public ArrayList<Properties> getNotifUsages() {
        ArrayList<Properties> ar = new ArrayList<Properties>();
        Properties p = new Properties();
        p.setProperty("id", "addressUsePro");
        p.setProperty("name", this.m_Multilang.getString("addressUsePro"));
        ar.add(p);
        p = new Properties();
        p.setProperty("id", "addressUsePerso");
        p.setProperty("name", this.m_Multilang.getString("addressUsePerso"));
        ar.add(p);
        p = new Properties();
        p.setProperty("id", "addressUseRep");
        p.setProperty("name", this.m_Multilang.getString("addressUseRep"));
        ar.add(p);
        p = new Properties();
        p.setProperty("id", "addressUseUrgent");
        p.setProperty("name", this.m_Multilang.getString("addressUseUrgent"));
        ar.add(p);
        return ar;
    }

    public ArrayList<Properties> getNotifChannels() throws NotificationManagerException {
        NotifSchema schema = null;
        ArrayList<Properties> ar = new ArrayList<Properties>();
        try {
            NotifChannelRow[] rows;
            schema = new NotifSchema();
            NotifChannelTable nct = schema.notifChannel;
            for (NotifChannelRow row : rows = nct.getAllRows()) {
                if (!row.getCouldBeAdded().equalsIgnoreCase("Y")) continue;
                Properties p = new Properties();
                p.setProperty("id", String.valueOf(row.getId()));
                p.setProperty("name", this.m_Multilang.getString("channelType" + String.valueOf(row.getId())));
                ar.add(p);
            }
        }
        catch (UtilException e) {
            throw new NotificationManagerException("NotificationManager.getNotifChannels()", 4, "notificationManager.EX_CANT_GET_NOTIF_CHANNELS", e);
        }
        finally {
            this.closeSchema(schema);
        }
        return ar;
    }

    public ArrayList<Properties> getNotifPreferences(int aUserId) throws NotificationManagerException {
        ArrayList<Properties> ar = new ArrayList<Properties>();
        NotifSchema schema = null;
        try {
            schema = new NotifSchema();
            NotifPreferenceTable npt = schema.notifPreference;
            NotifPreferenceRow[] nprs = null;
            for (NotifPreferenceRow npr : nprs = npt.getAllByUserId(aUserId)) {
                ar.add(this.notifPreferencesRowToProperties(aUserId, npr, true, true, false, false, schema));
            }
        }
        catch (UtilException e) {
            throw new NotificationManagerException("NotificationManager.getNotifPreferences()", 4, "notificationManager.EX_CANT_GET_NOTIF_PREFS", "UserId=" + Integer.toString(aUserId), e);
        }
        finally {
            this.closeSchema(schema);
        }
        return ar;
    }

    public Properties getNotifPreference(int aPrefId, int aUserId) throws NotificationManagerException {
        NotifSchema schema = null;
        try {
            schema = new NotifSchema();
            NotifPreferenceTable npt = schema.notifPreference;
            NotifPreferenceRow npr = npt.getNotifPreference(aPrefId);
            Properties properties = this.notifPreferencesRowToProperties(aUserId, npr, true, true, false, false, schema);
            return properties;
        }
        catch (UtilException e) {
            throw new NotificationManagerException("NotificationManager.getNotifPreference()", 4, "notificationManager.EX_CANT_GET_NOTIF_PREF", "UserId=" + aUserId + ",prefID=" + aPrefId, e);
        }
        finally {
            this.closeSchema(schema);
        }
    }

    public void setDefaultAddress(int aNotificationAddressId, int aUserId) throws NotificationManagerException {
        NotifSchema schema = null;
        try {
            schema = new NotifSchema();
            NotifDefaultAddressTable ndat = schema.notifDefaultAddress;
            NotifDefaultAddressRow[] ndars = null;
            ndars = ndat.getAllByUserId(aUserId);
            if (ndars.length > 0) {
                if (ndars[0].getNotifAddressId() != aNotificationAddressId) {
                    ndars[0].setNotifAddressId(aNotificationAddressId);
                    ndat.update(ndars[0]);
                }
            } else {
                NotifDefaultAddressRow newRow = new NotifDefaultAddressRow(-1, aUserId, aNotificationAddressId);
                ndat.create(newRow);
            }
            schema.commit();
        }
        catch (UtilException e) {
            try {
                if (schema != null) {
                    schema.rollback();
                }
            }
            catch (Exception ex) {
                SilverTrace.warn("notificationManager", "NotificationManager.setDefaultAddress()", "root.EX_ERR_ROLLBACK", ex);
            }
            throw new NotificationManagerException("NotificationManager.setDefaultAddress()", 4, "notificationManager.EX_CANT_SET_DEFAULT_ADDRESS", "UserId=" + aUserId + ",NotifAddId=" + aNotificationAddressId, e);
        }
        finally {
            this.closeSchema(schema);
        }
    }

    public void addAddress(int aNotificationAddressId, int aUserId) throws NotificationManagerException {
        NotifSchema schema = null;
        try {
            schema = new NotifSchema();
            NotifDefaultAddressTable ndat = schema.notifDefaultAddress;
            NotifDefaultAddressRow newRow = new NotifDefaultAddressRow(-1, aUserId, aNotificationAddressId);
            ndat.create(newRow);
            schema.commit();
        }
        catch (UtilException e) {
            try {
                if (schema != null) {
                    schema.rollback();
                }
            }
            catch (Exception ex) {
                SilverTrace.warn("notificationManager", "NotificationManager.setDefaultAddress()", "root.EX_ERR_ROLLBACK", ex);
            }
            throw new NotificationManagerException("NotificationManager.setDefaultAddress()", 4, "notificationManager.EX_CANT_SET_DEFAULT_ADDRESS", "UserId=" + Integer.toString(aUserId) + ",NotifAddId=" + Integer.toString(aNotificationAddressId), e);
        }
        finally {
            this.closeSchema(schema);
        }
    }

    public void savePreferences(int aUserId, int aInstanceId, int aMessageType, int aDestinationId) throws NotificationManagerException {
        NotifSchema schema = null;
        try {
            schema = new NotifSchema();
            NotifPreferenceTable npt = schema.notifPreference;
            if (aMessageType == -1) {
                aMessageType = 0;
            }
            NotifPreferenceRow npr = npt.getByUserIdAndComponentInstanceIdAndMessageType(aUserId, aInstanceId, aMessageType);
            if (aDestinationId == -1) {
                if (npr != null) {
                    npt.delete(npr.getId());
                }
            } else {
                if (npr == null) {
                    npr = new NotifPreferenceRow(-1, aDestinationId, aInstanceId, aUserId, aMessageType);
                } else {
                    npr.setNotifAddressId(aDestinationId);
                }
                npt.save(npr);
            }
            schema.commit();
        }
        catch (UtilException e) {
            try {
                if (schema != null) {
                    schema.rollback();
                }
            }
            catch (Exception ex) {
                SilverTrace.warn("notificationManager", "NotificationManager.setDefaultAddress()", "root.EX_ERR_ROLLBACK", ex);
            }
            throw new NotificationManagerException("NotificationManager.savePreferences()", 4, "notificationManager.EX_CANT_SET_NOTIF_PREF", "UserId=" + Integer.toString(aUserId) + ",NotifAddId=" + Integer.toString(aDestinationId) + ",CompInstId=" + Integer.toString(aInstanceId), e);
        }
        finally {
            this.closeSchema(schema);
        }
    }

    public void saveNotifAddress(int aNotificationAddressId, int aUserId, String aNotifName, int aChannelId, String aAddress, String aUsage) throws NotificationManagerException {
        NotifSchema schema = null;
        try {
            schema = new NotifSchema();
            NotifAddressTable nat = schema.notifAddress;
            if (aUsage == null) {
                aUsage = "addressUsePro";
            }
            NotifAddressRow row = new NotifAddressRow(aNotificationAddressId, aUserId, aNotifName, aChannelId, aAddress, aUsage, 0);
            nat.save(row);
            schema.commit();
        }
        catch (UtilException e) {
            try {
                if (schema != null) {
                    schema.rollback();
                }
            }
            catch (Exception ex) {
                SilverTrace.warn("notificationManager", "NotificationManager.setDefaultAddress()", "root.EX_ERR_ROLLBACK", ex);
            }
            throw new NotificationManagerException("NotificationManager.saveNotifAddress()", 4, "notificationManager.EX_CANT_SET_NOTIF_ADDRESS", "UserId=" + Integer.toString(aUserId) + ",NotifAddId=" + Integer.toString(aNotificationAddressId) + ",Name=" + aNotifName, e);
        }
        finally {
            this.closeSchema(schema);
        }
    }

    public void deletePreference(int aPreferenceId) throws NotificationManagerException {
        NotifSchema schema = null;
        try {
            schema = new NotifSchema();
            NotifPreferenceTable npt = schema.notifPreference;
            npt.delete(aPreferenceId);
            schema.commit();
        }
        catch (UtilException e) {
            try {
                if (schema != null) {
                    schema.rollback();
                }
            }
            catch (Exception ex) {
                SilverTrace.warn("notificationManager", "NotificationManager.setDefaultAddress()", "root.EX_ERR_ROLLBACK", ex);
            }
            throw new NotificationManagerException("NotificationManager.deletePreference()", 4, "notificationManager.EX_CANT_DEL_NOTIF_PREF", "prefID=" + Integer.toString(aPreferenceId), e);
        }
        finally {
            this.closeSchema(schema);
        }
    }

    public void deleteNotifAddress(int aNotificationAddressId) throws NotificationManagerException {
        NotifSchema schema = null;
        try {
            schema = new NotifSchema();
            NotifAddressTable nat = schema.notifAddress;
            List<Integer> defaultAddresses = this.getDefaultNotificationAddresses();
            nat.deleteAndPropagate(aNotificationAddressId, defaultAddresses.get(0));
            schema.commit();
        }
        catch (UtilException e) {
            try {
                if (schema != null) {
                    schema.rollback();
                }
            }
            catch (Exception ex) {
                SilverTrace.warn("notificationManager", "NotificationManager.setDefaultAddress()", "root.EX_ERR_ROLLBACK", ex);
            }
            throw new NotificationManagerException("NotificationManager.deleteNotifAddress()", 4, "notificationManager.EX_CANT_DEL_NOTIF_ADDRESS", "notifID=" + aNotificationAddressId, e);
        }
        finally {
            this.closeSchema(schema);
        }
    }

    public void deleteAllAddress(int userId) throws NotificationManagerException {
        NotifSchema schema = null;
        try {
            schema = new NotifSchema();
            NotifDefaultAddressTable nat = schema.notifDefaultAddress;
            nat.dereferenceUserId(userId);
            schema.commit();
        }
        catch (UtilException e) {
            try {
                if (schema != null) {
                    schema.rollback();
                }
            }
            catch (Exception ex) {
                SilverTrace.warn("notificationManager", "NotificationManager.deleteAllAddress()", "root.EX_ERR_ROLLBACK", ex);
            }
            throw new NotificationManagerException("NotificationManager.deleteAllAddress()", 4, "notificationManager.EX_CANT_DEL_NOTIF_ADDRESS", "userId=" + Integer.toString(userId), e);
        }
        finally {
            this.closeSchema(schema);
        }
    }

    public void testNotifAddress(int aNotificationAddressId, int aUserId) throws NotificationManagerException {
        NotifSchema schema = null;
        NotificationData nd = null;
        NotificationServer ns = new NotificationServer();
        NotificationParameters params = new NotificationParameters();
        try {
            schema = new NotifSchema();
            params.iMediaType = aNotificationAddressId;
            params.sTitle = this.m_Multilang.getString("testMsgTitle");
            params.sMessage = this.m_Multilang.getString("testMsgBody");
            params.iFromUserId = aUserId;
            nd = this.createNotificationData(params, Integer.toString(aUserId), schema);
            ns.addNotification(nd);
            SilverTrace.info("notificationManager", "NotificationManager.testNotifAddress()", "root.MSG_GEN_EXIT_METHOD", "Test Notification Done !!!");
        }
        catch (UtilException e) {
            throw new NotificationManagerException("NotificationManager.testNotifAddress()", 4, "notificationManager.EX_CANT_CREATE_TEST_NOTIFICATION", "UserId=" + Integer.toString(aUserId) + ",NotifAddId=" + Integer.toString(aNotificationAddressId), e);
        }
        catch (NotificationServerException e) {
            throw new NotificationManagerException("NotificationManager.testNotifAddress()", 4, "notificationManager.EX_CANT_SEND_TEST_NOTIFICATION", "UserId=" + Integer.toString(aUserId) + ",NotifAddId=" + Integer.toString(aNotificationAddressId), e);
        }
        finally {
            this.closeSchema(schema);
        }
    }

    public void notifyUsers(NotificationParameters params, String[] aUserIds) throws NotificationManagerException {
        NotifSchema schema = null;
        if (UserAccessLevel.GUEST.equals((Object)this.getUserAccessLevel(params.iFromUserId))) {
            params.sMessage = this.m_Multilang.getString("guestNotAllowedBody1") + "\n" + params.sTitle + "\n\n" + this.m_Multilang.getString("guestNotAllowedBody2");
            params.sTitle = this.m_Multilang.getString("guestNotAllowedTitle");
            params.iMessagePriority = 0;
            params.iMediaType = -10;
            params.iComponentInstance = -1;
            aUserIds = new String[]{Integer.toString(params.iFromUserId)};
        }
        if (params.sTitle == null) {
            params.sTitle = "";
        } else if (params.sTitle.length() >= 1023) {
            throw new NotificationManagerException("NotificationManager.notifyUsers()", 4, "notificationManager.EX_TITLE_TOO_LONG", "Max=" + Integer.toString(1023));
        }
        if (params.sMessage == null) {
            params.sMessage = "";
        }
        try {
            schema = new NotifSchema();
            params.traceObject();
            for (String userId : aUserIds) {
                try {
                    SilverTrace.info("notificationManager", "NotificationManager.notifyUsers()", "root.MSG_GEN_PARAM_VALUE", "notifUserId : " + userId);
                    for (DelayedNotificationData dnd : this.createAllDelayedNotificationData(params, userId, schema)) {
                        DelayedNotificationDelegate.executeNewNotification(dnd);
                    }
                }
                catch (NotificationServerException e) {
                    throw new NotificationManagerException("NotificationManager.notifyUsers()", 4, "notificationManager.EX_CANT_SEND_USER_NOTIFICATION", "UserId=" + userId, e);
                }
                catch (Exception ex) {
                    SilverTrace.warn("notificationManager", "NotificationManager.notifyUsers()", "notificationManager.EX_CANT_SEND_USER_NOTIFICATION", "UserId=" + userId, ex);
                }
            }
        }
        catch (UtilException e) {
            throw new NotificationManagerException("NotificationManager.notifyUsers()", 4, "notificationManager.EX_CANT_CREATE_USER_NOTIFICATION", "NoUserId", e);
        }
        finally {
            this.closeSchema(schema);
        }
    }

    public Collection<UserRecipient> getUsersFromGroup(String groupId) throws NotificationManagerException {
        try {
            UserDetail[] users = AdminReference.getAdminService().getAllUsersOfGroup(groupId);
            ArrayList<UserRecipient> recipients = new ArrayList<UserRecipient>(users.length);
            for (UserDetail user : users) {
                recipients.add(new UserRecipient(user));
            }
            return recipients;
        }
        catch (AdminException e) {
            throw new NotificationManagerException("NotificationManager.getUsersFromGroup()", 4, "notificationManager.EX_CANT_GET_USERS_OF_GROUP", "groupId=" + groupId, e);
        }
    }

    public String getComponentFullName(String compInst) throws NotificationManagerException {
        return this.getComponentFullName(compInst, " - ", false);
    }

    public String getComponentFullName(String compInst, String separator, boolean isPathToComponent) throws NotificationManagerException {
        try {
            StringBuilder sb = new StringBuilder();
            ComponentInst instance = AdminReference.getAdminService().getComponentInst(compInst);
            if (!isPathToComponent) {
                SpaceInst space = AdminReference.getAdminService().getSpaceInstById(instance.getDomainFatherId());
                sb.append(space.getName());
                sb.append(separator);
            } else {
                List<SpaceInstLight> spaces = AdminReference.getAdminService().getPathToComponent(compInst);
                for (SpaceInstLight space : spaces) {
                    sb.append(space.getName());
                    sb.append(separator);
                }
            }
            sb.append(instance.getLabel());
            return sb.toString();
        }
        catch (AdminException e) {
            throw new NotificationManagerException("NotificationManager.getComponentFullName()", 4, "notificationManager.EX_CANT_GET_COMPONENT_FULL_NAME", "CompInstId" + compInst, e);
        }
    }

    protected String getUserEmail(int userId) {
        String valret = "";
        if (userId > -1) {
            try {
                UserDetail uDetail = AdminReference.getAdminService().getUserDetail(Integer.toString(userId));
                valret = uDetail.geteMail();
            }
            catch (AdminException e) {
                SilverTrace.warn("notificationManager", "NotificationManager.getUserEmail()", "notificationManager.EX_CANT_GET_USER_EMAIL", "UserId=" + userId, e);
            }
        }
        return valret;
    }

    protected UserAccessLevel getUserAccessLevel(int userId) {
        UserAccessLevel valret = UserAccessLevel.UNKNOWN;
        if (userId > -1) {
            try {
                UserDetail uDetail = AdminReference.getAdminService().getUserDetail(Integer.toString(userId));
                valret = uDetail.getAccessLevel();
            }
            catch (AdminException e) {
                SilverTrace.warn("notificationManager", "NotificationManager.getUserAccessLevel()", "notificationManager.EX_CANT_GET_USER_FULL_NAME", "UserId=" + userId, e);
            }
        }
        return valret;
    }

    protected String getUserFullName(int userId) {
        String valret = "";
        if (userId > -1) {
            try {
                UserDetail uDetail = AdminReference.getAdminService().getUserDetail(Integer.toString(userId));
                valret = uDetail.getDisplayedName();
            }
            catch (AdminException e) {
                SilverTrace.warn("notificationManager", "NotificationManager.getUserFullName()", "notificationManager.EX_CANT_GET_USER_FULL_NAME", "UserId=" + Integer.toString(userId), e);
            }
        }
        return valret;
    }

    protected Properties notifPreferencesRowToProperties(int aUserId, NotifPreferenceRow npr, boolean canEdit, boolean canDelete, boolean canTest, boolean isDefault, NotifSchema schema) throws UtilException, NotificationManagerException {
        Properties p = new Properties();
        NotifAddressRow nar = null;
        NotificationParameters params = new NotificationParameters();
        params.iMediaType = npr.getNotifAddressId();
        nar = this.getNotifAddressRow(params, aUserId, schema);
        p.setProperty("id", String.valueOf(npr.getId()));
        p.setProperty("notifAddressId", String.valueOf(npr.getNotifAddressId()));
        p.setProperty("notifAddress", this.getSureString(nar.getNotifName()));
        p.setProperty("componentId", String.valueOf(npr.getComponentInstanceId()));
        p.setProperty("component", this.getComponentFullName(String.valueOf(npr.getComponentInstanceId())));
        p.setProperty("priorityId", String.valueOf(npr.getMessageType()));
        p.setProperty("priority", this.getSureString(this.m_Multilang.getString("messagePriority" + String.valueOf(npr.getMessageType()))));
        p.setProperty("canEdit", String.valueOf(canEdit));
        p.setProperty("canDelete", String.valueOf(canDelete));
        p.setProperty("canTest", String.valueOf(canTest));
        p.setProperty("isDefault", String.valueOf(isDefault));
        return p;
    }

    protected Properties notifAddressRowToProperties(NotifAddressRow nar, boolean canEdit, boolean canDelete, boolean canTest, boolean isDefault, NotifSchema schema) throws UtilException {
        Properties p = new Properties();
        int channelId = nar.getNotifChannelId();
        int id = nar.getId();
        String theAddress = this.getSureString(nar.getAddress());
        NotifChannelTable nct = schema.notifChannel;
        NotifChannelRow crow = nct.getNotifChannel(channelId);
        p.setProperty("id", String.valueOf(id));
        p.setProperty("name", this.getSureString(nar.getNotifName()));
        p.setProperty("channelId", String.valueOf(channelId));
        p.setProperty("channel", this.getSureString(crow.getName()));
        p.setProperty("usageId", this.getSureString(nar.getUsage()));
        p.setProperty("usage", this.getSureString(this.m_Multilang.getString(this.getSureString(nar.getUsage()))));
        if (id == -10 || id == -12) {
            theAddress = this.getUserFullName(Integer.parseInt(theAddress));
        }
        p.setProperty("address", theAddress);
        p.setProperty("canEdit", String.valueOf(canEdit));
        p.setProperty("canDelete", String.valueOf(canDelete));
        p.setProperty("canTest", String.valueOf(canTest));
        p.setProperty("isDefault", String.valueOf(isDefault));
        return p;
    }

    protected NotifAddressRow getNotifAddressRow(NotificationParameters params, int aUserId, NotifSchema schema) throws UtilException {
        NotifAddressRow nar = null;
        int addressId = params.iMediaType;
        SilverTrace.info("notificationManager", "NotificationManager.getNotifAddressRow()", "root.MSG_GEN_ENTER_METHOD", "Enter with addressId = " + Integer.toString(addressId));
        if (addressId == -2) {
            addressId = -1;
            if (params.iComponentInstance != -1) {
                NotifPreferenceRow npr = null;
                npr = schema.notifPreference.getByUserIdAndComponentInstanceIdAndMessageType(aUserId, params.iComponentInstance, params.iMessagePriority);
                if (npr != null) {
                    addressId = npr.getNotifAddressId();
                }
            }
        }
        if (addressId == -1) {
            NotifDefaultAddressTable ndat = schema.notifDefaultAddress;
            NotifDefaultAddressRow[] ndars = null;
            ndars = ndat.getAllByUserId(aUserId);
            if (ndars.length > 0) {
                addressId = ndars[0].getNotifAddressId();
            } else {
                List<Integer> defaultAddresses = this.getDefaultNotificationAddresses();
                addressId = defaultAddresses.get(0);
            }
        }
        switch (addressId) {
            case -10: {
                SilverTrace.info("notificationManager", "NotificationManager.getNotifAddressRow()", "root.MSG_GEN_PARAM_VALUE", "addressId = BASIC POPUP");
                nar = new NotifAddressRow(-10, aUserId, this.m_Multilang.getString("defaultAddressPOPUP"), NotifChannel.POPUP.getId(), Integer.toString(aUserId), "addressUsePro", params.iMessagePriority);
                break;
            }
            case -11: {
                SilverTrace.info("notificationManager", "NotificationManager.getNotifAddressRow()", "root.MSG_GEN_PARAM_VALUE", "addressId = BASIC REMOVE");
                nar = new NotifAddressRow(-11, aUserId, this.m_Multilang.getString("defaultAddressREMOVE"), NotifChannel.REMOVE.getId(), "", "addressUsePro", params.iMessagePriority);
                break;
            }
            case -12: {
                SilverTrace.info("notificationManager", "NotificationManager.getNotifAddressRow()", "root.MSG_GEN_PARAM_VALUE", "addressId = BASIC SILVERMAIL");
                nar = new NotifAddressRow(-12, aUserId, this.m_Multilang.getString("defaultAddressSILVERMAIL"), NotifChannel.SILVERMAIL.getId(), Integer.toString(aUserId), "addressUsePro", params.iMessagePriority);
                break;
            }
            case -13: {
                SilverTrace.info("notificationManager", "NotificationManager.getNotifAddressRow()", "root.MSG_GEN_PARAM_VALUE", "addressId = BASIC SMTP MAIL");
                nar = new NotifAddressRow(-13, aUserId, this.m_Multilang.getString("defaultAddressSPMAIL"), NotifChannel.SMTP.getId(), this.getUserEmail(aUserId), "addressUsePro", params.iMessagePriority);
                break;
            }
            case -14: {
                SilverTrace.info("notificationManager", "NotificationManager.getNotifAddressRow()", "root.MSG_GEN_PARAM_VALUE", "addressId = BASIC SERVER");
                nar = new NotifAddressRow(-14, aUserId, this.m_Multilang.getString("defaultAddressSERVER"), NotifChannel.SERVER.getId(), Integer.toString(aUserId), "addressUsePro", params.iMessagePriority);
                break;
            }
            case -15: {
                SilverTrace.info("notificationManager", "NotificationManager.getNotifAddressRow()", "root.MSG_GEN_PARAM_VALUE", "addressId = BASIC COMMUNICATION USER");
                nar = new NotifAddressRow(-10, aUserId, this.m_Multilang.getString("defaultAddressPOPUP"), NotifChannel.POPUP.getId(), Integer.toString(aUserId), "addressUsePro", params.iMessagePriority);
                break;
            }
            default: {
                SilverTrace.info("notificationManager", "NotificationManager.getNotifAddressRow()", "root.MSG_GEN_PARAM_VALUE", "addressId = " + Integer.toString(addressId));
                nar = schema.notifAddress.getNotifAddress(addressId);
            }
        }
        return nar;
    }

    protected List<NotifAddressRow> getAllNotifAddressRow(NotificationParameters params, int aUserId, NotifSchema schema) throws UtilException {
        int[] addressIds = new int[1];
        int addressId = params.iMediaType;
        SilverTrace.info("notificationManager", "NotificationManager.getNotifAddressRow()", "root.MSG_GEN_ENTER_METHOD", "Enter with addressId = " + Integer.toString(addressId));
        if (addressId == -2) {
            addressId = -1;
            if (params.iComponentInstance != -1) {
                NotifPreferenceRow npr = null;
                npr = schema.notifPreference.getByUserIdAndComponentInstanceIdAndMessageType(aUserId, params.iComponentInstance, params.iMessagePriority);
                if (npr != null) {
                    addressId = npr.getNotifAddressId();
                }
            }
        }
        if (addressId == -1) {
            NotifDefaultAddressTable ndat = schema.notifDefaultAddress;
            NotifDefaultAddressRow[] ndars = null;
            ndars = ndat.getAllByUserId(aUserId);
            if (ndars.length > 0) {
                addressIds = new int[ndars.length];
                for (int i = 0; i < ndars.length; ++i) {
                    addressIds[i] = ndars[i].getNotifAddressId();
                }
            } else {
                List<Integer> defaultAddresses = this.getDefaultNotificationAddresses();
                addressIds = new int[defaultAddresses.size()];
                for (int i = 0; i < defaultAddresses.size(); ++i) {
                    addressIds[i] = defaultAddresses.get(i);
                }
            }
        } else {
            addressIds[0] = addressId;
        }
        ArrayList<NotifAddressRow> nars = new ArrayList<NotifAddressRow>(addressIds.length);
        for (int curAddressId : addressIds) {
            NotifAddressRow curNar;
            switch (curAddressId) {
                case -10: {
                    SilverTrace.info("notificationManager", "NotificationManager.getNotifAddressRow()", "root.MSG_GEN_PARAM_VALUE", "addressId = BASIC POPUP");
                    curNar = new NotifAddressRow(-10, aUserId, this.m_Multilang.getString("defaultAddressPOPUP"), NotifChannel.POPUP.getId(), Integer.toString(aUserId), "addressUsePro", params.iMessagePriority);
                    break;
                }
                case -11: {
                    SilverTrace.info("notificationManager", "NotificationManager.getNotifAddressRow()", "root.MSG_GEN_PARAM_VALUE", "addressId = BASIC REMOVE");
                    curNar = new NotifAddressRow(-11, aUserId, this.m_Multilang.getString("defaultAddressREMOVE"), NotifChannel.REMOVE.getId(), "", "addressUsePro", params.iMessagePriority);
                    break;
                }
                case -12: {
                    SilverTrace.info("notificationManager", "NotificationManager.getNotifAddressRow()", "root.MSG_GEN_PARAM_VALUE", "addressId = BASIC SILVERMAIL");
                    curNar = new NotifAddressRow(-12, aUserId, this.m_Multilang.getString("defaultAddressSILVERMAIL"), NotifChannel.SILVERMAIL.getId(), Integer.toString(aUserId), "addressUsePro", params.iMessagePriority);
                    break;
                }
                case -13: {
                    SilverTrace.info("notificationManager", "NotificationManager.getNotifAddressRow()", "root.MSG_GEN_PARAM_VALUE", "addressId = BASIC SMTP MAIL");
                    curNar = new NotifAddressRow(-13, aUserId, this.m_Multilang.getString("defaultAddressSPMAIL"), NotifChannel.SMTP.getId(), this.getUserEmail(aUserId), "addressUsePro", params.iMessagePriority);
                    break;
                }
                case -14: {
                    SilverTrace.info("notificationManager", "NotificationManager.getNotifAddressRow()", "root.MSG_GEN_PARAM_VALUE", "addressId = BASIC SERVER");
                    curNar = new NotifAddressRow(-14, aUserId, this.m_Multilang.getString("defaultAddressSERVER"), NotifChannel.SERVER.getId(), Integer.toString(aUserId), "addressUsePro", params.iMessagePriority);
                    break;
                }
                case -15: {
                    SilverTrace.info("notificationManager", "NotificationManager.getNotifAddressRow()", "root.MSG_GEN_PARAM_VALUE", "addressId = BASIC COMMUNICATION USER");
                    curNar = new NotifAddressRow(-10, aUserId, this.m_Multilang.getString("defaultAddressPOPUP"), NotifChannel.POPUP.getId(), Integer.toString(aUserId), "addressUsePro", params.iMessagePriority);
                    break;
                }
                default: {
                    SilverTrace.info("notificationManager", "NotificationManager.getNotifAddressRow()", "root.MSG_GEN_PARAM_VALUE", "addressId = " + Integer.toString(curAddressId));
                    curNar = schema.notifAddress.getNotifAddress(curAddressId);
                }
            }
            nars.add(curNar);
        }
        return nars;
    }

    protected NotificationData createNotificationData(NotificationParameters params, String aUserId, NotifSchema schema) throws UtilException {
        NotificationData nd = new NotificationData();
        NotifAddressRow nar = null;
        NotifChannelRow ncr = null;
        StringBuilder theMessage = new StringBuilder(100);
        HashMap<String, Object> theExtraParams = new HashMap<String, Object>();
        nar = this.getNotifAddressRow(params, Integer.parseInt(aUserId), schema);
        ncr = schema.notifChannel.getNotifChannel(nar.getNotifChannelId());
        nd = new NotificationData();
        nd.setTargetChannel(ncr.getName());
        nd.setTargetReceipt(nar.getAddress());
        SilverTrace.info("notificationManager", "NotificationManager.createNotificationData()", "root.MSG_GEN_PARAM_VALUE", "params.iFromUserId =" + params.iFromUserId);
        if ("Y".equalsIgnoreCase(ncr.getSubjectAvailable())) {
            theExtraParams.put("SUBJECT", params.sTitle);
        } else if (params.iFromUserId < 0) {
            theMessage.append(this.m_Multilang.getString("subject")).append(" : ").append(params.sTitle).append("\n\n");
        }
        String senderName = params.iFromUserId < 0 ? params.senderName : this.getUserFullName(params.iFromUserId);
        SilverTrace.info("notificationManager", "NotificationManager.createNotificationData()", "root.MSG_GEN_PARAM_VALUE", "iFromUserId =" + params.iFromUserId);
        if (FROM_UID.equalsIgnoreCase(ncr.getFromAvailable())) {
            theExtraParams.put("FROM", Integer.toString(params.iFromUserId));
            nd.setSenderId(Integer.toString(params.iFromUserId));
            SilverTrace.info("notificationManager", "NotificationManager.createNotificationData()", "root.MSG_GEN_PARAM_VALUE", "nd.getSenderId() =" + nd.getSenderId());
        } else if (FROM_EMAIL.equalsIgnoreCase(ncr.getFromAvailable())) {
            String fromEmail = senderName;
            if (!(StringUtil.isValidEmailAddress(fromEmail) && params.iFromUserId < 0 || StringUtil.isDefined(fromEmail = this.getUserEmail(params.iFromUserId)))) {
                fromEmail = AdminReference.getAdminService().getAdministratorEmail();
            }
            theExtraParams.put("FROM", fromEmail);
            SilverTrace.info("notificationManager", "NotificationManager.createNotificationData()", "root.MSG_GEN_PARAM_VALUE", "nd.getUserEmail(params.iFromUserId) =" + this.getUserEmail(params.iFromUserId));
        } else if (FROM_NAME.equalsIgnoreCase(ncr.getFromAvailable())) {
            theExtraParams.put("FROM", senderName);
        } else {
            theMessage.append(this.m_Multilang.getString("from")).append(" : ").append(senderName).append("\n\n");
        }
        if (params.sURL != null && params.sURL.length() > 0) {
            theExtraParams.put("URL", params.sURL.startsWith("http") ? params.sURL : this.getUserAutoRedirectURL(aUserId, params.sURL));
        }
        if (params.sSource != null && params.sSource.length() > 0) {
            theExtraParams.put("SOURCE", params.sSource);
        } else if (params.iComponentInstance != -1) {
            try {
                theExtraParams.put("SOURCE", this.getComponentFullName("" + params.iComponentInstance));
            }
            catch (Exception e) {
                SilverTrace.warn("notificationManager", "NotificationManager.createNotificationData()", "notificationManager.EX_CANT_GET_INSTANCE_INFO", "instanceId = " + params.iComponentInstance, e);
            }
        }
        if (params.sSessionId != null && params.sSessionId.length() > 0) {
            theExtraParams.put("SESSIONID", params.sSessionId);
        }
        if (params.dDate != null) {
            theExtraParams.put("DATE", params.dDate);
        }
        if (params.sLanguage != null) {
            theExtraParams.put("LANGUAGE", params.sLanguage);
        }
        nd.setSenderName(senderName);
        if (theExtraParams.size() > 0) {
            nd.setTargetParam(theExtraParams);
        }
        theMessage.append(params.sMessage);
        nd.setMessage(theMessage.toString());
        nd.setAnswerAllowed(params.bAnswerAllowed);
        if (params.iMediaType == -15) {
            nd.setComment("COMMUNICATION");
        }
        SilverTrace.info("notificationManager", "NotificationManager.createNotificationData()", "root.MSG_GEN_PARAM_VALUE", "nd.isAnswerAllowed() =" + nd.isAnswerAllowed());
        return nd;
    }

    protected List<DelayedNotificationData> createAllDelayedNotificationData(NotificationParameters params, String aUserId, NotifSchema schema) throws UtilException {
        List<NotifAddressRow> nars = this.getAllNotifAddressRow(params, Integer.parseInt(aUserId), schema);
        ArrayList<DelayedNotificationData> dnds = new ArrayList<DelayedNotificationData>(nars.size());
        for (NotifAddressRow curAddresseRow : nars) {
            NotifChannelRow notifChannelRow = schema.notifChannel.getNotifChannel(curAddresseRow.getNotifChannelId());
            NotificationData notificationData = new NotificationData();
            DelayedNotificationData delayedNotificationData = new DelayedNotificationData();
            delayedNotificationData.setUserId(aUserId);
            delayedNotificationData.setAction(params.eAction);
            delayedNotificationData.setChannel(NotifChannel.decode(curAddresseRow.getNotifChannelId()));
            delayedNotificationData.setCreationDate(params.dDate);
            delayedNotificationData.setFromUserId(params.iFromUserId);
            delayedNotificationData.setLanguage(params.sLanguage);
            delayedNotificationData.setMessage(params.sOriginalExtraMessage);
            delayedNotificationData.setResource(params.nNotificationResourceData);
            delayedNotificationData.setSendImmediately(params.bSendImmediately);
            delayedNotificationData.setNotificationData(notificationData);
            delayedNotificationData.setNotificationParameters(params);
            dnds.add(delayedNotificationData);
            StringBuilder theMessage = new StringBuilder(100);
            HashMap<String, Object> theExtraParams = new HashMap<String, Object>();
            notificationData.setTargetChannel(notifChannelRow.getName());
            notificationData.setTargetReceipt(curAddresseRow.getAddress());
            SilverTrace.info("notificationManager", "NotificationManager.createNotificationData()", "root.MSG_GEN_PARAM_VALUE", "params.iFromUserId =" + params.iFromUserId);
            if ("Y".equalsIgnoreCase(notifChannelRow.getSubjectAvailable())) {
                theExtraParams.put("SUBJECT", params.sTitle);
            } else if (params.iFromUserId < 0) {
                theMessage.append(this.m_Multilang.getString("subject")).append(" : ").append(params.sTitle).append("\n\n");
            }
            String senderName = params.iFromUserId < 0 ? params.senderName : this.getUserFullName(params.iFromUserId);
            SilverTrace.info("notificationManager", "NotificationManager.createNotificationData()", "root.MSG_GEN_PARAM_VALUE", "iFromUserId =" + params.iFromUserId);
            if (FROM_UID.equalsIgnoreCase(notifChannelRow.getFromAvailable())) {
                theExtraParams.put("FROM", Integer.toString(params.iFromUserId));
                notificationData.setSenderId(Integer.toString(params.iFromUserId));
                SilverTrace.info("notificationManager", "NotificationManager.createNotificationData()", "root.MSG_GEN_PARAM_VALUE", "nd.getSenderId() =" + notificationData.getSenderId());
            } else if (FROM_EMAIL.equalsIgnoreCase(notifChannelRow.getFromAvailable())) {
                String fromEmail = senderName;
                if (!(StringUtil.isValidEmailAddress(fromEmail) && params.iFromUserId < 0 || StringUtil.isDefined(fromEmail = this.getUserEmail(params.iFromUserId)))) {
                    fromEmail = AdminReference.getAdminService().getAdministratorEmail();
                }
                theExtraParams.put("FROM", fromEmail);
                SilverTrace.info("notificationManager", "NotificationManager.createNotificationData()", "root.MSG_GEN_PARAM_VALUE", "nd.getUserEmail(params.iFromUserId) =" + this.getUserEmail(params.iFromUserId));
            } else if (FROM_NAME.equalsIgnoreCase(notifChannelRow.getFromAvailable())) {
                theExtraParams.put("FROM", senderName);
            } else {
                theMessage.append(this.m_Multilang.getString("from")).append(" : ").append(senderName).append("\n\n");
            }
            if (params.sURL != null && params.sURL.length() > 0) {
                theExtraParams.put("URL", this.computeURL(aUserId, params.sURL));
            }
            if (params.sSource != null && params.sSource.length() > 0) {
                theExtraParams.put("SOURCE", params.sSource);
            } else if (params.iComponentInstance != -1) {
                try {
                    String componentFullName = this.getComponentFullName(String.valueOf(params.iComponentInstance));
                    theExtraParams.put("SOURCE", componentFullName);
                    if (delayedNotificationData.getResource() != null && StringUtils.isBlank((String)delayedNotificationData.getResource().getResourceLocation())) {
                        delayedNotificationData.getResource().setResourceLocation(this.getComponentFullName(String.valueOf(params.iComponentInstance), "@#@#@", true));
                    }
                }
                catch (Exception e) {
                    SilverTrace.warn("notificationManager", "NotificationManager.createNotificationData()", "notificationManager.EX_CANT_GET_INSTANCE_INFO", "instanceId = " + params.iComponentInstance, e);
                }
            }
            if (params.sSessionId != null && params.sSessionId.length() > 0) {
                theExtraParams.put("SESSIONID", params.sSessionId);
            }
            if (params.dDate != null) {
                theExtraParams.put("DATE", params.dDate);
            }
            if (params.sLanguage != null) {
                theExtraParams.put("LANGUAGE", params.sLanguage);
            }
            notificationData.setSenderName(senderName);
            if (theExtraParams.size() > 0) {
                notificationData.setTargetParam(theExtraParams);
            }
            theMessage.append(params.sMessage);
            notificationData.setMessage(theMessage.toString());
            notificationData.setAnswerAllowed(params.bAnswerAllowed);
            if (params.iMediaType == -15) {
                notificationData.setComment("COMMUNICATION");
            }
            SilverTrace.info("notificationManager", "NotificationManager.createNotificationData()", "root.MSG_GEN_PARAM_VALUE", "nd.isAnswerAllowed() =" + notificationData.isAnswerAllowed());
        }
        return dnds;
    }

    protected boolean isDefaultAddress(int aDefaultAddressId, int aUserId, NotifSchema schema, boolean isMultiChannelNotification) throws UtilException {
        NotifDefaultAddressTable ndat = schema.notifDefaultAddress;
        NotifDefaultAddressRow[] ndars = null;
        boolean valret = false;
        ndars = ndat.getAllByUserId(aUserId);
        if (ndars.length > 0) {
            if (!isMultiChannelNotification) {
                if (aDefaultAddressId == ndars[0].getNotifAddressId()) {
                    valret = true;
                }
            } else {
                for (NotifDefaultAddressRow ndar : ndars) {
                    if (aDefaultAddressId != ndar.getNotifAddressId()) continue;
                    valret = true;
                }
            }
        } else {
            List<Integer> defaultAdresses = this.getDefaultNotificationAddresses();
            if (defaultAdresses.contains(aDefaultAddressId)) {
                valret = true;
            }
        }
        return valret;
    }

    protected String getSureString(String s) {
        if (s != null) {
            return s;
        }
        return "";
    }

    protected void closeSchema(NotifSchema schema) {
        try {
            if (schema != null) {
                schema.close();
            }
        }
        catch (Exception e) {
            SilverTrace.warn("notificationManager", "NotificationManager.closeSchema()", "notificationManager.EX_CANT_CLOSE_SCHEMA", "", e);
        }
    }

    public boolean isMultiChannelNotification() {
        return "true".equalsIgnoreCase(this.getNotificationResources().getString("multiChannelNotification"));
    }

    protected List<Integer> getDefaultNotificationAddresses() {
        String defaultChannels = this.getNotificationResources().getString("notif.defaultChannels");
        boolean isMultiChannelSupported = this.isMultiChannelNotification();
        String[] channels = defaultChannels == null ? new String[]{} : defaultChannels.split("[ ]+");
        ArrayList<Integer> mediaIds = new ArrayList<Integer>(channels.length + 1);
        for (String channel : channels) {
            if ("BASIC_POPUP".equalsIgnoreCase(channel) && !mediaIds.contains(-10)) {
                mediaIds.add(-10);
            } else if ("BASIC_REMOVE".equalsIgnoreCase(channel) && !mediaIds.contains(-11)) {
                mediaIds.add(-11);
            } else if ("BASIC_SILVERMAIL".equalsIgnoreCase(channel) && !mediaIds.contains(-12)) {
                mediaIds.add(-12);
            } else if ("BASIC_SMTP_MAIL".equalsIgnoreCase(channel) && !mediaIds.contains(-13)) {
                mediaIds.add(-13);
            } else if ("BASIC_SERVER".equalsIgnoreCase(channel) && !mediaIds.contains(-14)) {
                mediaIds.add(-14);
            } else if ("BASIC_COMMUNICATION_USER".equalsIgnoreCase(channel) && !mediaIds.contains(-15)) {
                mediaIds.add(-15);
            }
            if (!isMultiChannelSupported && !mediaIds.isEmpty()) break;
        }
        if (mediaIds.isEmpty()) {
            mediaIds.add(-13);
        }
        return mediaIds;
    }
}

