/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.notificationManager;

import com.silverpeas.notification.model.NotificationResourceData;
import com.silverpeas.util.EncodeHelper;
import com.silverpeas.util.i18n.I18NHelper;
import com.silverpeas.util.template.SilverpeasTemplate;
import com.stratelia.silverpeas.notificationManager.GroupRecipient;
import com.stratelia.silverpeas.notificationManager.UserRecipient;
import com.stratelia.silverpeas.notificationManager.constant.NotifAction;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class NotificationMetaData
implements Serializable {
    private static final long serialVersionUID = 6004274748540324759L;
    private int messageType;
    private Date date;
    private String sender;
    private String source;
    private String link;
    private String sessionId;
    private Collection<UserRecipient> userRecipients;
    private Collection<UserRecipient> userRecipientsToExclude;
    private Collection<GroupRecipient> groupRecipients;
    private String componentId;
    private boolean isAnswerAllowed = false;
    private String fileName;
    private boolean sendImmediately = false;
    private NotifAction action;
    private Map<String, NotificationResourceData> notificationResourceData = new HashMap<String, NotificationResourceData>();
    private Map<String, String> titles = new HashMap<String, String>();
    private Map<String, String> contents = new HashMap<String, String>();
    private Map<String, SilverpeasTemplate> templates;
    private String originalExtraMessage = null;

    public NotificationMetaData() {
        this.reset();
    }

    public NotificationMetaData(int messageType, String title, String content) {
        this.reset();
        this.messageType = messageType;
        this.templates = new HashMap<String, SilverpeasTemplate>();
        this.addLanguage(I18NHelper.defaultLanguage, title, content);
    }

    public NotificationMetaData(int messageType, String title, Map<String, SilverpeasTemplate> templates, String fileName) {
        this(messageType, title, "");
        this.reset();
        this.templates = templates;
        this.fileName = fileName;
    }

    private void reset() {
        this.messageType = 0;
        this.date = new Date();
        this.sender = "";
        this.source = "";
        this.link = "";
        this.sessionId = "";
        this.userRecipients = new ArrayList<UserRecipient>();
        this.userRecipientsToExclude = new ArrayList<UserRecipient>();
        this.groupRecipients = new ArrayList<GroupRecipient>();
        this.componentId = "";
        this.isAnswerAllowed = false;
        this.fileName = null;
        this.templates = new HashMap<String, SilverpeasTemplate>();
        this.action = null;
        this.notificationResourceData.clear();
    }

    public final void addLanguage(String language, String title, String content) {
        this.titles.put(language, title);
        this.contents.put(language, content);
    }

    public Set<String> getLanguages() {
        return this.titles.keySet();
    }

    public Map<String, SilverpeasTemplate> getTemplates() {
        return Collections.unmodifiableMap(this.templates);
    }

    public Boolean isTemplateUsed() {
        return !this.templates.isEmpty();
    }

    public void setMessageType(int messageType) {
        this.messageType = messageType;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Date getDate() {
        return this.date;
    }

    public void setTitle(String title) {
        this.titles.put(I18NHelper.defaultLanguage, title);
    }

    public void setTitle(String title, String language) {
        this.titles.put(language, title);
    }

    public String getTitle() {
        return this.getTitle(I18NHelper.defaultLanguage);
    }

    public String getTitle(String language) {
        String result = "";
        if (this.templates != null && !this.templates.isEmpty()) {
            SilverpeasTemplate template = this.templates.get(language);
            if (template != null) {
                result = template.applyStringTemplate(this.titles.get(language));
            }
        } else {
            result = this.titles.get(language);
        }
        return result;
    }

    public void setContent(String content) {
        this.contents.put(I18NHelper.defaultLanguage, content);
    }

    public void setContent(String content, String language) {
        SilverTrace.info("notificationManager", "NotificationMetaData.setContent()", "root.MSG_GEN_ENTER_METHOD", "language = " + language + ", content = " + content);
        this.contents.put(language, content);
    }

    public String getContent() {
        return this.getContent(I18NHelper.defaultLanguage);
    }

    public String getContent(String language) {
        SilverTrace.info("notificationManager", "NotificationMetaData.getContent()", "root.MSG_GEN_ENTER_METHOD", "language = " + language);
        String result = "";
        if (this.templates != null && !this.templates.isEmpty()) {
            SilverpeasTemplate template = this.templates.get(language);
            if (template != null) {
                result = template.applyFileTemplate(this.fileName + '_' + language);
            }
        } else {
            result = this.contents.get(language);
        }
        SilverTrace.info("notificationManager", "NotificationMetaData.getContent()", "root.MSG_GEN_EXIT_METHOD", "result = " + result);
        return EncodeHelper.convertWhiteSpacesForHTMLDisplay(result);
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public void setAnswerAllowed(boolean answerAllowed) {
        this.isAnswerAllowed = answerAllowed;
    }

    public String getSender() {
        return this.sender;
    }

    public boolean isAnswerAllowed() {
        return this.isAnswerAllowed;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getLink() {
        return this.link;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setUserRecipients(Collection<UserRecipient> users) {
        this.userRecipients = users != null ? new ArrayList<UserRecipient>(users) : new ArrayList<UserRecipient>();
    }

    public Collection<UserRecipient> getUserRecipients() {
        return this.userRecipients;
    }

    public void addUserRecipient(UserRecipient user) {
        this.userRecipients.add(user);
    }

    public void addUserRecipients(UserRecipient[] users) {
        if (users != null) {
            this.userRecipients.addAll(Arrays.asList(users));
        }
    }

    public void addUserRecipients(Collection<UserRecipient> users) {
        if (users != null) {
            this.userRecipients.addAll(users);
        }
    }

    public void setUserRecipientsToExclude(Collection<UserRecipient> users) {
        this.userRecipientsToExclude = users != null ? new ArrayList<UserRecipient>(users) : new ArrayList<UserRecipient>();
    }

    public Collection<UserRecipient> getUserRecipientsToExclude() {
        return this.userRecipientsToExclude;
    }

    public void addUserRecipientToExclude(UserRecipient user) {
        this.userRecipientsToExclude.add(user);
    }

    public void addUserRecipientsToExclude(UserRecipient[] users) {
        if (users != null) {
            this.userRecipientsToExclude.addAll(Arrays.asList(users));
        }
    }

    public void addUserRecipientsToExclude(Collection<UserRecipient> users) {
        if (users != null) {
            this.userRecipientsToExclude.addAll(users);
        }
    }

    public void setGroupRecipients(Collection<GroupRecipient> groups) {
        this.groupRecipients = groups != null ? new ArrayList<GroupRecipient>(groups) : new ArrayList<GroupRecipient>();
    }

    public Collection<GroupRecipient> getGroupRecipients() {
        return Collections.unmodifiableCollection(this.groupRecipients);
    }

    public void addGroupRecipient(GroupRecipient group) {
        this.groupRecipients.add(group);
    }

    public void addGroupRecipients(Collection<GroupRecipient> groups) {
        if (groups != null) {
            this.groupRecipients.addAll(groups);
        }
    }

    public String getComponentId() {
        return this.componentId;
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public void addExtraMessage(String message, String label, String language) {
        this.setOriginalExtraMessage(message);
        if (this.templates != null && !this.templates.isEmpty()) {
            this.templates.get(language).setAttribute("senderMessage", message);
        } else {
            StringBuffer content = new StringBuffer(this.getContent(language));
            if (content != null) {
                content.append("\n\n").append(label).append(" : \n\"").append(message).append("\"");
                this.setContent(content.toString(), language);
            }
        }
    }

    public String getOriginalExtraMessage() {
        return this.originalExtraMessage;
    }

    public void setOriginalExtraMessage(String originalExtraMessage) {
        this.originalExtraMessage = originalExtraMessage;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isSendImmediately() {
        return this.sendImmediately;
    }

    public void setSendImmediately(boolean sendImmediately) {
        this.sendImmediately = sendImmediately;
    }

    public NotifAction getAction() {
        return this.action;
    }

    public void setAction(NotifAction action) {
        this.action = action;
    }

    public void setNotificationResourceData(NotificationResourceData notificationResourceData) {
        this.setNotificationResourceData(I18NHelper.defaultLanguage, notificationResourceData);
    }

    public void setNotificationResourceData(String lang, NotificationResourceData notificationResourceData) {
        this.notificationResourceData.put(lang, notificationResourceData);
    }

    public NotificationResourceData getNotificationResourceData() {
        return this.getNotificationResourceData(I18NHelper.defaultLanguage);
    }

    public NotificationResourceData getNotificationResourceData(String lang) {
        return this.notificationResourceData.get(lang);
    }
}

