/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.notificationManager;

import com.silverpeas.SilverpeasServiceProvider;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.template.SilverpeasTemplate;
import com.stratelia.silverpeas.notificationManager.GroupRecipient;
import com.stratelia.silverpeas.notificationManager.NotificationManager;
import com.stratelia.silverpeas.notificationManager.NotificationManagerException;
import com.stratelia.silverpeas.notificationManager.NotificationMetaData;
import com.stratelia.silverpeas.notificationManager.NotificationParameters;
import com.stratelia.silverpeas.notificationManager.NotificationTemplateKey;
import com.stratelia.silverpeas.notificationManager.UserRecipient;
import com.stratelia.silverpeas.notificationManager.constant.NotifMediaType;
import com.stratelia.silverpeas.notificationManager.model.SendedNotificationInterface;
import com.stratelia.silverpeas.notificationManager.model.SendedNotificationInterfaceImpl;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.Group;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.ResourceLocator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.silverpeas.core.admin.OrganisationController;
import org.silverpeas.core.admin.OrganisationControllerFactory;

public class NotificationSender
implements Serializable {
    private static final long serialVersionUID = 4165938893905145809L;
    private static ResourceLocator settings = new ResourceLocator("com.stratelia.silverpeas.notificationManager.settings.notificationManagerSettings", "");
    protected NotificationManager notificationManager = null;
    protected int instanceId = -1;

    public NotificationSender(String instanceId) {
        this.instanceId = NotificationSender.extractLastNumber(instanceId);
        this.notificationManager = new NotificationManager(null);
    }

    public void notifyUser(NotificationMetaData metaData) throws NotificationManagerException {
        this.notifyUser(NotifMediaType.COMPONENT_DEFINED.getId(), metaData);
    }

    protected boolean isNotificationManual(NotificationMetaData metaData) {
        return StringUtil.isInteger(metaData.getSender());
    }

    public void notifyUser(int aMediaType, NotificationMetaData metaData) throws NotificationManagerException {
        OrganisationController orgaController = OrganisationControllerFactory.getOrganisationController();
        HashSet<UserRecipient> usersSet = new HashSet<UserRecipient>();
        Collection<UserRecipient> userRecipients = metaData.getUserRecipients();
        Collection<GroupRecipient> groupRecipients = metaData.getGroupRecipients();
        SilverTrace.info("notificationManager", "NotificationSender.notifyUser()", "root.MSG_GEN_ENTER_METHOD");
        usersSet.addAll(userRecipients);
        for (GroupRecipient group : groupRecipients) {
            usersSet.addAll(this.notificationManager.getUsersFromGroup(group.getGroupId()));
        }
        usersSet.removeAll(metaData.getUserRecipientsToExclude());
        Set<String> languages = metaData.getLanguages();
        HashMap<String, String> usersLanguage = new HashMap<String, String>(usersSet.size());
        for (UserRecipient user : usersSet) {
            usersLanguage.put(user.getUserId(), SilverpeasServiceProvider.getPersonalizationService().getUserSettings(user.getUserId()).getLanguage());
        }
        NotificationParameters params = null;
        Set allUserIds = usersLanguage.keySet();
        SilverTrace.info("notificationManager", "NotificationSender.notifyUser()", "root.MSG_GEN_PARAM_VALUE", "allUserIds = " + allUserIds);
        for (String language : languages) {
            SilverTrace.info("notificationManager", "NotificationSender.notifyUser()", "root.MSG_GEN_PARAM_VALUE", "language = " + language);
            params = this.getNotificationParameters(aMediaType, metaData);
            params.sTitle = metaData.getTitle(language);
            if (!metaData.isTemplateUsed().booleanValue()) {
                this.manageManualNotification(this.getUserSet(metaData, settings), this.getGroupSet(metaData, settings), languages, metaData, orgaController);
            } else {
                SilverpeasTemplate template;
                Map<String, SilverpeasTemplate> templates = metaData.getTemplates();
                if (templates != null && !templates.isEmpty() && (template = templates.get(language)) != null) {
                    try {
                        String receiver_groups;
                        String receiver_users = this.addReceiverUsers(this.getUserSet(metaData, settings));
                        if (StringUtil.isDefined(receiver_users)) {
                            template.setAttribute(NotificationTemplateKey.notification_receiver_users.toString(), receiver_users);
                        }
                        if (StringUtil.isDefined(receiver_groups = this.addReceiverGroups(this.getGroupSet(metaData, settings)))) {
                            template.setAttribute(NotificationTemplateKey.notification_receiver_groups.toString(), receiver_groups);
                        }
                    }
                    catch (NotificationManagerException e) {
                        SilverTrace.warn("alertUserPeas", "AlertUserPeasSessionController.prepareNotification()", "root.EX_ADD_USERS_FAILED", e);
                    }
                }
            }
            params.sMessage = metaData.getContent(language);
            params.sLanguage = language;
            params.nNotificationResourceData = metaData.getNotificationResourceData(language);
            List<String> userIds = this.getUserIds(language, usersLanguage);
            allUserIds.removeAll(userIds);
            SilverTrace.info("notificationManager", "NotificationSender.notifyUser()", "root.MSG_GEN_PARAM_VALUE", "allUserIds apres remove= " + allUserIds);
            this.notificationManager.notifyUsers(params, userIds.toArray(new String[userIds.size()]));
        }
        this.notificationManager.notifyUsers(params, allUserIds.toArray(new String[allUserIds.size()]));
        if (this.isNotificationManual(metaData)) {
            this.saveNotification(metaData, usersSet);
        }
        SilverTrace.info("notificationManager", "NotificationSender.notifyUser()", "root.MSG_GEN_EXIT_METHOD");
    }

    private Set<UserRecipient> getUserSet(NotificationMetaData metaData, ResourceLocator settings) throws NotificationManagerException {
        HashSet<UserRecipient> usersSet = new HashSet<UserRecipient>();
        Collection<UserRecipient> userRecipients = metaData.getUserRecipients();
        Collection<GroupRecipient> groupRecipients = metaData.getGroupRecipients();
        usersSet.addAll(userRecipients);
        for (GroupRecipient group : groupRecipients) {
            if (this.displayGroup(settings, group.getGroupId())) continue;
            usersSet.addAll(new NotificationManager(null).getUsersFromGroup(group.getGroupId()));
        }
        usersSet.removeAll(metaData.getUserRecipientsToExclude());
        return usersSet;
    }

    private boolean displayGroup(ResourceLocator settings, String groupId) {
        String threshold = settings.getString("notif.receiver.displayUser.threshold");
        OrganisationController orgaController = OrganisationControllerFactory.getOrganisationController();
        Group group = orgaController.getGroup(groupId);
        int nbUsers = group.getNbUsers();
        boolean res1 = settings.getBoolean("notif.receiver.displayGroup", false);
        boolean res2 = StringUtil.isDefined(threshold);
        boolean res3 = StringUtil.isInteger(threshold);
        boolean res4 = nbUsers > Integer.parseInt(threshold);
        boolean result = res1 || res2 && res3 && res4;
        return result;
    }

    private Set<GroupRecipient> getGroupSet(NotificationMetaData metaData, ResourceLocator settings) {
        HashSet<GroupRecipient> groupsSet = new HashSet<GroupRecipient>();
        Collection<GroupRecipient> groupRecipients = metaData.getGroupRecipients();
        for (GroupRecipient group : groupRecipients) {
            if (!this.displayGroup(settings, group.getGroupId())) continue;
            groupsSet.add(group);
        }
        return groupsSet;
    }

    private String addReceiverUsers(Set<UserRecipient> usersSet) {
        OrganisationController orgaController = OrganisationControllerFactory.getOrganisationController();
        StringBuilder users = new StringBuilder();
        if (settings.getBoolean("addReceiversInBody", false)) {
            boolean first = true;
            for (UserRecipient anUsersSet : usersSet) {
                if (!first) {
                    users.append(", ");
                }
                users.append(orgaController.getUserDetail(anUsersSet.getUserId()).getDisplayedName());
                first = false;
            }
        }
        return users.toString();
    }

    private String addReceiverGroups(Set<GroupRecipient> groupsSet) {
        OrganisationController orgaController = OrganisationControllerFactory.getOrganisationController();
        StringBuilder groups = new StringBuilder();
        if (settings.getBoolean("addReceiversInBody", false)) {
            boolean first = true;
            for (GroupRecipient aGroupsSet : groupsSet) {
                if (!first) {
                    groups.append(", ");
                }
                groups.append(orgaController.getGroup(aGroupsSet.getGroupId()).getName());
                first = false;
            }
        }
        return groups.toString();
    }

    protected void manageManualNotification(Set<UserRecipient> usersSet, Set<GroupRecipient> groupsSet, Set<String> languages, NotificationMetaData metaData, OrganisationController orgaController) throws NotificationManagerException {
        if (this.isNotificationManual(metaData) && settings.getBoolean("addReceiversInBody", false)) {
            for (String language : languages) {
                String newContent = this.addReceiversInContent(usersSet, groupsSet, metaData.getContent(language), language, orgaController);
                metaData.setContent(newContent, language);
            }
        }
    }

    private String addReceiversInContent(Set<UserRecipient> usersSet, Set<GroupRecipient> groupsSet, String content, String language, OrganisationController orgaController) {
        ResourceLocator m_Multilang = new ResourceLocator("com.stratelia.silverpeas.notificationserver.channel.silvermail.multilang.silvermail", language);
        StringBuilder listReceivers = new StringBuilder(500);
        listReceivers.append(content);
        boolean first = true;
        for (UserRecipient anUsersSet : usersSet) {
            if (first) {
                listReceivers.append('\n');
                listReceivers.append(m_Multilang.getString("NameOfReceivers"));
            } else {
                listReceivers.append(", ");
            }
            listReceivers.append(orgaController.getUserDetail(anUsersSet.getUserId()).getDisplayedName());
            first = false;
        }
        first = true;
        for (GroupRecipient aGroupsSet : groupsSet) {
            if (first) {
                listReceivers.append('\n');
                listReceivers.append(m_Multilang.getString("NameOfGroupReceivers"));
            } else {
                listReceivers.append(", ");
            }
            listReceivers.append(orgaController.getGroup(aGroupsSet.getGroupId()).getName());
            first = false;
        }
        return listReceivers.toString();
    }

    private void saveNotification(NotificationMetaData metaData, Set<UserRecipient> usersSet) throws NotificationManagerException {
        this.getNotificationInterface().saveNotifUser(metaData, usersSet);
    }

    private SendedNotificationInterface getNotificationInterface() throws NotificationManagerException {
        SendedNotificationInterfaceImpl notificationInterface = null;
        try {
            notificationInterface = new SendedNotificationInterfaceImpl();
        }
        catch (Exception e) {
            throw new NotificationManagerException("NotificationSender.getNotificationInterface()", 4, "root.EX_CANT_GET_REMOTE_OBJECT", e);
        }
        return notificationInterface;
    }

    private List<String> getUserIds(String lang, Map<String, String> usersLanguage) {
        ArrayList<String> userIds = new ArrayList<String>(usersLanguage.keySet());
        Iterator<String> languages = usersLanguage.values().iterator();
        ArrayList<String> result = new ArrayList<String>();
        int u = 0;
        while (languages.hasNext()) {
            String language = languages.next();
            SilverTrace.debug("notificationManager", "NotificationSender.getUserIds()", "root.MSG_GEN_PARAM_VALUE", "language = " + language);
            if (lang.equalsIgnoreCase(language)) {
                result.add((String)userIds.get(u));
            }
            ++u;
        }
        SilverTrace.info("notificationManager", "NotificationSender.getUserIds()", "root.MSG_GEN_EXIT_METHOD", result.size() + " users for language '" + lang + "' ");
        return result;
    }

    private NotificationParameters getNotificationParameters(int aMediaType, NotificationMetaData metaData) {
        NotificationParameters params = new NotificationParameters();
        params.iMessagePriority = metaData.getMessageType();
        params.dDate = metaData.getDate();
        params.sTitle = metaData.getTitle();
        params.sMessage = metaData.getContent();
        params.sSource = metaData.getSource();
        params.sURL = metaData.getLink();
        params.sSessionId = metaData.getSessionId();
        params.sOriginalExtraMessage = metaData.getOriginalExtraMessage();
        params.bSendImmediately = metaData.isSendImmediately();
        params.iComponentInstance = this.instanceId != -1 ? this.instanceId : NotificationSender.extractLastNumber(metaData.getComponentId());
        params.iMediaType = aMediaType;
        params.bAnswerAllowed = metaData.isAnswerAllowed();
        String sender = metaData.getSender();
        if (aMediaType == -10 || aMediaType == -15) {
            if (metaData.isAnswerAllowed() && StringUtil.isDefined(sender)) {
                params.iFromUserId = Integer.parseInt(metaData.getSender());
            }
        } else if (StringUtil.isInteger(sender)) {
            SilverTrace.info("notificationManager", "NotificationSender.getNotificationParameters()", "root.MSG_GEN_PARAM_VALUE", metaData.getSender());
            params.iFromUserId = Integer.parseInt(metaData.getSender());
        } else {
            params.iFromUserId = -1;
            params.senderName = sender;
        }
        params.eAction = metaData.getAction();
        return params;
    }

    static int extractLastNumber(String chaine) {
        String s = "";
        if (chaine != null) {
            block3: for (int i = 0; i < chaine.length(); ++i) {
                char car = chaine.charAt(i);
                switch (car) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        s = s + car;
                        continue block3;
                    }
                    default: {
                        s = "";
                    }
                }
            }
        }
        if (s.length() > 0) {
            return Integer.parseInt(s);
        }
        return -1;
    }

    public static String getIdsLineFromIdsArray(String[] asrc) {
        StringBuilder toIds = new StringBuilder("");
        if (asrc != null) {
            for (int i = 0; i < asrc.length; ++i) {
                if (i > 0) {
                    toIds.append('_');
                }
                toIds.append(asrc[i]);
            }
        }
        return toIds.toString();
    }

    public static String getIdsLineFromUserArray(UserDetail[] users) {
        StringBuilder toIds = new StringBuilder("");
        if (users != null) {
            for (int i = 0; i < users.length; ++i) {
                if (i > 0) {
                    toIds.append('_');
                }
                toIds.append(users[i].getId());
            }
        }
        return toIds.toString();
    }

    public static String getIdsLineFromGroupArray(Group[] groups) {
        StringBuilder toIds = new StringBuilder("");
        if (groups != null) {
            for (int i = 0; i < groups.length; ++i) {
                if (i > 0) {
                    toIds.append('_');
                }
                toIds.append(groups[i].getId());
            }
        }
        return toIds.toString();
    }

    public static String[] getIdsArrayFromIdsLine(String src) {
        if (src == null) {
            return new String[0];
        }
        StringTokenizer strTok = new StringTokenizer(src, "_");
        int nbElmt = strTok.countTokens();
        String[] valret = new String[nbElmt];
        for (int i = 0; i < nbElmt; ++i) {
            valret[i] = strTok.nextToken();
        }
        return valret;
    }
}

