/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.notificationManager.model;

import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.notificationManager.model.SendedNotificationDetail;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.silverpeas.util.LongText;
import com.stratelia.webactiv.util.DBUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class SendedNotificationDAO {
    private static final String COLUMNS = "notifId, userId, messageType, notifDate, title, link, sessionId, componentId, body";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int saveNotifUser(Connection con, SendedNotificationDetail notif) {
        PreparedStatement prepStmt = null;
        int notifId = 0;
        try {
            String query = "insert into ST_NotifSended (notifId, userId, messageType, notifDate, title, link, sessionId, componentId, body) values (?,?,?,?,?,?,?,?,?)";
            prepStmt = con.prepareStatement(query);
            notifId = DBUtil.getNextId("ST_NotifSended", "notifId");
            prepStmt.setInt(1, notifId);
            prepStmt.setInt(2, notif.getUserId());
            prepStmt.setInt(3, notif.getMessageType());
            Date notifDate = notif.getNotifDate();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(notifDate);
            prepStmt.setString(4, Long.toString(calendar.getTime().getTime()));
            prepStmt.setString(5, notif.getTitle());
            prepStmt.setString(6, notif.getLink());
            prepStmt.setString(7, notif.getSessionId());
            prepStmt.setString(8, notif.getComponentId());
            int bodyId = LongText.addLongText(notif.getBody());
            prepStmt.setInt(9, bodyId);
            prepStmt.executeUpdate();
            for (String userId : notif.getUsers()) {
                SendedNotificationDAO.saveReceiver(con, notifId, Integer.parseInt(userId));
            }
        }
        catch (Exception e) {
            int n;
            try {
                n = 0;
            }
            catch (Throwable throwable) {
                DBUtil.close(prepStmt);
                throw throwable;
            }
            DBUtil.close(prepStmt);
            return n;
        }
        DBUtil.close(prepStmt);
        return notifId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SendedNotificationDetail> getAllNotifByUser(Connection con, String userId) throws SQLException {
        ArrayList<SendedNotificationDetail> notifs = new ArrayList<SendedNotificationDetail>();
        String query = "select notifId, userId, messageType, notifDate, title, link, sessionId, componentId, body from ST_NotifSended where userId = ? order by notifDate desc";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement(query);
            prepStmt.setInt(1, Integer.parseInt(userId));
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                SendedNotificationDetail notif = SendedNotificationDAO.recupNotif(rs);
                notifs.add(notif);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, prepStmt);
            throw throwable;
        }
        DBUtil.close(rs, prepStmt);
        return notifs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getReceivers(Connection con, int notifId) throws SQLException {
        ArrayList<String> users = new ArrayList<String>();
        String query = "select userId from ST_NotifSendedReceiver where notifId = ?";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement(query);
            prepStmt.setInt(1, notifId);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                users.add(Integer.toString(rs.getInt("userId")));
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, prepStmt);
            throw throwable;
        }
        DBUtil.close(rs, prepStmt);
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SendedNotificationDetail getNotif(Connection con, int notifId) throws SQLException {
        SendedNotificationDetail notif = new SendedNotificationDetail();
        String query = "select notifId, userId, messageType, notifDate, title, link, sessionId, componentId, body from ST_NotifSended where notifId = ?";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement(query);
            prepStmt.setInt(1, notifId);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                notif = SendedNotificationDAO.recupNotif(rs);
            }
            notif.setUsers(SendedNotificationDAO.getReceivers(con, notifId));
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, prepStmt);
            throw throwable;
        }
        DBUtil.close(rs, prepStmt);
        return notif;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteNotif(Connection con, int notifId) throws SQLException {
        PreparedStatement prepStmt = null;
        try {
            SendedNotificationDAO.deleteReceivers(con, notifId);
            String query = "delete from ST_NotifSended where notifId = ? ";
            prepStmt = con.prepareStatement(query);
            prepStmt.setInt(1, notifId);
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close(prepStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteReceivers(Connection con, int notifId) throws SQLException {
        PreparedStatement prepStmt = null;
        try {
            String query = "delete from ST_NotifSendedReceiver where notifId = ? ";
            prepStmt = con.prepareStatement(query);
            prepStmt.setInt(1, notifId);
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close(prepStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveReceiver(Connection con, int notifId, int userId) throws SQLException {
        PreparedStatement prepStmt = null;
        try {
            String query = "insert into ST_NotifSendedReceiver (notifId, userId) values (?,?) ";
            prepStmt = con.prepareStatement(query);
            prepStmt.setInt(1, notifId);
            prepStmt.setInt(2, userId);
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close(prepStmt);
    }

    public static void deleteNotifByUser(Connection con, String userId) throws SQLException {
        List<SendedNotificationDetail> notifs = SendedNotificationDAO.getAllNotifByUser(con, userId);
        for (SendedNotificationDetail notif : notifs) {
            SendedNotificationDAO.deleteNotif(con, notif.getNotifId());
        }
    }

    protected static SendedNotificationDetail recupNotif(ResultSet rs) throws SQLException {
        SendedNotificationDetail notif = new SendedNotificationDetail();
        notif.setNotifId(rs.getInt("notifId"));
        notif.setUserId(rs.getInt("userId"));
        notif.setMessageType(rs.getInt("messageType"));
        String date = rs.getString("notifDate");
        if (StringUtil.isDefined(date)) {
            try {
                notif.setNotifDate(new Date(Long.parseLong(date)));
            }
            catch (NumberFormatException e) {
                notif.setNotifDate(new Date());
            }
        } else {
            notif.setNotifDate(new Date());
        }
        notif.setTitle(rs.getString("title"));
        notif.setLink(rs.getString("link"));
        notif.setSessionId(rs.getString("sessionId"));
        notif.setComponentId(rs.getString("componentId"));
        String body = "";
        try {
            int longTextId = -1;
            longTextId = rs.getInt("body");
            body = LongText.getLongText(longTextId);
        }
        catch (Exception e) {
            SilverTrace.debug("popup", "POPUPListener.recupNotif()", "PB converting body id to LongText", "Message Body = " + rs.getInt("body"));
        }
        notif.setBody(body);
        return notif;
    }
}

