/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.notificationManager.model;

import com.silverpeas.SilverpeasServiceProvider;
import com.stratelia.silverpeas.notificationManager.NotificationManagerException;
import com.stratelia.silverpeas.notificationManager.NotificationMetaData;
import com.stratelia.silverpeas.notificationManager.UserRecipient;
import com.stratelia.silverpeas.notificationManager.model.SendedNotificationDAO;
import com.stratelia.silverpeas.notificationManager.model.SendedNotificationDetail;
import com.stratelia.silverpeas.notificationManager.model.SendedNotificationInterface;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.JNDINames;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SendedNotificationInterfaceImpl
implements SendedNotificationInterface {
    @Override
    public void saveNotifUser(NotificationMetaData metaData, Set<UserRecipient> usersSet) throws NotificationManagerException {
        Connection con = this.initCon();
        try {
            ArrayList<String> users = new ArrayList<String>();
            for (UserRecipient user : usersSet) {
                users.add(user.getUserId());
            }
            String language = SilverpeasServiceProvider.getPersonalizationService().getUserSettings(metaData.getSender()).getLanguage();
            SendedNotificationDetail notif = new SendedNotificationDetail(Integer.parseInt(metaData.getSender()), metaData.getMessageType(), metaData.getDate(), metaData.getTitle(language), metaData.getSource(), metaData.getLink(), metaData.getSessionId(), metaData.getComponentId(), metaData.getContent(language));
            notif.setUsers(users);
            int id = SendedNotificationDAO.saveNotifUser(con, notif);
            notif.setNotifId(id);
        }
        catch (Exception e) {
            throw new NotificationManagerException("NotificationInterface.saveNotifUser()", 4, "root.MSG_GET_NOTIFICATION", e);
        }
        finally {
            DBUtil.close(con);
        }
    }

    @Override
    public List<SendedNotificationDetail> getAllNotifByUser(String userId) throws NotificationManagerException {
        Connection con = this.initCon();
        try {
            List<SendedNotificationDetail> list = SendedNotificationDAO.getAllNotifByUser(con, userId);
            return list;
        }
        catch (Exception e) {
            throw new NotificationManagerException("NotificationInterface.getAllNotifByUser()", 4, "root.MSG_GET_NOTIFICATION", e);
        }
        finally {
            DBUtil.close(con);
        }
    }

    @Override
    public SendedNotificationDetail getNotification(int notifId) throws NotificationManagerException {
        Connection con = this.initCon();
        try {
            SendedNotificationDetail sendedNotificationDetail = SendedNotificationDAO.getNotif(con, notifId);
            return sendedNotificationDetail;
        }
        catch (Exception e) {
            throw new NotificationManagerException("NotificationInterface.getNotification()", 4, "root.MSG_GET_NOTIFICATION", e);
        }
        finally {
            DBUtil.close(con);
        }
    }

    @Override
    public void deleteNotif(int notifId) throws NotificationManagerException {
        Connection con = this.initCon();
        try {
            SendedNotificationDAO.deleteNotif(con, notifId);
        }
        catch (Exception e) {
            throw new NotificationManagerException("NotificationInterface.deleteNotif()", 4, "root.MSG_GET_NOTIFICATION", e);
        }
        finally {
            DBUtil.close(con);
        }
    }

    @Override
    public void deleteNotifByUser(String userId) throws NotificationManagerException {
        Connection con = this.initCon();
        try {
            SendedNotificationDAO.deleteNotifByUser(con, userId);
        }
        catch (Exception e) {
            throw new NotificationManagerException("NotificationInterface.deleteNotifByUser()", 4, "root.MSG_GET_NOTIFICATION", e);
        }
        finally {
            DBUtil.close(con);
        }
    }

    private Connection initCon() throws NotificationManagerException {
        try {
            return DBUtil.makeConnection(JNDINames.DATABASE_DATASOURCE);
        }
        catch (Exception e) {
            throw new NotificationManagerException("NotificationInterfaceImpl.initCon()", 4, "root.EX_CONNECTION_OPEN_FAILED", e);
        }
    }
}

