/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.notificationserver;

import com.stratelia.silverpeas.notificationserver.NotificationData;
import com.stratelia.silverpeas.notificationserver.NotificationServerException;
import com.stratelia.silverpeas.notificationserver.xml.NotifyContentHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.silverpeas.util.Charsets;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NotificationServerUtil {
    private static final SAXParserFactory parserFactory = SAXParserFactory.newInstance();

    public static String convertNotificationDataToXML(NotificationData p_Data) {
        StringBuilder xml = new StringBuilder();
        if (p_Data != null) {
            xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
            xml.append("<NOTIFY>");
            xml.append("\t<LOGIN>");
            xml.append("\t\t<USER><![CDATA[");
            xml.append(p_Data.getLoginUser());
            xml.append("]]></USER>");
            xml.append("\t\t<PASSWORD><![CDATA[");
            xml.append(p_Data.getLoginPassword());
            xml.append("]]></PASSWORD>");
            xml.append("\t</LOGIN>");
            xml.append("\t<MESSAGE><![CDATA[");
            xml.append(p_Data.getMessage());
            xml.append("]]></MESSAGE>");
            xml.append("\t<SENDER>");
            xml.append("\t\t<ID><![CDATA[");
            xml.append(p_Data.getSenderId());
            xml.append("]]></ID>");
            xml.append("\t\t<NAME><![CDATA[");
            xml.append(p_Data.getSenderName());
            xml.append("]]></NAME>");
            xml.append("\t\t<ANSWERALLOWED>");
            xml.append(p_Data.isAnswerAllowed());
            xml.append("</ANSWERALLOWED>");
            xml.append("\t</SENDER>");
            xml.append("\t<COMMENT><![CDATA[");
            xml.append(p_Data.getComment());
            xml.append("]]></COMMENT>");
            xml.append("\t<TARGET CHANNEL=\"");
            xml.append(p_Data.getTargetChannel());
            xml.append("\">");
            xml.append("\t\t<NAME><![CDATA[");
            xml.append(p_Data.getTargetName());
            xml.append("]]></NAME>");
            xml.append("\t\t<RECEIPT><![CDATA[");
            xml.append(p_Data.getTargetReceipt());
            xml.append("]]></RECEIPT>");
            xml.append("\t\t<PARAM><![CDATA[");
            xml.append(NotificationServerUtil.packKeyValues(p_Data.getTargetParam()));
            xml.append("]]></PARAM>");
            xml.append("\t</TARGET>");
            xml.append("\t<PRIORITY SPEED=\"");
            xml.append(p_Data.getPrioritySpeed());
            xml.append("\"/>");
            xml.append("\t<REPORT>");
            xml.append("\t</REPORT>");
            xml.append("</NOTIFY>");
        }
        return xml.toString();
    }

    public static NotificationData convertXMLToNotificationData(String p_XML) throws NotificationServerException {
        NotificationData data = new NotificationData();
        ByteArrayInputStream xml = new ByteArrayInputStream(p_XML.getBytes(Charsets.UTF_8));
        try {
            SAXParser parser = parserFactory.newSAXParser();
            NotifyContentHandler handler = new NotifyContentHandler(data, parser.getXMLReader());
            parser.parse((InputStream)xml, (DefaultHandler)handler);
        }
        catch (SAXException e) {
            throw new NotificationServerException("NotificationDataXML()", 4, "notificationServer.EX_ERROR_IN_XML_PARSING", e);
        }
        catch (IOException e) {
            throw new NotificationServerException("NotificationDataXML()", 4, "notificationServer.EX_ERROR_IN_XML_PARSING", e);
        }
        catch (ParserConfigurationException e) {
            throw new NotificationServerException("NotificationDataXML()", 4, "notificationServer.EX_ERROR_IN_XML_PARSING", e);
        }
        return data;
    }

    public static Map<String, Object> unpackKeyValues(String keyvaluestring) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        StringBuffer key = new StringBuffer();
        StringBuffer value = new StringBuffer();
        if (keyvaluestring != null) {
            StringBuffer sb = key;
            for (int i = 0; i < keyvaluestring.length(); ++i) {
                char c = keyvaluestring.charAt(i);
                if (c == ';') {
                    if (i + 1 < keyvaluestring.length() && keyvaluestring.charAt(i + 1) == ';') {
                        sb.append(c);
                        ++i;
                        continue;
                    }
                    String strValue = value.toString();
                    if (strValue.startsWith("#DATE#")) {
                        strValue = strValue.substring(6, strValue.length());
                        result.put(key.toString(), new Date(Long.valueOf(strValue)));
                    } else {
                        result.put(key.toString(), strValue);
                    }
                    key.setLength(0);
                    value.setLength(0);
                    sb = key;
                    continue;
                }
                if (c == '=') {
                    if (i + 1 < keyvaluestring.length() && keyvaluestring.charAt(i + 1) == '=') {
                        sb.append(c);
                        ++i;
                        continue;
                    }
                    sb = value;
                    continue;
                }
                sb.append(c);
            }
            String strValue = value.toString();
            if (strValue.startsWith("#DATE#")) {
                strValue = strValue.substring(6);
                result.put(key.toString(), new Date(Long.valueOf(strValue)));
            } else {
                result.put(key.toString(), strValue);
            }
        }
        return result;
    }

    protected static String doubleSeparators(String theValue) {
        if (theValue == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(theValue.length() + 5);
        char[] chars = theValue.toCharArray();
        block4: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '=': {
                    sb.append("==");
                    continue block4;
                }
                case ';': {
                    sb.append(";;");
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String packKeyValues(Map<String, Object> keyValues) {
        StringBuilder sb = new StringBuilder();
        boolean bNotTheFirst = false;
        if (keyValues != null) {
            Set<String> theKeys = keyValues.keySet();
            for (String theKey : theKeys) {
                if (bNotTheFirst) {
                    sb.append(';');
                }
                String keyValue = "";
                boolean success = true;
                try {
                    keyValue = (String)keyValues.get(theKey);
                }
                catch (ClassCastException cce) {
                    success = false;
                }
                if (!success) {
                    try {
                        Date date = (Date)keyValues.get(theKey);
                        keyValue = "#DATE#" + String.valueOf(date.getTime());
                        success = true;
                    }
                    catch (ClassCastException cce) {
                        success = false;
                    }
                }
                if (!success) continue;
                sb.append(NotificationServerUtil.doubleSeparators(theKey)).append('=').append(NotificationServerUtil.doubleSeparators(keyValue));
                bNotTheFirst = true;
            }
        }
        return sb.toString();
    }

    static {
        parserFactory.setNamespaceAware(false);
        parserFactory.setValidating(false);
    }
}

