/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.peasCore;

import com.silverpeas.SilverpeasContent;
import com.silverpeas.SilverpeasToolContent;
import com.silverpeas.util.ComponentHelper;
import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.AdminReference;
import com.stratelia.webactiv.util.GeneralPropertiesManager;
import com.stratelia.webactiv.util.ResourceLocator;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class URLManager {
    public static final String CMP_ADMIN = "admin";
    public static final String CMP_AGENDA = "agenda";
    public static final String CMP_ATTACHMENT = "attachment";
    public static final String CMP_FORMDESIGNER = "formDesigner";
    public static final String CMP_SILVERMAIL = "SILVERMAIL";
    public static final String CMP_POPUP = "POPUP";
    public static final String CMP_PERSONALIZATION = "personalization";
    public static final String CMP_FILESERVER = "FileServer";
    public static final String CMP_PORTLET = "portlet";
    public static final String CMP_TODO = "todo";
    public static final String CMP_TREEVIEW = "treeview";
    public static final String CMP_WORKFLOW = "workflow";
    public static final String CMP_WYSIWYG = "wysiwyg";
    public static final String CMP_SCHEDULE_EVENT = "scheduleEvent";
    public static final String CMP_CLIPBOARD = "clipboard";
    public static final String CMP_NOTIFICATIONUSER = "notificationUser";
    public static final String CMP_COMMUNICATIONUSER = "communicationUser";
    public static final String CMP_SEARCHENGINE = "searchEngine";
    public static final String CMP_WEBLOADERPEAS = "webLoaderPeas";
    public static final String CMP_JOBMANAGERPEAS = "jobManagerPeas";
    public static final String CMP_JOBDOMAINPEAS = "jobDomainPeas";
    public static final String CMP_JOBSTARTPAGEPEAS = "jobStartPagePeas";
    public static final String CMP_JOBORGANIZATIONPEAS = "jobOrganizationPeas";
    public static final String CMP_JOBSEARCHPEAS = "jobSearchPeas";
    public static final String CMP_JOBREPORTPEAS = "jobReportPeas";
    public static final String CMP_JOBTOOLSPEAS = "jobToolsPeas";
    public static final String CMP_SELECTIONPEAS = "selectionPeas";
    public static final String CMP_ALERTUSERPEAS = "alertUserPeas";
    public static final String CMP_GENERICPANELPEAS = "genericPanelPeas";
    public static final String CMP_SILVERSTATISTICSPEAS = "silverStatisticsPeas";
    public static final String CMP_PDC = "pdc";
    public static final String CMP_THESAURUS = "thesaurus";
    public static final String CMP_INTERESTCENTERPEAS = "interestCenterPeas";
    public static final String CMP_MYLINKSPEAS = "myLinksPeas";
    public static final String CMP_PDCSUBSCRIPTION = "pdcSubscriptionPeas";
    public static final String CMP_VERSIONINGPEAS = "versioningPeas";
    public static final String CMP_FILESHARING = "fileSharing";
    public static final String CMP_WEBCONNECTIONS = "webConnections";
    public static final String CMP_EXPERTLOCATORPEAS = "expertLocatorPeas";
    public static final String CMP_WHITEPAGESPEAS = "whitePagesPeas";
    public static final String CMP_VSICPUZZLE = "vsicPuzzle";
    public static final String CMP_INFOLETTER = "infoLetter";
    public static final String CMP_JOBBACKUP = "jobBackup";
    public static final String CMP_TEMPLATEDESIGNER = "templateDesigner";
    public static final String CMP_MYPROFILE = "MyProfile";
    public static final int URL_SPACE = 0;
    public static final int URL_COMPONENT = 1;
    public static final int URL_PUBLI = 2;
    public static final int URL_TOPIC = 3;
    public static final int URL_FILE = 4;
    public static final int URL_SURVEY = 5;
    public static final int URL_QUESTION = 6;
    public static final int URL_MESSAGE = 7;
    public static final int URL_DOCUMENT = 8;
    public static final int URL_VERSION = 9;
    private static final String applicationURL = GeneralPropertiesManager.getString("ApplicationURL", "/silverpeas");
    static Properties specialsURL = null;
    static String httpMode = null;
    static boolean universalLinksUsed = false;

    public static String getURL(String sComponentName, String sSpace, String sComponentId) {
        String specialString;
        String sureCompName = sComponentName;
        if (!StringUtil.isDefined(sComponentName) && !StringUtil.isDefined(sComponentId)) {
            return "";
        }
        if (!StringUtil.isDefined(sureCompName)) {
            sureCompName = URLManager.getComponentNameFromComponentId(sComponentId);
        }
        if (StringUtil.isDefined(specialString = specialsURL.getProperty(sureCompName))) {
            return specialString;
        }
        return URLManager.buildStandardURL(sureCompName, sComponentId);
    }

    @Deprecated
    public static String getURL(String sComponentName) {
        return URLManager.getURL(sComponentName, null, null);
    }

    public static String getURL(String sSpace, String sComponentId) {
        return URLManager.getURL(null, null, sComponentId);
    }

    public static String getNewComponentURL(String spaceId, String componentId) {
        String sureCompName = URLManager.getComponentNameFromComponentId(componentId);
        return URLManager.buildStandardURL(sureCompName, componentId);
    }

    private static String buildStandardURL(String componentName, String sComponentId) {
        return '/' + AdminReference.getAdminService().getRequestRouter(componentName) + '/' + sComponentId + '/';
    }

    public static String getComponentNameFromComponentId(String sClientComponentId) {
        return ComponentHelper.getInstance().extractComponentName(sClientComponentId);
    }

    public static String getApplicationURL() {
        return applicationURL;
    }

    public static String getFullApplicationURL(HttpServletRequest request) {
        return URLManager.getServerURL(request) + URLManager.getApplicationURL();
    }

    public static String getServerURL(HttpServletRequest request) {
        String absoluteUrl = "";
        if (request != null) {
            absoluteUrl = request.getScheme() + "://" + request.getServerName();
            if (request.getServerPort() != 80) {
                absoluteUrl = absoluteUrl + ":" + request.getServerPort();
            }
        }
        return GeneralPropertiesManager.getString("httpServerBase", absoluteUrl);
    }

    public static String getHttpMode() {
        return httpMode;
    }

    public static boolean displayUniversalLinks() {
        return universalLinksUsed;
    }

    public static String getSimpleURL(int type, String id, String componentId) {
        return URLManager.getSimpleURL(type, id, componentId, true);
    }

    public static String getSimpleURL(int type, String id, String componentId, boolean appendContext, String forumId) {
        String url = "";
        if (appendContext) {
            url = URLManager.getApplicationURL();
        }
        switch (type) {
            case 7: {
                url = url + "/ForumsMessage/" + id + "?ForumId=" + forumId;
            }
        }
        return url;
    }

    public static String getSimpleURL(int type, String id, String componentId, boolean appendContext) {
        String url = "";
        if (appendContext) {
            url = URLManager.getApplicationURL();
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        switch (type) {
            case 0: {
                if (!id.startsWith("WA")) {
                    id = "WA" + id;
                }
                url = url + "/Space/" + id;
                break;
            }
            case 1: {
                url = url + "/Component/" + id;
                break;
            }
            case 2: {
                url = url + "/Publication/" + id;
                if (!StringUtil.isDefined(componentId)) break;
                url = url + "?ComponentId=" + componentId;
                break;
            }
            case 3: {
                url = url + "/Topic/" + id + "?ComponentId=" + componentId;
                break;
            }
            case 4: {
                url = url + "/File/" + id;
                break;
            }
            case 5: {
                url = url + "/Survey/" + id;
                break;
            }
            case 6: {
                url = url + "/Question/" + id;
                break;
            }
            case 8: {
                url = url + "/Document/" + id;
                break;
            }
            case 9: {
                url = url + "/Version/" + id;
            }
        }
        return url;
    }

    public static String getSimpleURL(int type, String id) {
        return URLManager.getSimpleURL(type, id, true);
    }

    public static String getSimpleURL(int type, String id, boolean appendContext) {
        return URLManager.getSimpleURL(type, id, "", appendContext);
    }

    public static String getSearchResultURL(SilverpeasContent content) {
        String url = null;
        if (content instanceof SilverpeasToolContent) {
            url = ((SilverpeasToolContent)content).getURL();
        }
        if (!StringUtil.isDefined(url)) {
            url = URLManager.getURL(null, null, content.getComponentInstanceId()) + "searchResult?Type=" + content.getContributionType() + "&Id=" + content.getId();
        }
        return url;
    }

    static {
        ResourceLocator resources = new ResourceLocator("com.stratelia.silverpeas.peasCore.URLManager", "");
        specialsURL = resources.getProperties();
        httpMode = resources.getString("httpMode");
        universalLinksUsed = resources.getBoolean("displayUniversalLinks", false);
    }
}

