/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.selection;

import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.selection.SelectionExtraParams;
import com.stratelia.silverpeas.util.PairObject;
import java.util.Collection;

public final class Selection {
    public static final String TYPE_USERS_GROUPS = "UsersGroups";
    public static final String TYPE_SPACES_COMPONENTS = "SpacesComponents";
    public static final String TYPE_JDBC_CONNECTOR = "JdbcConnector";
    public static final String FIRST_PAGE_DEFAULT = "Default";
    public static final String FIRST_PAGE_CART = "DisplayCart";
    public static final String FIRST_PAGE_SEARCH_ELEMENT = "DisplaySearchElement";
    public static final String FIRST_PAGE_SEARCH_SET = "DisplaySearchSet";
    public static final String FIRST_PAGE_BROWSE = "DisplayBrowse";
    public static final String USER_SELECTION_PANEL_PATH = "/selection/jsp/userpanel.jsp";
    protected String goBackURL;
    protected String cancelURL;
    protected String htmlFormName;
    protected String htmlFormElementName;
    protected String htmlFormElementId;
    protected String firstPage;
    protected String[] selectedSets;
    protected String[] selectedElements;
    protected boolean popupMode;
    protected boolean multiSelect;
    protected boolean setSelectable;
    protected boolean elementSelectable;
    protected String hostSpaceName;
    protected PairObject hostComponentName;
    protected PairObject[] hostPath;
    protected SelectionExtraParams extraParams;

    public Selection() {
        this.resetAll();
    }

    public void resetAll() {
        this.goBackURL = "";
        this.cancelURL = "";
        this.htmlFormName = "";
        this.htmlFormElementId = "";
        this.htmlFormElementName = "";
        this.firstPage = FIRST_PAGE_DEFAULT;
        this.selectedSets = new String[0];
        this.selectedElements = new String[0];
        this.popupMode = false;
        this.multiSelect = true;
        this.setSelectable = true;
        this.elementSelectable = true;
        this.hostSpaceName = "";
        this.hostComponentName = new PairObject("", "");
        this.hostPath = new PairObject[0];
        this.extraParams = null;
    }

    public static String getSelectionURL(String selectionType) {
        if (TYPE_USERS_GROUPS.equals(selectionType)) {
            return USER_SELECTION_PANEL_PATH;
        }
        return "/RselectionPeas/jsp/Main?SelectionType=" + selectionType;
    }

    public void setHostSpaceName(String hostSpaceName) {
        this.hostSpaceName = hostSpaceName != null ? hostSpaceName : "";
    }

    public String getHostSpaceName() {
        return this.hostSpaceName;
    }

    public void setHostComponentName(PairObject hostComponentName) {
        this.hostComponentName = hostComponentName != null ? hostComponentName : new PairObject("", "");
    }

    public PairObject getHostComponentName() {
        return this.hostComponentName;
    }

    public void setHostPath(PairObject[] hostPath) {
        this.hostPath = hostPath != null ? (PairObject[])hostPath.clone() : new PairObject[0];
    }

    public PairObject[] getHostPath() {
        return this.hostPath;
    }

    public String getCancelURL() {
        return this.cancelURL;
    }

    public void setCancelURL(String cancelURL) {
        this.cancelURL = cancelURL != null ? cancelURL : "";
    }

    public String getGoBackURL() {
        return this.goBackURL;
    }

    public void setGoBackURL(String goBackURL) {
        this.goBackURL = goBackURL;
    }

    public String getFirstPage() {
        return this.firstPage;
    }

    public void setFirstPage(String firstPage) {
        this.firstPage = firstPage;
    }

    public boolean isPopupMode() {
        return this.popupMode;
    }

    public void setPopupMode(boolean popupMode) {
        this.popupMode = popupMode;
    }

    public boolean isHotSetting() {
        return StringUtil.isDefined(this.htmlFormName);
    }

    public boolean isMultiSelect() {
        return this.multiSelect;
    }

    public void setMultiSelect(boolean multiSelect) {
        this.multiSelect = multiSelect;
    }

    public boolean isSetSelectable() {
        return this.setSelectable;
    }

    public void setSetSelectable(boolean setSelectable) {
        this.setSelectable = setSelectable;
    }

    public boolean isElementSelectable() {
        return this.elementSelectable;
    }

    public void setElementSelectable(boolean elementSelectable) {
        this.elementSelectable = elementSelectable;
    }

    public String[] getSelectedElements() {
        return this.selectedElements;
    }

    public void setSelectedElements(String[] selectedElements) {
        this.selectedElements = selectedElements != null ? (String[])selectedElements.clone() : new String[0];
    }

    public void setSelectedElements(Collection<String> selectedElements) {
        if (selectedElements != null) {
            this.setSelectedElements(selectedElements.toArray(new String[selectedElements.size()]));
        } else {
            this.setSelectedElements((String[])null);
        }
    }

    public String getFirstSelectedElement() {
        if (this.selectedElements != null && this.selectedElements.length > 0 && StringUtil.isDefined(this.selectedElements[0])) {
            return this.selectedElements[0];
        }
        return null;
    }

    public String[] getSelectedSets() {
        return this.selectedSets;
    }

    public void setSelectedSets(String[] selectedSets) {
        this.selectedSets = selectedSets != null ? (String[])selectedSets.clone() : new String[0];
    }

    public void setSelectedSets(Collection<String> selectedSets) {
        if (selectedSets != null) {
            this.setSelectedSets(selectedSets.toArray(new String[selectedSets.size()]));
        } else {
            this.setSelectedSets((String[])null);
        }
    }

    public String getFirstSelectedSet() {
        if (this.selectedSets != null && this.selectedSets.length > 0 && StringUtil.isDefined(this.selectedSets[0])) {
            return this.selectedSets[0];
        }
        return null;
    }

    public SelectionExtraParams getExtraParams() {
        return this.extraParams;
    }

    public void setExtraParams(SelectionExtraParams extraParams) {
        this.extraParams = extraParams;
    }

    public String getHtmlFormElementId() {
        return this.htmlFormElementId;
    }

    public void setHtmlFormElementId(String formElementId) {
        this.htmlFormElementId = formElementId;
    }

    public String getHtmlFormElementName() {
        return this.htmlFormElementName;
    }

    public void setHtmlFormElementName(String formElementName) {
        this.htmlFormElementName = formElementName;
    }

    public String getHtmlFormName() {
        return this.htmlFormName;
    }

    public void setHtmlFormName(String formName) {
        this.htmlFormName = formName;
    }
}

