/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv;

import com.silverpeas.util.CollectionUtil;
import com.silverpeas.util.StringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonValue;

public enum SilverpeasRole {
    admin,
    Manager,
    publisher,
    writer,
    user,
    reader,
    supervisor,
    privilegedUser;

    public static EnumSet<SilverpeasRole> READER_ROLES;

    @JsonValue
    public String getName() {
        return this.name();
    }

    public boolean isGreaterThan(SilverpeasRole role) {
        return this.ordinal() < role.ordinal();
    }

    public boolean isGreaterThanOrEquals(SilverpeasRole role) {
        return this.ordinal() <= role.ordinal();
    }

    @JsonCreator
    public static SilverpeasRole from(String name) {
        if (name == null) {
            return null;
        }
        String trimmedName = name.trim();
        try {
            return SilverpeasRole.valueOf(trimmedName);
        }
        catch (Exception e) {
            for (SilverpeasRole role : SilverpeasRole.values()) {
                if (!role.getName().equalsIgnoreCase(trimmedName)) continue;
                return role;
            }
            return null;
        }
    }

    public static boolean exists(String name) {
        return SilverpeasRole.from(name) != null;
    }

    public static Set<SilverpeasRole> listFrom(String roles) {
        return SilverpeasRole.from(StringUtil.isDefined(roles) ? StringUtil.split((String)roles, (String)",") : null);
    }

    public static Set<SilverpeasRole> from(String[] roles) {
        EnumSet<SilverpeasRole> result = EnumSet.noneOf(SilverpeasRole.class);
        if (roles != null) {
            for (String role : roles) {
                SilverpeasRole silverpeasRole = SilverpeasRole.from(role);
                if (silverpeasRole == null) continue;
                result.add(silverpeasRole);
            }
        }
        return result;
    }

    public boolean isInRole(String ... roles) {
        try {
            for (String aRole : roles) {
                if (this != SilverpeasRole.from(aRole)) continue;
                return true;
            }
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
        return false;
    }

    public static String asString(Set<SilverpeasRole> roles) {
        if (roles == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (SilverpeasRole role : roles) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(role.name());
        }
        return sb.toString();
    }

    public static SilverpeasRole getGreaterFrom(SilverpeasRole ... roles) {
        return SilverpeasRole.getGreaterFrom(Arrays.asList(roles));
    }

    public static SilverpeasRole getGreaterFrom(Collection<SilverpeasRole> roles) {
        if (CollectionUtil.isEmpty(roles)) {
            return null;
        }
        EnumSet<SilverpeasRole> givenRoles = roles instanceof EnumSet ? (EnumSet<SilverpeasRole>)roles : EnumSet.copyOf(roles);
        return (SilverpeasRole)((Object)givenRoles.iterator().next());
    }

    static {
        READER_ROLES = EnumSet.of(user, reader);
    }
}

