/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin;

import com.silverpeas.admin.components.Instanciateur;
import com.silverpeas.admin.components.Parameter;
import com.silverpeas.admin.notification.ComponentJsonPatch;
import com.silverpeas.util.i18n.AbstractI18NBean;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.webactiv.beans.admin.ComponentI18N;
import com.stratelia.webactiv.beans.admin.ProfileInst;
import com.stratelia.webactiv.beans.admin.UserDetail;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.silverpeas.notification.jsondiff.Operation;

public class ComponentInst
extends AbstractI18NBean
implements Serializable,
Cloneable,
Comparable<ComponentInst> {
    private static final long serialVersionUID = 1L;
    public static final String STATUS_REMOVED = "R";
    private String id = "";
    private String name = "";
    private String label = "";
    private String description = "";
    private String domainFatherId = "";
    private int order = 0;
    private Date createDate = null;
    private Date updateDate = null;
    private Date removeDate = null;
    private String status = null;
    private String creatorUserId;
    private UserDetail creator;
    private String updaterUserId;
    private UserDetail updater;
    private String removerUserId;
    private UserDetail remover;
    private boolean isPublic = false;
    private boolean isHidden = false;
    private boolean isInheritanceBlocked = false;
    private List<ProfileInst> profiles = new ArrayList<ProfileInst>();
    private List<Parameter> parameters = null;

    @Override
    public int compareTo(ComponentInst o) {
        return this.order - o.getOrderNum();
    }

    public Object clone() {
        ComponentInst ci = new ComponentInst();
        ci.setId(this.id);
        ci.setName(this.name);
        ci.setLabel(this.label);
        ci.setDescription(this.description);
        ci.setDomainFatherId(this.domainFatherId);
        ci.setOrderNum(this.order);
        ci.setPublic(this.isPublic);
        ci.setHidden(this.isHidden);
        ci.setInheritanceBlocked(this.isInheritanceBlocked);
        if (this.profiles == null) {
            ci.profiles = null;
        } else {
            for (ProfileInst profile : this.profiles) {
                ci.addProfileInst((ProfileInst)profile.clone());
            }
        }
        ci.parameters = new ArrayList<Parameter>(this.parameters.size());
        for (Parameter param : this.parameters) {
            ci.parameters.add(param.clone());
        }
        for (String lang : this.getTranslations().keySet()) {
            ComponentI18N translation = (ComponentI18N)this.getTranslation(lang);
            ci.addTranslation(translation);
        }
        return ci;
    }

    protected String[] cloneStringArray(String[] src) {
        if (src == null) {
            return null;
        }
        String[] clonedArray = new String[src.length];
        System.arraycopy(src, 0, clonedArray, 0, src.length);
        return clonedArray;
    }

    public void setId(String sId) {
        this.id = sId;
    }

    public String getId() {
        return this.id;
    }

    public void setName(String sName) {
        this.name = sName;
    }

    public String getName() {
        return this.name;
    }

    public void setLabel(String sLabel) {
        this.label = sLabel;
    }

    public String getLabel() {
        return this.label;
    }

    public void setDescription(String sDescription) {
        this.description = sDescription;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDomainFatherId(String sDomainFatherId) {
        this.domainFatherId = sDomainFatherId;
    }

    public String getDomainFatherId() {
        return this.domainFatherId;
    }

    public void setOrderNum(int iOrderNum) {
        this.order = iOrderNum;
    }

    public int getOrderNum() {
        return this.order;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getRemoveDate() {
        return this.removeDate;
    }

    public void setRemoveDate(Date removeDate) {
        this.removeDate = removeDate;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public String getRemoverUserId() {
        return this.removerUserId;
    }

    public void setRemoverUserId(String removerUserId) {
        this.removerUserId = removerUserId;
    }

    public String getUpdaterUserId() {
        return this.updaterUserId;
    }

    public void setUpdaterUserId(String updaterUserId) {
        this.updaterUserId = updaterUserId;
    }

    public int getNumProfileInst() {
        return this.profiles.size();
    }

    public void addProfileInst(ProfileInst profileInst) {
        this.profiles.add(profileInst);
    }

    public void deleteProfileInst(ProfileInst profileInst) {
        for (int nI = 0; nI < this.profiles.size(); ++nI) {
            if (!this.profiles.get(nI).getName().equals(profileInst.getName())) continue;
            this.profiles.remove(nI);
        }
    }

    public List<ProfileInst> getAllProfilesInst() {
        return this.profiles;
    }

    public List<ProfileInst> getInheritedProfiles() {
        ArrayList<ProfileInst> inheritedProfiles = new ArrayList<ProfileInst>();
        for (ProfileInst profile : this.profiles) {
            if (!profile.isInherited()) continue;
            inheritedProfiles.add(profile);
        }
        return inheritedProfiles;
    }

    public List<ProfileInst> getProfiles() {
        ArrayList<ProfileInst> specificProfiles = new ArrayList<ProfileInst>();
        for (ProfileInst profile : this.profiles) {
            if (profile.isInherited()) continue;
            specificProfiles.add(profile);
        }
        return specificProfiles;
    }

    public void removeAllProfilesInst() {
        this.profiles.clear();
    }

    public ProfileInst getProfileInst(String profileName) {
        for (ProfileInst profile : this.profiles) {
            if (profile.isInherited() || !profile.getName().equals(profileName)) continue;
            return profile;
        }
        return null;
    }

    public ProfileInst getInheritedProfileInst(String profileName) {
        for (ProfileInst profile : this.profiles) {
            if (!profile.isInherited() || !profile.getName().equals(profileName)) continue;
            return profile;
        }
        return null;
    }

    public ProfileInst getProfileInst(int nIndex) {
        return this.profiles.get(nIndex);
    }

    public List<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Parameter>();
        }
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public Parameter getParameter(String parameterName) {
        for (Parameter parameter : this.parameters) {
            if (!parameter.getName().equalsIgnoreCase(parameterName)) continue;
            return parameter;
        }
        return null;
    }

    public String getParameterValue(String parameterName) {
        Parameter param = this.getParameter(parameterName);
        if (param != null) {
            return param.getValue();
        }
        return "";
    }

    public String getLabel(String language) {
        if (!I18NHelper.isI18N) {
            return this.getLabel();
        }
        ComponentI18N s = (ComponentI18N)this.getTranslations().get(language);
        if (s != null) {
            return s.getName();
        }
        return this.getLabel();
    }

    public String getDescription(String language) {
        if (!I18NHelper.isI18N) {
            return this.getDescription();
        }
        ComponentI18N s = (ComponentI18N)this.getTranslations().get(language);
        if (s != null) {
            return s.getDescription();
        }
        return this.getDescription();
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void setHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public boolean isInheritanceBlocked() {
        return this.isInheritanceBlocked;
    }

    public void setInheritanceBlocked(boolean isInheritanceBlocked) {
        this.isInheritanceBlocked = isInheritanceBlocked;
    }

    public String getCreatorUserId() {
        return this.creatorUserId;
    }

    public void setCreatorUserId(String creatorUserId) {
        this.creatorUserId = creatorUserId;
    }

    public UserDetail getCreator() {
        return this.creator;
    }

    public void setCreator(UserDetail creator) {
        this.creator = creator;
    }

    public UserDetail getUpdater() {
        return this.updater;
    }

    public void setUpdater(UserDetail updater) {
        this.updater = updater;
    }

    public UserDetail getRemover() {
        return this.remover;
    }

    public void setRemover(UserDetail remover) {
        this.remover = remover;
    }

    public void removeInheritedProfiles() {
        ArrayList<ProfileInst> newProfiles = new ArrayList<ProfileInst>();
        for (ProfileInst profile : this.profiles) {
            if (profile.isInherited()) continue;
            newProfiles.add(profile);
        }
        this.profiles = newProfiles;
    }

    public boolean isWorkflow() {
        return Instanciateur.isWorkflow(this.getName());
    }

    public ComponentJsonPatch diff(ComponentInst newComponent) {
        ComponentJsonPatch patch = new ComponentJsonPatch();
        patch.setComponentType(this.getName());
        ArrayList operations = new ArrayList(10 + this.parameters.size());
        patch.addOperation(Operation.determineOperation("name", this.name, newComponent.getName()));
        patch.addOperation(Operation.determineOperation("label", this.label, newComponent.getLabel()));
        patch.addOperation(Operation.determineOperation("description", this.description, newComponent.getDescription()));
        patch.addOperation(Operation.determineOperation("domainFatherId", this.domainFatherId, newComponent.getDomainFatherId()));
        patch.addOperation(Operation.determineOperation("order", String.valueOf(this.order), String.valueOf(newComponent.getOrderNum())));
        patch.addOperation(Operation.determineOperation("public", String.valueOf(this.isPublic), String.valueOf(newComponent.isPublic())));
        patch.addOperation(Operation.determineOperation("hidden", String.valueOf(this.isHidden), String.valueOf(newComponent.isHidden())));
        patch.addOperation(Operation.determineOperation("inheritanceBlocked", String.valueOf(this.isInheritanceBlocked), String.valueOf(newComponent.isInheritanceBlocked())));
        HashSet<String> newParameters = new HashSet<String>(newComponent.getParameters().size());
        for (Parameter parameter : newComponent.getParameters()) {
            newParameters.add(parameter.getName());
        }
        for (Parameter parameter : this.parameters) {
            patch.addOperation(Operation.determineOperation(parameter.getName(), parameter.getValue(), newComponent.getParameterValue(parameter.getName())));
            newParameters.remove(parameter.getName());
        }
        for (String newParameter : newParameters) {
            patch.addOperation(Operation.determineOperation(newParameter, null, newComponent.getParameterValue(newParameter)));
        }
        return patch;
    }
}

