/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin;

import com.silverpeas.admin.components.Parameter;
import com.silverpeas.util.ArrayUtil;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.silverpeas.util.i18n.Translation;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.ComponentI18N;
import com.stratelia.webactiv.beans.admin.ComponentInst;
import com.stratelia.webactiv.beans.admin.ComponentInstLight;
import com.stratelia.webactiv.beans.admin.DomainDriverManager;
import com.stratelia.webactiv.beans.admin.ProfileInst;
import com.stratelia.webactiv.beans.admin.ProfileInstManager;
import com.stratelia.webactiv.beans.admin.dao.ComponentDAO;
import com.stratelia.webactiv.organization.ComponentInstanceI18NRow;
import com.stratelia.webactiv.organization.ComponentInstanceRow;
import com.stratelia.webactiv.organization.SpaceRow;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.JNDINames;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ComponentInstManager {
    static final ProfileInstManager profileInstManager = new ProfileInstManager();

    public ComponentInst copy(ComponentInst componentInstToCopy) {
        ComponentInst componentInst = new ComponentInst();
        componentInst.setId(componentInstToCopy.getId());
        componentInst.setName(componentInstToCopy.getName());
        componentInst.setLabel(componentInstToCopy.getLabel());
        componentInst.setDescription(componentInstToCopy.getDescription());
        componentInst.setDomainFatherId(componentInstToCopy.getDomainFatherId());
        componentInst.setOrderNum(componentInstToCopy.getOrderNum());
        componentInst.setCreateDate(componentInstToCopy.getCreateDate());
        componentInst.setUpdateDate(componentInstToCopy.getUpdateDate());
        componentInst.setRemoveDate(componentInstToCopy.getRemoveDate());
        componentInst.setStatus(componentInstToCopy.getStatus());
        componentInst.setCreatorUserId(componentInstToCopy.getCreatorUserId());
        componentInst.setUpdaterUserId(componentInstToCopy.getUpdaterUserId());
        componentInst.setRemoverUserId(componentInstToCopy.getRemoverUserId());
        for (ProfileInst profile : componentInstToCopy.getAllProfilesInst()) {
            componentInst.addProfileInst(profile);
        }
        List<Parameter> parameters = componentInstToCopy.getParameters();
        componentInst.setParameters(parameters);
        componentInst.setLanguage(componentInstToCopy.getLanguage());
        for (Translation translation : componentInstToCopy.getTranslations().values()) {
            componentInst.addTranslation(translation);
        }
        componentInst.setPublic(componentInstToCopy.isPublic());
        componentInst.setHidden(componentInstToCopy.isHidden());
        componentInst.setInheritanceBlocked(componentInstToCopy.isInheritanceBlocked());
        return componentInst;
    }

    public String createComponentInst(ComponentInst componentInst, DomainDriverManager ddManager, String sFatherId) throws AdminException {
        try {
            ComponentInstanceRow newInstance = this.makeComponentInstanceRow(componentInst);
            newInstance.spaceId = this.idAsInt(sFatherId);
            ddManager.getOrganization().instance.createComponentInstance(newInstance);
            String sComponentNodeId = ComponentInstManager.idAsString(newInstance.id);
            Map<String, Translation> translations = componentInst.getTranslations();
            for (String lang : translations.keySet()) {
                if (lang.equals(newInstance.lang)) continue;
                ComponentI18N translation = (ComponentI18N)translations.get(lang);
                ComponentInstanceI18NRow row = new ComponentInstanceI18NRow(newInstance.id, lang, translation.getName(), translation.getDescription());
                ddManager.getOrganization().instanceI18N.createTranslation(row);
            }
            List<Parameter> parameters = componentInst.getParameters();
            SilverTrace.info("admin", "ComponentInstManager.createComponentInst", "root.MSG_GEN_PARAM_VALUE", "nb parameters = " + parameters.size());
            for (Parameter parameter : parameters) {
                ddManager.getOrganization().instanceData.createInstanceData(this.idAsInt(sComponentNodeId), parameter);
            }
            for (ProfileInst profile : componentInst.getProfiles()) {
                profileInstManager.createProfileInst(profile, ddManager, sComponentNodeId);
            }
            return sComponentNodeId;
        }
        catch (Exception e) {
            throw new AdminException("ComponentInstManager.createComponentInst", 4, "admin.EX_ERR_ADD_COMPONENT", "component name: '" + componentInst.getName() + "'", e);
        }
    }

    public void sendComponentToBasket(DomainDriverManager ddManager, String componentId, String tempLabel, String userId) throws AdminException {
        try {
            ddManager.getOrganization().instance.sendComponentToBasket(this.idAsInt(componentId), tempLabel, userId);
        }
        catch (Exception e) {
            throw new AdminException("ComponentInstManager.sendComponentToBasket", 4, "admin.EX_ERR_SEND_COMPONENT_TO_BASKET", "componentId = " + componentId, e);
        }
    }

    public void restoreComponentFromBasket(DomainDriverManager ddManager, String componentId) throws AdminException {
        try {
            ddManager.getOrganization().instance.restoreComponentFromBasket(this.idAsInt(componentId));
        }
        catch (Exception e) {
            throw new AdminException("ComponentInstManager.restoreComponentFromBasket", 4, "admin.EX_ERR_RESTORE_COMPONENT_FROM_BASKET", "componentId = " + componentId, e);
        }
    }

    public ComponentInst getComponentInst(DomainDriverManager ddManager, String sComponentId, String spaceId) throws AdminException {
        String sFatherId = spaceId;
        if (sFatherId == null) {
            try {
                ddManager.getOrganizationSchema();
                SpaceRow space = ddManager.getOrganization().space.getSpaceOfInstance(this.idAsInt(sComponentId));
                if (space == null) {
                    space = new SpaceRow();
                }
                sFatherId = ComponentInstManager.idAsString(space.id);
            }
            catch (Exception e) {
                throw new AdminException("ComponentInstManager.getComponentInst", 4, "admin.EX_ERR_GET_COMPONENT", "component id: '" + sComponentId + "'", e);
            }
            finally {
                ddManager.releaseOrganizationSchema();
            }
        }
        ComponentInst componentInst = new ComponentInst();
        componentInst.removeAllProfilesInst();
        this.setComponentInst(componentInst, ddManager, sComponentId, sFatherId);
        return componentInst;
    }

    public List<ComponentInstLight> getRemovedComponents(DomainDriverManager ddManager) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            ComponentInstanceRow[] componentRows = ddManager.getOrganization().instance.getRemovedComponents();
            List<ComponentInstLight> list = this.componentInstanceRows2ComponentInstLights(componentRows);
            return list;
        }
        catch (Exception e) {
            throw new AdminException("SpaceInstManager.getRemovedSpaces", 4, "admin.EX_ERR_GET_REMOVED_SPACES", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public ComponentInstLight getComponentInstLight(DomainDriverManager ddManager, String sComponentId) throws AdminException {
        ComponentInstLight compoLight = null;
        try {
            ddManager.getOrganizationSchema();
            ComponentInstanceRow compo = ddManager.getOrganization().instance.getComponentInstance(this.idAsInt(sComponentId));
            if (compo != null) {
                compoLight = new ComponentInstLight(compo);
                compoLight.setId(compoLight.getName() + sComponentId);
                compoLight.setDomainFatherId("WA" + compoLight.getDomainFatherId());
                ComponentI18N translation = new ComponentI18N(compo.lang, compo.name, compo.description);
                compoLight.addTranslation(translation);
                List<ComponentInstanceI18NRow> translations = ddManager.getOrganization().instanceI18N.getTranslations(compo.id);
                for (int t = 0; translations != null && t < translations.size(); ++t) {
                    ComponentInstanceI18NRow row = translations.get(t);
                    compoLight.addTranslation(new ComponentI18N(row));
                }
            }
        }
        catch (Exception e) {
            throw new AdminException("ComponentInstManager.getComponentInstName", 4, "admin.EX_ERR_GET_COMPONENT_NAME", "component id: '" + sComponentId + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
        return compoLight;
    }

    public void setComponentInst(ComponentInst componentInst, DomainDriverManager ddManager, String sComponentId, String sFatherId) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            ComponentInstanceRow instance = ddManager.getOrganization().instance.getComponentInstance(this.idAsInt(sComponentId));
            if (instance != null) {
                componentInst.setId(ComponentInstManager.idAsString(instance.id));
                componentInst.setName(instance.componentName);
                componentInst.setLabel(instance.name);
                componentInst.setDescription(instance.description);
                componentInst.setDomainFatherId(sFatherId);
                componentInst.setOrderNum(instance.orderNum);
                if (instance.createTime != null) {
                    componentInst.setCreateDate(new Date(Long.parseLong(instance.createTime)));
                }
                if (instance.updateTime != null) {
                    componentInst.setUpdateDate(new Date(Long.parseLong(instance.updateTime)));
                }
                if (instance.removeTime != null) {
                    componentInst.setRemoveDate(new Date(Long.parseLong(instance.removeTime)));
                }
                componentInst.setCreatorUserId(ComponentInstManager.idAsString(instance.createdBy));
                componentInst.setUpdaterUserId(ComponentInstManager.idAsString(instance.updatedBy));
                componentInst.setRemoverUserId(ComponentInstManager.idAsString(instance.removedBy));
                componentInst.setStatus(instance.status);
                List<Parameter> parameters = ddManager.getOrganization().instanceData.getAllParametersInComponent(this.idAsInt(sComponentId));
                componentInst.setParameters(parameters);
                String[] asProfileIds = ddManager.getOrganization().userRole.getAllUserRoleIdsOfInstance(this.idAsInt(componentInst.getId()));
                for (int nI = 0; asProfileIds != null && nI < asProfileIds.length; ++nI) {
                    ProfileInst profileInst = profileInstManager.getProfileInst(ddManager, asProfileIds[nI], sComponentId);
                    componentInst.addProfileInst(profileInst);
                }
                componentInst.setLanguage(instance.lang);
                ComponentI18N translation = new ComponentI18N(instance.lang, instance.name, instance.description);
                componentInst.addTranslation(translation);
                List<ComponentInstanceI18NRow> translations = ddManager.getOrganization().instanceI18N.getTranslations(instance.id);
                for (int t = 0; translations != null && t < translations.size(); ++t) {
                    ComponentInstanceI18NRow row = translations.get(t);
                    componentInst.addTranslation(new ComponentI18N(row));
                }
                componentInst.setPublic(instance.publicAccess == 1);
                componentInst.setHidden(instance.hidden == 1);
                componentInst.setInheritanceBlocked(instance.inheritanceBlocked == 1);
            } else {
                SilverTrace.error("admin", "ComponentInstManager.setComponentInst", "root.EX_RECORD_NOT_FOUND", "instanceId = " + sComponentId);
            }
        }
        catch (Exception e) {
            throw new AdminException("ComponentInstManager.setComponentInst", 4, "admin.EX_ERR_SET_COMPONENT", "component id: '" + sComponentId + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public void deleteComponentInst(ComponentInst componentInst, DomainDriverManager ddManager) throws AdminException {
        try {
            ddManager.getOrganization().instanceI18N.removeTranslations(this.idAsInt(componentInst.getId()));
            ddManager.getOrganization().instance.removeComponentInstance(this.idAsInt(componentInst.getId()));
        }
        catch (Exception e) {
            throw new AdminException("ComponentInstManager.deleteComponentInst", 4, "admin.EX_ERR_DELETE_COMPONENT", "component id: '" + componentInst.getId() + "'", e);
        }
    }

    public void updateComponentOrder(DomainDriverManager ddManager, String sComponentId, int orderNum) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            ddManager.getOrganization().instance.updateComponentOrder(this.idAsInt(sComponentId), orderNum);
        }
        catch (Exception e) {
            throw new AdminException("ComponentInstManager.updateComponentOrder", 4, "admin.EX_ERR_UPDATE_COMPONENT", "Component Id : '" + sComponentId + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public void updateComponentInheritance(DomainDriverManager ddManager, String sComponentId, boolean inheritanceBlocked) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            ddManager.getOrganization().instance.updateComponentInheritance(this.idAsInt(sComponentId), inheritanceBlocked);
        }
        catch (Exception e) {
            throw new AdminException("ComponentInstManager.updateComponentOrder", 4, "admin.EX_ERR_UPDATE_COMPONENT_INHERITANCE", "Component Id : '" + sComponentId + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public String updateComponentInst(DomainDriverManager ddManager, ComponentInst compoInstNew) throws AdminException {
        try {
            List<Parameter> parameters = compoInstNew.getParameters();
            for (Parameter parameter : parameters) {
                ddManager.getOrganization().instanceData.updateInstanceData(this.idAsInt(compoInstNew.getId()), parameter);
            }
            ComponentInstanceRow changedInstance = this.makeComponentInstanceRow(compoInstNew);
            changedInstance.id = this.idAsInt(compoInstNew.getId());
            ComponentInstanceRow old = ddManager.getOrganization().instance.getComponentInstance(changedInstance.id);
            SilverTrace.debug("admin", this.getClass().getName() + ".updateComponentInst", "root.MSG_GEN_PARAM_VALUE", "remove = " + compoInstNew.isRemoveTranslation() + ", translationId = " + compoInstNew.getTranslationId());
            if (compoInstNew.isRemoveTranslation()) {
                if (old.lang.equalsIgnoreCase(compoInstNew.getLanguage())) {
                    List<ComponentInstanceI18NRow> translations = ddManager.getOrganization().instanceI18N.getTranslations(changedInstance.id);
                    if (translations != null && !translations.isEmpty()) {
                        ComponentInstanceI18NRow translation = translations.get(0);
                        changedInstance.lang = translation.lang;
                        changedInstance.name = translation.name;
                        changedInstance.description = translation.description;
                        ddManager.getOrganization().instance.updateComponentInstance(changedInstance);
                        ddManager.getOrganization().instanceI18N.removeTranslation(translation.id);
                    }
                } else {
                    ddManager.getOrganization().instanceI18N.removeTranslation(Integer.parseInt(compoInstNew.getTranslationId()));
                }
            } else {
                if (changedInstance.lang != null) {
                    old.lang = I18NHelper.checkLanguage(old.lang);
                    if (!old.lang.equalsIgnoreCase(changedInstance.lang)) {
                        ComponentInstanceI18NRow row = new ComponentInstanceI18NRow(changedInstance);
                        String translationId = compoInstNew.getTranslationId();
                        if (translationId != null && !"-1".equals(translationId)) {
                            row.id = Integer.parseInt(compoInstNew.getTranslationId());
                            ddManager.getOrganization().instanceI18N.updateTranslation(row);
                        } else {
                            ddManager.getOrganization().instanceI18N.createTranslation(row);
                        }
                        changedInstance.lang = old.lang;
                        changedInstance.name = old.name;
                        changedInstance.description = old.description;
                    }
                }
                ddManager.getOrganization().instance.updateComponentInstance(changedInstance);
            }
            return ComponentInstManager.idAsString(changedInstance.id);
        }
        catch (Exception e) {
            throw new AdminException("ComponentInstManager.updateComponentInst", 4, "admin.EX_ERR_UPDATE_COMPONENT", "component id: '" + compoInstNew.getId() + "'", e);
        }
    }

    public void moveComponentInst(DomainDriverManager ddManager, String spaceId, String componentId) throws AdminException {
        try {
            ddManager.getOrganization().instance.moveComponentInstance(this.idAsInt(spaceId), this.idAsInt(componentId));
        }
        catch (Exception e) {
            throw new AdminException("ComponentInstManager.moveComponentInst", 4, "admin.EX_ERR_UPDATE_COMPONENT", "spaceId= " + spaceId + " componentId=" + componentId, e);
        }
    }

    public String[] getAllCompoIdsByComponentName(DomainDriverManager ddManager, String sComponentName) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            ComponentInstanceRow cir = new ComponentInstanceRow();
            cir.name = null;
            cir.description = null;
            cir.orderNum = -1;
            cir.componentName = sComponentName;
            ComponentInstanceRow[] cirs = ddManager.getOrganization().instance.getAllMatchingComponentInstances(cir);
            if (cirs == null) {
                String[] stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
                return stringArray;
            }
            String[] compoIds = new String[cirs.length];
            for (int nI = 0; nI < cirs.length; ++nI) {
                compoIds[nI] = ComponentInstManager.idAsString(cirs[nI].id);
            }
            String[] stringArray = compoIds;
            return stringArray;
        }
        catch (Exception e) {
            throw new AdminException("ComponentInstManager.getAllCompoIdsByComponentName", 4, "admin.EX_ERR_GET_USER_AVAILABLE_INSTANCES_OF_COMPONENT", "component name: '" + sComponentName + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public String[] getComponentIdsInSpace(int spaceId) throws AdminException {
        Connection con = null;
        try {
            con = DBUtil.makeConnection(JNDINames.ADMIN_DATASOURCE);
            List<String> componentIds = ComponentDAO.getComponentIdsInSpace(con, spaceId);
            String[] stringArray = componentIds.toArray(new String[componentIds.size()]);
            return stringArray;
        }
        catch (Exception e) {
            throw new AdminException("ComponentInstManager.getComponentIdsInSpace", 4, "admin.EX_ERR_GET_SPACE_COMPONENTIDS", e);
        }
        finally {
            DBUtil.close(con);
        }
    }

    public List<ComponentInstLight> getComponentsInSpace(int spaceId) throws AdminException {
        Connection con = null;
        try {
            con = DBUtil.makeConnection(JNDINames.ADMIN_DATASOURCE);
            List<ComponentInstLight> list = ComponentDAO.getComponentsInSpace(con, spaceId);
            return list;
        }
        catch (Exception e) {
            throw new AdminException("ComponentInstManager.getComponentIdsInSpace", 4, "admin.EX_ERR_GET_SPACE_COMPONENTIDS", e);
        }
        finally {
            DBUtil.close(con);
        }
    }

    public List<String> getAllowedComponentIds(int userId, List<String> groupIds) throws AdminException {
        return this.getAllowedComponentIds(userId, groupIds, null);
    }

    public List<String> getAllowedComponentIds(int userId, List<String> groupIds, String spaceId) throws AdminException {
        return this.getAllowedComponentIds(userId, groupIds, spaceId, null);
    }

    public List<String> getAllowedComponentIds(int userId, List<String> groupIds, String spaceId, String componentName) throws AdminException {
        Connection con = null;
        try {
            con = DBUtil.makeConnection(JNDINames.ADMIN_DATASOURCE);
            if (StringUtil.isDefined(spaceId)) {
                List<String> list = ComponentDAO.getAvailableComponentIdsInSpace(con, groupIds, userId, spaceId, componentName);
                return list;
            }
            List<String> list = ComponentDAO.getAllAvailableComponentIds(con, groupIds, userId, componentName);
            return list;
        }
        catch (Exception e) {
            throw new AdminException("SpaceInstManager.getAllowedRootSpaceIds", 4, "admin.EX_ERR_GET_ALLOWED_SPACEIDS", e);
        }
        finally {
            DBUtil.close(con);
        }
    }

    public List<Parameter> getParameters(DomainDriverManager ddManager, String componentId) throws AdminException {
        try {
            List<Parameter> parameters;
            ddManager.getOrganizationSchema();
            List<Parameter> list = parameters = ddManager.getOrganization().instanceData.getAllParametersInComponent(this.idAsInt(componentId));
            return list;
        }
        catch (Exception e) {
            throw new AdminException("ComponentInstManager.getParameters", 4, "admin.EX_ERR_GET_COMPONENT_PARAMETERS", "componentId = " + componentId, e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    private ComponentInstanceRow makeComponentInstanceRow(ComponentInst componentInst) {
        ComponentInstanceRow instance = new ComponentInstanceRow();
        instance.id = this.idAsInt(componentInst.getId());
        instance.componentName = componentInst.getName();
        instance.name = componentInst.getLabel();
        instance.description = componentInst.getDescription();
        instance.orderNum = componentInst.getOrderNum();
        instance.lang = componentInst.getLanguage();
        instance.createdBy = this.idAsInt(componentInst.getCreatorUserId());
        instance.updatedBy = this.idAsInt(componentInst.getUpdaterUserId());
        instance.publicAccess = componentInst.isPublic() ? 1 : 0;
        instance.hidden = componentInst.isHidden() ? 1 : 0;
        instance.inheritanceBlocked = componentInst.isInheritanceBlocked() ? 1 : 0;
        return instance;
    }

    private List<ComponentInstLight> componentInstanceRows2ComponentInstLights(ComponentInstanceRow[] rows) {
        ArrayList<ComponentInstLight> components = new ArrayList<ComponentInstLight>();
        for (int s = 0; rows != null && s < rows.length; ++s) {
            ComponentInstLight componentLight = new ComponentInstLight(rows[s]);
            componentLight.setId(componentLight.getName() + componentLight.getId());
            componentLight.setDomainFatherId("WA" + componentLight.getDomainFatherId());
            components.add(componentLight);
        }
        return components;
    }

    private int idAsInt(String id) {
        if (id == null || id.length() == 0) {
            return -1;
        }
        try {
            return Integer.parseInt(id);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static String idAsString(int id) {
        return Integer.toString(id);
    }
}

