/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin;

import com.silverpeas.util.ArrayUtil;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.UserDetail;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.silverpeas.core.admin.OrganisationController;
import org.silverpeas.core.admin.OrganisationControllerFactory;

public class Group
implements Serializable,
Comparable<Group> {
    private static final long serialVersionUID = 4430574302630237352L;
    private String id = null;
    private String specificId = null;
    private String domainId = null;
    private String superGroupId = null;
    private String name = "";
    private String description = "";
    private String rule = null;
    private String[] userIds = ArrayUtil.EMPTY_STRING_ARRAY;
    private int nbUsers = -1;
    private int nbTotalUsers = -1;

    public static Group getById(String id) {
        return Group.getOrganisationController().getGroup(id);
    }

    public static List<Group> getAllRoots() {
        return Arrays.asList(Group.getOrganisationController().getAllRootGroups());
    }

    public static List<Group> getAllRootsInDomain(String domainId) {
        return Arrays.asList(Group.getOrganisationController().getAllRootGroupsInDomain(domainId));
    }

    public Group() {
    }

    public Group(Group toClone) {
        this.id = toClone.id;
        this.specificId = toClone.specificId;
        this.domainId = toClone.domainId;
        this.superGroupId = toClone.superGroupId;
        this.name = toClone.name;
        this.description = toClone.description;
        this.userIds = toClone.userIds;
        this.rule = toClone.rule;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String newId) {
        this.id = newId;
    }

    public String getSpecificId() {
        return this.specificId;
    }

    public void setSpecificId(String newSpecificId) {
        this.specificId = newSpecificId;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public void setDomainId(String newDomainId) {
        this.domainId = newDomainId;
    }

    public String getSuperGroupId() {
        return this.superGroupId;
    }

    public void setSuperGroupId(String newSuperGroupId) {
        this.superGroupId = newSuperGroupId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String newDescription) {
        this.description = newDescription != null ? newDescription : "";
    }

    public void setUserIds(String[] sUserIds) {
        this.userIds = ArrayUtil.nullToEmpty((String[])sUserIds);
    }

    public String[] getUserIds() {
        return this.userIds;
    }

    public void traceGroup() {
        SilverTrace.info("admin", "Group.traceGroup", "admin.MSG_DUMP_GROUP", "id : " + this.id);
        SilverTrace.info("admin", "Group.traceGroup", "admin.MSG_DUMP_GROUP", "specificId : " + this.specificId);
        SilverTrace.info("admin", "Group.traceGroup", "admin.MSG_DUMP_GROUP", "domainId : " + this.domainId);
        SilverTrace.info("admin", "Group.traceGroup", "admin.MSG_DUMP_GROUP", "superGroupId : " + this.superGroupId);
        SilverTrace.info("admin", "Group.traceGroup", "admin.MSG_DUMP_GROUP", "name : " + this.name);
        SilverTrace.info("admin", "Group.traceGroup", "admin.MSG_DUMP_GROUP", "description : " + this.description);
        SilverTrace.info("admin", "Group.traceGroup", "admin.MSG_DUMP_GROUP", "rule : " + this.rule);
        for (int i = 0; i < this.userIds.length; ++i) {
            SilverTrace.info("admin", "Group.traceGroup", "admin.MSG_DUMP_GROUP", "userId " + Integer.toString(i) + " : " + this.userIds[i]);
        }
    }

    @Override
    public int compareTo(Group o) {
        return this.getName().toLowerCase().compareTo(o.getName().toLowerCase());
    }

    public String getRule() {
        return this.rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public boolean isSynchronized() {
        return this.rule != null && this.rule.trim().length() > 0;
    }

    public int getNbUsers() {
        if (this.nbUsers == -1) {
            return this.getUserIds().length;
        }
        return this.nbUsers;
    }

    public int getTotalNbUsers() {
        if (this.nbTotalUsers < 0) {
            this.nbTotalUsers = Group.getOrganisationController().getAllSubUsersNumber(this.getId());
        }
        return this.nbTotalUsers;
    }

    public void setNbUsers(int nbUsers) {
        this.nbUsers = nbUsers;
    }

    public void setTotalNbUsers(int count) {
        this.nbTotalUsers = count;
    }

    protected static OrganisationController getOrganisationController() {
        OrganisationControllerFactory.getFactory();
        return OrganisationControllerFactory.getOrganisationController();
    }

    public boolean isRoot() {
        return !StringUtil.isDefined(this.superGroupId);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Group other = (Group)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.specificId == null ? other.specificId != null : !this.specificId.equals(other.specificId)) {
            return false;
        }
        if (this.domainId == null ? other.domainId != null : !this.domainId.equals(other.domainId)) {
            return false;
        }
        if (this.superGroupId == null ? other.superGroupId != null : !this.superGroupId.equals(other.superGroupId)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.rule == null ? other.rule != null : !this.rule.equals(other.rule)) {
            return false;
        }
        return this.getNbUsers() == other.getNbUsers();
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (this.id != null ? this.id.hashCode() : 0);
        hash = 97 * hash + (this.specificId != null ? this.specificId.hashCode() : 0);
        hash = 97 * hash + (this.domainId != null ? this.domainId.hashCode() : 0);
        hash = 97 * hash + (this.superGroupId != null ? this.superGroupId.hashCode() : 0);
        hash = 97 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 97 * hash + (this.description != null ? this.description.hashCode() : 0);
        hash = 97 * hash + (this.rule != null ? this.rule.hashCode() : 0);
        hash = 97 * hash + this.nbUsers;
        return hash;
    }

    public List<? extends Group> getSubGroups() {
        return Arrays.asList(Group.getOrganisationController().getAllSubGroups(this.getId()));
    }

    public List<? extends UserDetail> getAllUsers() {
        return Arrays.asList(Group.getOrganisationController().getAllUsersOfGroup(this.getId()));
    }
}

