/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin;

import com.silverpeas.admin.components.Instanciateur;
import com.silverpeas.admin.components.Parameter;
import com.silverpeas.admin.components.WAComponent;
import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.AdminReference;
import com.stratelia.webactiv.beans.admin.ComponentInst;
import com.stratelia.webactiv.beans.admin.SpaceInst;
import com.stratelia.webactiv.beans.admin.SpaceProfileInst;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.ResourceLocator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.silverpeas.core.admin.OrganisationController;
import org.silverpeas.quota.exception.QuotaException;

public class PersonalSpaceController {
    private static final String MESSAGES_LOCATION = "org.silverpeas.jobStartPagePeas.multilang.jobStartPagePeasBundle";

    public List<WAComponent> getVisibleComponents(OrganisationController orgaController) {
        ArrayList<WAComponent> visibleComponents = new ArrayList<WAComponent>();
        Collection<WAComponent> components = orgaController.getAllComponents().values();
        for (WAComponent component : components) {
            if (!component.isVisibleInPersonalSpace()) continue;
            visibleComponents.add(component);
        }
        return visibleComponents;
    }

    public String addComponent(String userId, String componentName, String componentLabel) throws AdminException, QuotaException {
        ComponentInst component = new ComponentInst();
        component.setCreatorUserId(userId);
        component.setInheritanceBlocked(false);
        component.setLabel(componentLabel);
        component.setName(componentName);
        WAComponent baseComponent = Instanciateur.getWAComponent(componentName);
        if (baseComponent == null || !baseComponent.isVisibleInPersonalSpace()) {
            UserDetail user = UserDetail.getById(userId);
            ResourceLocator messages = this.getMessages(user.getUserPreferences().getLanguage());
            String errorText = messages.getString("JSPP.ErrorUnknownComponent");
            throw new AdminException(MessageFormat.format(errorText, componentName), false);
        }
        List<Parameter> parameters = baseComponent.getParameters();
        for (Parameter parameter : parameters) {
            if (!StringUtil.isDefined(parameter.getPersonalSpaceValue())) continue;
            parameter.setValue(parameter.getPersonalSpaceValue());
        }
        component.setParameters(parameters);
        SpaceInst space = this.getPersonalSpace(userId);
        if (space == null) {
            space = new SpaceInst();
            space.setCreatorUserId(userId);
            space.setInheritanceBlocked(true);
            space.setLevel(0);
            space.setName("Personal space of user #" + userId);
            space.setPersonalSpace(true);
            SpaceProfileInst profile = new SpaceProfileInst();
            profile.setName("admin");
            profile.addUser(userId);
            profile.setInherited(false);
            space.getAllSpaceProfilesInst().add(profile);
            space.addComponentInst(component);
            AdminReference.getAdminService().addSpaceInst(userId, space);
        } else {
            component.setDomainFatherId(space.getId());
            AdminReference.getAdminService().addComponentInst(userId, component);
        }
        return componentName + component.getId();
    }

    public String removeComponent(String userId, String componentId) throws AdminException {
        ComponentInst component;
        SpaceInst space = this.getPersonalSpace(userId);
        if (space != null && (component = this.getComponent(space, componentId)) != null) {
            AdminReference.getAdminService().deleteComponentInst(userId, componentId, true, true);
            return component.getName();
        }
        return null;
    }

    public SpaceInst getPersonalSpace(String userId) {
        try {
            return AdminReference.getAdminService().getPersonalSpace(userId);
        }
        catch (AdminException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    private ComponentInst getComponent(SpaceInst space, String componentId) {
        ArrayList<ComponentInst> components = space.getAllComponentsInst();
        for (ComponentInst component : components) {
            if (!(component.getName() + component.getId()).equalsIgnoreCase(componentId)) continue;
            return component;
        }
        return null;
    }

    private ResourceLocator getMessages(String language) {
        return new ResourceLocator(MESSAGES_LOCATION, language);
    }
}

