/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin;

import com.silverpeas.util.ArrayUtil;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.AbstractI18NBean;
import com.silverpeas.util.i18n.I18NHelper;
import com.silverpeas.util.template.SilverpeasTemplate;
import com.silverpeas.util.template.SilverpeasTemplateFactory;
import com.stratelia.webactiv.beans.admin.ComponentInst;
import com.stratelia.webactiv.beans.admin.SpaceI18N;
import com.stratelia.webactiv.beans.admin.SpaceInstLight;
import com.stratelia.webactiv.beans.admin.SpaceProfileInst;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.GeneralPropertiesManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.silverpeas.admin.space.SpaceServiceFactory;
import org.silverpeas.admin.space.quota.ComponentSpaceQuotaKey;
import org.silverpeas.admin.space.quota.DataStorageSpaceQuotaKey;
import org.silverpeas.core.admin.OrganisationControllerFactory;
import org.silverpeas.quota.contant.QuotaType;
import org.silverpeas.quota.exception.QuotaException;
import org.silverpeas.quota.exception.QuotaRuntimeException;
import org.silverpeas.quota.model.Quota;
import org.silverpeas.util.UnitUtil;

public class SpaceInst
extends AbstractI18NBean
implements Serializable,
Comparable<SpaceInst>,
Cloneable {
    public static final String PERSONAL_SPACE_ID = "-10";
    public static final String DEFAULT_SPACE_ID = "-20";
    private static final long serialVersionUID = 4695928610067045964L;
    public static final int FP_TYPE_STANDARD = 0;
    public static final int FP_TYPE_COMPONENT_INST = 1;
    public static final int FP_TYPE_PORTLET = 2;
    public static final int FP_TYPE_HTML_PAGE = 3;
    public static final String STATUS_REMOVED = "R";
    private String id = "";
    private String domainFatherId = "";
    private String name = "";
    private String description = "";
    private String creatorUserId = "";
    private int firstPageType = 0;
    private String firstPageExtraParam = "";
    private int orderNum = 0;
    private Date createDate = null;
    private Date updateDate = null;
    private Date removeDate = null;
    private String status = null;
    private UserDetail creator;
    private UserDetail updater;
    private UserDetail remover;
    private String updaterUserId;
    private String removerUserId;
    private boolean inheritanceBlocked = false;
    private String look = null;
    private ArrayList<ComponentInst> components = new ArrayList();
    private ArrayList<SpaceProfileInst> spaceProfiles = new ArrayList();
    private String[] subSpaceIds = ArrayUtil.EMPTY_STRING_ARRAY;
    private int level = 0;
    private boolean displaySpaceFirst = true;
    private boolean isPersonalSpace = false;
    private Quota componentSpaceQuota = null;
    private Quota componentSpaceQuotaReached = null;
    private Quota dataStorageQuota = null;
    private Quota dataStorageQuotaReached = null;

    @Override
    public int compareTo(SpaceInst o) {
        return this.orderNum - o.orderNum;
    }

    public void setId(String sId) {
        this.id = sId;
    }

    public String getId() {
        return this.id;
    }

    public void setDomainFatherId(String sDomainFatherId) {
        this.domainFatherId = sDomainFatherId;
    }

    public String getDomainFatherId() {
        return this.domainFatherId;
    }

    public void setName(String sName) {
        this.name = sName;
    }

    public String getName() {
        return this.name;
    }

    public String getName(String language) {
        if (this.isPersonalSpace) {
            return GeneralPropertiesManager.getGeneralMultilang(language).getString("GML.personalSpace", "Mon espace");
        }
        if (!I18NHelper.isI18N) {
            return this.getName();
        }
        SpaceI18N s = (SpaceI18N)this.getTranslations().get(language);
        if (s != null) {
            return s.getName();
        }
        return this.getName();
    }

    public void setDescription(String sDescription) {
        this.description = sDescription;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescription(String language) {
        if (!I18NHelper.isI18N) {
            return this.getDescription();
        }
        SpaceI18N s = (SpaceI18N)this.getTranslations().get(language);
        if (s != null) {
            return s.getDescription();
        }
        return this.getDescription();
    }

    public void setCreatorUserId(String sCreatorUserId) {
        this.creatorUserId = sCreatorUserId;
    }

    public String getCreatorUserId() {
        return this.creatorUserId;
    }

    public void setFirstPageType(int iFirstPageType) {
        this.firstPageType = iFirstPageType;
    }

    public int getFirstPageType() {
        return this.firstPageType;
    }

    public void setOrderNum(int iOrderNum) {
        this.orderNum = iOrderNum;
    }

    public int getOrderNum() {
        return this.orderNum;
    }

    public void setFirstPageExtraParam(String sFirstPageExtraParam) {
        this.firstPageExtraParam = sFirstPageExtraParam;
    }

    public String getFirstPageExtraParam() {
        return this.firstPageExtraParam;
    }

    public void setSubSpaceIds(String[] asSubSpaceIds) {
        this.subSpaceIds = asSubSpaceIds == null ? ArrayUtil.EMPTY_STRING_ARRAY : (String[])asSubSpaceIds.clone();
    }

    public String[] getSubSpaceIds() {
        return this.subSpaceIds;
    }

    public int getNumComponentInst() {
        return this.components.size();
    }

    public void addComponentInst(ComponentInst componentInst) {
        this.components.add(componentInst);
    }

    public void deleteComponentInst(ComponentInst componentInst) {
        for (int nI = 0; nI < this.components.size(); ++nI) {
            if (!this.components.get(nI).getName().equals(componentInst.getName())) continue;
            this.components.remove(nI);
            return;
        }
    }

    public ArrayList<ComponentInst> getAllComponentsInst() {
        return this.components;
    }

    public void removeAllComponentsInst() {
        this.components = new ArrayList();
    }

    public ComponentInst getComponentInst(String componentName) {
        if (!this.components.isEmpty()) {
            for (ComponentInst component : this.components) {
                if (!component.getName().equals(componentName)) continue;
                return component;
            }
        }
        return null;
    }

    public ComponentInst getComponentInst(int nIndex) {
        return this.components.get(nIndex);
    }

    public int getNumSpaceProfileInst() {
        return this.spaceProfiles.size();
    }

    public void addSpaceProfileInst(SpaceProfileInst spaceProfileInst) {
        spaceProfileInst.setSpaceFatherId(this.getId());
        if (this.spaceProfiles.contains(spaceProfileInst)) {
            this.spaceProfiles.remove(spaceProfileInst);
        }
        this.spaceProfiles.add(spaceProfileInst);
    }

    public void deleteSpaceProfileInst(SpaceProfileInst spaceProfileInst) {
        for (int nI = 0; nI < this.spaceProfiles.size(); ++nI) {
            SpaceProfileInst profile = this.spaceProfiles.get(nI);
            if (!profile.getId().equals(spaceProfileInst.getId())) continue;
            this.spaceProfiles.remove(nI);
        }
    }

    public ArrayList<SpaceProfileInst> getAllSpaceProfilesInst() {
        return this.spaceProfiles;
    }

    public void removeAllSpaceProfilesInst() {
        this.spaceProfiles = new ArrayList();
    }

    public SpaceProfileInst getSpaceProfileInst(String sSpaceProfileName) {
        return this.getSpaceProfileInst(sSpaceProfileName, false);
    }

    public SpaceProfileInst getInheritedSpaceProfileInst(String sSpaceProfileName) {
        return this.getSpaceProfileInst(sSpaceProfileName, true);
    }

    private SpaceProfileInst getSpaceProfileInst(String spaceProfileName, boolean inherited) {
        for (SpaceProfileInst profile : this.spaceProfiles) {
            if (profile.isInherited() != inherited || !profile.getName().equals(spaceProfileName)) continue;
            return profile;
        }
        return null;
    }

    public SpaceProfileInst getSpaceProfileInst(int nIndex) {
        return this.spaceProfiles.get(nIndex);
    }

    public List<SpaceProfileInst> getInheritedProfiles() {
        ArrayList<SpaceProfileInst> profiles = new ArrayList<SpaceProfileInst>();
        for (SpaceProfileInst profile : this.spaceProfiles) {
            if (!profile.isInherited()) continue;
            profiles.add(profile);
        }
        return profiles;
    }

    public List<SpaceProfileInst> getProfiles() {
        ArrayList<SpaceProfileInst> profiles = new ArrayList<SpaceProfileInst>();
        for (SpaceProfileInst profile : this.spaceProfiles) {
            if (profile.isInherited()) continue;
            profiles.add(profile);
        }
        return profiles;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isRoot() {
        return !StringUtil.isDefined(this.getDomainFatherId()) || "0".equals(this.getDomainFatherId()) || "-1".equals(this.getDomainFatherId());
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getRemoveDate() {
        return this.removeDate;
    }

    public void setRemoveDate(Date removeDate) {
        this.removeDate = removeDate;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public String getRemoverUserId() {
        return this.removerUserId;
    }

    public void setRemoverUserId(String removerUserId) {
        this.removerUserId = removerUserId;
    }

    public String getUpdaterUserId() {
        return this.updaterUserId;
    }

    public void setUpdaterUserId(String updaterUserId) {
        this.updaterUserId = updaterUserId;
    }

    public boolean isInheritanceBlocked() {
        return this.inheritanceBlocked;
    }

    public void setInheritanceBlocked(boolean isInheritanceBlocked) {
        this.inheritanceBlocked = isInheritanceBlocked;
    }

    public String getLook() {
        return this.look;
    }

    public void setLook(String look) {
        this.look = look;
    }

    public UserDetail getCreator() {
        return this.creator;
    }

    public void setCreator(UserDetail creator) {
        this.creator = creator;
    }

    public UserDetail getUpdater() {
        return this.updater;
    }

    public void setUpdater(UserDetail updater) {
        this.updater = updater;
    }

    public UserDetail getRemover() {
        return this.remover;
    }

    public void setRemover(UserDetail remover) {
        this.remover = remover;
    }

    public boolean isDisplaySpaceFirst() {
        return this.displaySpaceFirst;
    }

    public void setDisplaySpaceFirst(boolean isDisplaySpaceFirst) {
        this.displaySpaceFirst = isDisplaySpaceFirst;
    }

    public void setPersonalSpace(boolean isPersonalSpace) {
        this.isPersonalSpace = isPersonalSpace;
    }

    public boolean isPersonalSpace() {
        return this.isPersonalSpace;
    }

    public Quota getComponentSpaceQuota() {
        if (this.componentSpaceQuota == null) {
            this.loadComponentSpaceQuota();
        }
        return this.componentSpaceQuota;
    }

    public void setComponentSpaceQuotaMaxCount(long componentSpaceQuotaMaxCount) throws QuotaException {
        this.loadComponentSpaceQuota();
        this.componentSpaceQuota.setMaxCount(componentSpaceQuotaMaxCount);
        this.componentSpaceQuota.validateBounds();
    }

    public boolean isComponentSpaceQuotaReached() {
        this.componentSpaceQuotaReached = SpaceServiceFactory.getComponentSpaceQuotaService().getQuotaReachedFromSpacePath(ComponentSpaceQuotaKey.from(this));
        return this.componentSpaceQuotaReached.isReached();
    }

    public String getComponentSpaceQuotaReachedErrorMessage(String language) {
        return this.getQuotaReachedErrorMessage(this.componentSpaceQuotaReached, language, "componentSpaceQuotaReached");
    }

    private void loadComponentSpaceQuota() {
        try {
            this.componentSpaceQuota = SpaceServiceFactory.getComponentSpaceQuotaService().get(ComponentSpaceQuotaKey.from(this));
        }
        catch (QuotaException qe) {
            throw new QuotaRuntimeException("Space", 4, "root.EX_CANT_GET_COMPONENT_SPACE_QUOTA", qe);
        }
    }

    public Quota getDataStorageQuota() {
        if (this.dataStorageQuota == null) {
            this.loadDataStorageQuota();
        }
        return this.dataStorageQuota;
    }

    public void setDataStorageQuotaMaxCount(long dataStorageQuotaMaxCount) throws QuotaException {
        this.loadDataStorageQuota();
        this.dataStorageQuota.setMaxCount(dataStorageQuotaMaxCount);
        this.dataStorageQuota.validateBounds();
    }

    public boolean isDataStorageQuotaReached() {
        this.dataStorageQuotaReached = SpaceServiceFactory.getDataStorageSpaceQuotaService().getQuotaReachedFromSpacePath(DataStorageSpaceQuotaKey.from(this));
        return this.dataStorageQuotaReached.isReached();
    }

    public String getDataStorageQuotaReachedErrorMessage(String language) {
        return this.getQuotaReachedErrorMessage(this.dataStorageQuotaReached, language, "dataStorageQuotaReached");
    }

    private void loadDataStorageQuota() {
        try {
            this.dataStorageQuota = SpaceServiceFactory.getDataStorageSpaceQuotaService().get(DataStorageSpaceQuotaKey.from(this));
        }
        catch (QuotaException qe) {
            throw new QuotaRuntimeException("Space", 4, "root.EX_CANT_GET_DATA_STORAGE_QUOTA", qe);
        }
    }

    private String getQuotaReachedErrorMessage(Quota quotaReached, String language, String stringTemplateFile) {
        if (!QuotaType.COMPONENTS_IN_SPACE.equals((Object)quotaReached.getType())) {
            quotaReached = quotaReached.clone();
            quotaReached.setMinCount(UnitUtil.convertTo(quotaReached.getMinCount(), UnitUtil.memUnit.B, UnitUtil.memUnit.MB));
            quotaReached.setMaxCount(UnitUtil.convertTo(quotaReached.getMaxCount(), UnitUtil.memUnit.B, UnitUtil.memUnit.MB));
            quotaReached.setCount(UnitUtil.convertTo(quotaReached.getCount(), UnitUtil.memUnit.B, UnitUtil.memUnit.MB));
        }
        SpaceInstLight space = OrganisationControllerFactory.getOrganisationController().getSpaceInstLightById(quotaReached.getResourceId());
        SilverpeasTemplate template = SilverpeasTemplateFactory.createSilverpeasTemplateOnCore("admin/space/quota");
        template.setAttribute("quota", quotaReached);
        if (!space.getShortId().equals(new SpaceInstLight(this).getShortId())) {
            template.setAttribute("fromSpaceId", space.getShortId());
            template.setAttribute("fromSpaceName", space.getName());
        }
        if (!StringUtil.isDefined(language)) {
            language = I18NHelper.defaultLanguage;
        }
        return template.applyFileTemplate(stringTemplateFile + "_" + language);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof SpaceInst) {
            SpaceInst other = (SpaceInst)obj;
            return ObjectUtils.equals((Object)other.createDate, (Object)this.createDate) && ObjectUtils.equals((Object)other.id, (Object)this.id) && ObjectUtils.equals((Object)other.level, (Object)this.level) && ObjectUtils.equals((Object)other.look, (Object)this.look) && ObjectUtils.equals((Object)other.firstPageType, (Object)this.firstPageType) && ObjectUtils.equals((Object)other.orderNum, (Object)this.orderNum) && ObjectUtils.equals((Object)other.creatorUserId, (Object)this.creatorUserId) && ObjectUtils.equals((Object)other.description, (Object)this.description) && ObjectUtils.equals((Object)other.domainFatherId, (Object)this.domainFatherId) && ObjectUtils.equals((Object)other.firstPageExtraParam, (Object)this.firstPageExtraParam) && ObjectUtils.equals((Object)other.name, (Object)this.name);
        }
        return false;
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.createDate, this.id, this.level, this.look, this.firstPageType, this.orderNum, this.creatorUserId, this.description, this.domainFatherId, this.firstPageExtraParam, this.name});
    }

    public SpaceInst clone() {
        SpaceInst clone = new SpaceInst();
        clone.setDescription(this.description);
        clone.setDisplaySpaceFirst(this.displaySpaceFirst);
        clone.setFirstPageExtraParam(this.firstPageExtraParam);
        clone.setFirstPageType(this.firstPageType);
        clone.setInheritanceBlocked(this.inheritanceBlocked);
        clone.setLook(this.look);
        clone.setName(this.name);
        clone.setPersonalSpace(this.isPersonalSpace);
        List<SpaceProfileInst> profiles = this.getProfiles();
        for (SpaceProfileInst profile : profiles) {
            clone.addSpaceProfileInst(profile.clone());
        }
        for (String lang : this.getTranslations().keySet()) {
            SpaceI18N translation = (SpaceI18N)this.getTranslation(lang);
            clone.addTranslation(translation);
        }
        ArrayList<ComponentInst> allComponents = this.getAllComponentsInst();
        for (ComponentInst component : allComponents) {
            clone.addComponentInst((ComponentInst)component.clone());
        }
        clone.setSubSpaceIds((String[])this.getSubSpaceIds().clone());
        return clone;
    }

    public void removeInheritedProfiles() {
        ArrayList<SpaceProfileInst> newProfiles = new ArrayList<SpaceProfileInst>();
        for (SpaceProfileInst profile : this.spaceProfiles) {
            if (profile.isInherited()) continue;
            newProfiles.add(profile);
        }
        this.spaceProfiles = newProfiles;
    }
}

