/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin;

import com.silverpeas.util.ArrayUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.DomainDriver;
import com.stratelia.webactiv.beans.admin.DomainProperty;
import com.stratelia.webactiv.beans.admin.UserDetail;
import java.util.HashMap;
import java.util.Map;
import org.silverpeas.profile.token.UserTokenKey;
import org.silverpeas.token.exception.TokenException;
import org.silverpeas.token.exception.TokenRuntimeException;
import org.silverpeas.token.service.TokenServiceFactory;

public class UserFull
extends UserDetail {
    private static final long serialVersionUID = 1L;
    protected HashMap<String, String> m_hInfos = new HashMap();
    protected DomainDriver m_pDomainDriver = null;
    protected String m_password = "";
    protected boolean m_isPasswordValid = false;
    protected boolean m_isPasswordAvailable = false;

    public static UserFull getById(String userId) {
        return UserFull.getOrganisationController().getUserFull(userId);
    }

    public UserFull() {
    }

    public UserFull(DomainDriver domainDriver) {
        this.m_pDomainDriver = domainDriver;
    }

    public UserFull(DomainDriver domainDriver, UserDetail toClone) {
        super(toClone);
        this.m_pDomainDriver = domainDriver;
    }

    public boolean isPasswordAvailable() {
        return this.m_isPasswordAvailable;
    }

    public void setPasswordAvailable(boolean pa) {
        this.m_isPasswordAvailable = pa;
    }

    public boolean isPasswordValid() {
        return this.m_isPasswordValid;
    }

    public void setPasswordValid(boolean pv) {
        this.m_isPasswordValid = pv;
    }

    public String getPassword() {
        return this.m_password == null ? "" : this.m_password;
    }

    public String getToken() {
        try {
            return TokenServiceFactory.getTokenService().getInitialized(UserTokenKey.from(this)).getValue();
        }
        catch (TokenException e) {
            throw new TokenRuntimeException(e);
        }
    }

    public void setPassword(String p) {
        this.m_password = p;
    }

    public String[] getPropertiesNames() {
        if (this.m_pDomainDriver != null) {
            return this.m_pDomainDriver.getPropertiesNames();
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public HashMap<String, String> getSpecificDetails() {
        return this.m_hInfos;
    }

    public String getValue(String propertyName, String defaultValue) {
        String valret = this.m_hInfos.get(propertyName);
        if (valret == null) {
            valret = defaultValue;
        }
        return valret;
    }

    public String getValue(String propertyName) {
        return this.getValue(propertyName, "");
    }

    public boolean getValue(String propertyName, boolean defaultValue) {
        boolean valret = defaultValue;
        String sValret = this.m_hInfos.get(propertyName);
        if (sValret != null) {
            valret = Boolean.parseBoolean(sValret);
        }
        return valret;
    }

    public Map<String, String> getSpecificLabels(String language) {
        if (this.m_pDomainDriver != null) {
            return this.m_pDomainDriver.getPropertiesLabels(language);
        }
        return null;
    }

    public String getSpecificLabel(String language, String propertyName) {
        String valret = null;
        if (this.m_pDomainDriver != null) {
            Map<String, String> theLabels = this.m_pDomainDriver.getPropertiesLabels(language);
            valret = theLabels.get(propertyName);
        }
        if (valret == null) {
            valret = "";
        }
        return valret;
    }

    public String getPropertyType(String propertyName) {
        DomainProperty domainProperty;
        String valret = null;
        if (this.m_pDomainDriver != null && (domainProperty = this.m_pDomainDriver.getProperty(propertyName)) != null) {
            valret = domainProperty.getType();
        }
        if (valret == null) {
            valret = "";
        }
        return valret;
    }

    public boolean isPropertyUpdatableByUser(String property) {
        DomainProperty domainProperty;
        if (this.m_pDomainDriver != null && (domainProperty = this.m_pDomainDriver.getProperty(property)) != null) {
            return domainProperty.isUpdateAllowedToUser();
        }
        return false;
    }

    public boolean isPropertyUpdatableByAdmin(String property) {
        DomainProperty domainProperty;
        if (this.m_pDomainDriver != null && (domainProperty = this.m_pDomainDriver.getProperty(property)) != null) {
            return domainProperty.isUpdateAllowedToAdmin();
        }
        return false;
    }

    public boolean isAtLeastOnePropertyUpdatableByAdmin() {
        if (this.m_pDomainDriver != null) {
            String[] properties;
            for (String property : properties = this.m_pDomainDriver.getPropertiesNames()) {
                if (!this.isPropertyUpdatableByAdmin(property)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAtLeastOnePropertyUpdatableByUser() {
        if (this.m_pDomainDriver != null) {
            String[] properties;
            for (String property : properties = this.m_pDomainDriver.getPropertiesNames()) {
                if (!this.isPropertyUpdatableByUser(property)) continue;
                return true;
            }
        }
        return false;
    }

    public DomainProperty getProperty(String property) {
        if (this.m_pDomainDriver != null) {
            return this.m_pDomainDriver.getProperty(property);
        }
        return null;
    }

    public void setValue(String propertyName, String value) {
        this.m_hInfos.put(propertyName, value);
    }

    public void setValue(String propertyName, boolean bValue) {
        this.m_hInfos.put(propertyName, String.valueOf(bValue));
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof UserFull) {
            UserFull cmpUser = (UserFull)other;
            if (super.equals(cmpUser)) {
                String[] keys = this.m_hInfos.keySet().toArray(new String[this.m_hInfos.size()]);
                boolean isTheSame = true;
                for (int i = 0; i < keys.length && isTheSame; ++i) {
                    isTheSame = this.getValue(keys[i]).equals(cmpUser.getValue(keys[i]));
                }
                return isTheSame;
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 53 * super.hashCode();
        return hash;
    }

    @Override
    public void traceUser() {
        super.traceUser();
        for (Map.Entry<String, String> entry : this.m_hInfos.entrySet()) {
            SilverTrace.info("admin", "UserFull.traceUser", "admin.MSG_DUMP_USER", entry.getKey() + " : " + entry.getValue());
        }
    }
}

