/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin.dao;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.ComponentInstLight;
import com.stratelia.webactiv.beans.admin.dao.ComponentInstLightSorter;
import com.stratelia.webactiv.util.DBUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class ComponentDAO {
    private static final String INSTANCE_COLUMNS = "id,spaceId,name,componentName,description,createdBy,orderNum,createTime,updateTime,removeTime,componentStatus,updatedBy,removedBy,isPublic,isHidden,lang,isInheritanceBlocked";
    private static final String queryAllSpaceInstanceIds = "select id, componentName from ST_ComponentInstance where spaceId = ? and componentStatus is null order by orderNum";
    private static final String queryAllSpaceInstances = "select id,spaceId,name,componentName,description,createdBy,orderNum,createTime,updateTime,removeTime,componentStatus,updatedBy,removedBy,isPublic,isHidden,lang,isInheritanceBlocked from ST_ComponentInstance where spaceId = ? and componentStatus is null order by orderNum";
    private static final String queryAllAvailableComponentIds = " select distinct(c.id), c.componentName from st_componentinstance c, st_userrole r, st_userrole_user_rel ur where c.id=r.instanceId and c.componentstatus is null and r.id=ur.userroleid and r.objectId is null and ur.userId = ? ";
    private static final String queryAllPublicComponentIds = " select c.id, c.componentName from st_componentinstance c where c.ispublic=1 and c.componentstatus is null";
    private static final String queryPublicComponentIdsInSpace = " select c.id, c.componentName, c.ordernum from st_componentinstance c where c.ispublic=1 and c.spaceId = ? and c.componentstatus is null";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getComponentIdsInSpace(Connection con, int spaceId) throws SQLException {
        ArrayList<String> arrayList;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            ArrayList<String> ids = new ArrayList<String>();
            stmt = con.prepareStatement(queryAllSpaceInstanceIds);
            stmt.setInt(1, spaceId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                ids.add(rs.getString(2) + Integer.toString(rs.getInt(1)));
            }
            arrayList = ids;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close(rs, stmt);
        return arrayList;
    }

    private static ComponentInstLight fetchComponentInstance(ResultSet rs) throws SQLException {
        ComponentInstLight i = new ComponentInstLight();
        String name = rs.getString(4);
        i.setId(name + Integer.toString(rs.getInt(1)));
        i.setDomainFatherId(Integer.toString(rs.getInt(2)));
        i.setLabel(rs.getString(3));
        i.setName(name);
        i.setInheritanceBlocked(rs.getInt("isInheritanceBlocked") == 1);
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ComponentInstLight> getComponentsInSpace(Connection con, int spaceId) throws SQLException {
        ArrayList<ComponentInstLight> arrayList;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            ArrayList<ComponentInstLight> components = new ArrayList<ComponentInstLight>();
            stmt = con.prepareStatement(queryAllSpaceInstances);
            stmt.setInt(1, spaceId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                components.add(ComponentDAO.fetchComponentInstance(rs));
            }
            arrayList = components;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close(rs, stmt);
        return arrayList;
    }

    private static String list2String(List<String> ids) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < ids.size(); ++i) {
            if (i != 0) {
                str.append(",");
            }
            str.append(ids.get(i));
        }
        return str.toString();
    }

    public static List<String> getAllAvailableComponentIds(Connection con, List<String> groupIds, int userId) throws SQLException {
        return ComponentDAO.getAllAvailableComponentIds(con, groupIds, userId, null);
    }

    public static List<String> getAllAvailableComponentIds(Connection con, List<String> groupIds, int userId, String componentName) throws SQLException {
        HashSet<String> componentIds = new HashSet<String>();
        componentIds.addAll(ComponentDAO.getAllPublicComponentIds(con));
        if (groupIds != null && groupIds.size() > 0) {
            componentIds.addAll(ComponentDAO.getAllAvailableComponentIds(con, groupIds, componentName));
        }
        componentIds.addAll(ComponentDAO.getAllAvailableComponentIds(con, userId, componentName));
        return new ArrayList<String>(componentIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getAllAvailableComponentIds(Connection con, List<String> groupIds, String componentName) throws SQLException {
        ArrayList<String> arrayList;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            ArrayList<String> ids = new ArrayList<String>();
            String queryAllAvailableComponentIds = "select distinct(c.id), c.componentName from st_componentinstance c, st_userrole r, st_userrole_group_rel gr where c.id=r.instanceId and c.componentstatus is null and r.id=gr.userroleid and r.objectId is null and gr.groupId IN (" + ComponentDAO.list2String(groupIds) + ")";
            stmt = con.createStatement();
            rs = stmt.executeQuery(queryAllAvailableComponentIds);
            while (rs.next()) {
                String cName = rs.getString(2);
                if (StringUtil.isDefined(componentName) && (!StringUtil.isDefined(componentName) || !componentName.equalsIgnoreCase(cName))) continue;
                ids.add(cName + Integer.toString(rs.getInt(1)));
            }
            arrayList = ids;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close(rs, stmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getAllAvailableComponentIds(Connection con, int userId, String componentName) throws SQLException {
        ArrayList<String> arrayList;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            ArrayList<String> ids = new ArrayList<String>();
            stmt = con.prepareStatement(queryAllAvailableComponentIds);
            stmt.setInt(1, userId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String cName = rs.getString(2);
                if (StringUtil.isDefined(componentName) && (!StringUtil.isDefined(componentName) || !componentName.equalsIgnoreCase(cName))) continue;
                ids.add(cName + Integer.toString(rs.getInt(1)));
            }
            arrayList = ids;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close(rs, stmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getAllPublicComponentIds(Connection con) throws SQLException {
        ArrayList<String> arrayList;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            ArrayList<String> ids = new ArrayList<String>();
            stmt = con.prepareStatement(queryAllPublicComponentIds);
            rs = stmt.executeQuery();
            while (rs.next()) {
                ids.add(rs.getString(2) + Integer.toString(rs.getInt(1)));
            }
            arrayList = ids;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close(rs, stmt);
        return arrayList;
    }

    public static List<String> getAvailableComponentIdsInSpace(Connection con, List<String> groupIds, int userId, String spaceId) throws SQLException {
        return ComponentDAO.getAvailableComponentIdsInSpace(con, groupIds, userId, spaceId, null);
    }

    public static List<String> getAvailableComponentIdsInSpace(Connection con, List<String> groupIds, int userId, String spaceId, String componentName) throws SQLException {
        HashSet<ComponentInstLight> componentsSet = new HashSet<ComponentInstLight>();
        componentsSet.addAll(ComponentDAO.getPublicComponentsInSpace(con, spaceId));
        if (groupIds != null && groupIds.size() > 0) {
            componentsSet.addAll(ComponentDAO.getAvailableComponentsInSpace(con, groupIds, spaceId, componentName));
        }
        componentsSet.addAll(ComponentDAO.getAvailableComponentsInSpace(con, userId, spaceId, componentName));
        ArrayList components = new ArrayList(componentsSet);
        Collections.sort(components, new ComponentInstLightSorter());
        ArrayList<String> componentIds = new ArrayList<String>();
        for (ComponentInstLight component : components) {
            componentIds.add(component.getId());
        }
        return componentIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ComponentInstLight> getAvailableComponentsInSpace(Connection con, List<String> groupIds, String spaceId, String componentName) throws SQLException {
        ArrayList<ComponentInstLight> arrayList;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            ArrayList<ComponentInstLight> components = new ArrayList<ComponentInstLight>();
            String queryAvailableComponentIdsInSpace = "select distinct(c.id), c.componentName, c.ordernum from st_componentinstance c, st_userrole r, st_userrole_group_rel gr where c.id=r.instanceId";
            if (StringUtil.isDefined(componentName)) {
                queryAvailableComponentIdsInSpace = queryAvailableComponentIdsInSpace + " and c.componentName = '" + componentName + "'";
            }
            queryAvailableComponentIdsInSpace = queryAvailableComponentIdsInSpace + " and c.componentstatus is null and c.spaceId = " + spaceId + " and r.id=gr.userroleid" + " and r.objectId is null" + " and gr.groupId IN (" + ComponentDAO.list2String(groupIds) + ")";
            stmt = con.createStatement();
            rs = stmt.executeQuery(queryAvailableComponentIdsInSpace);
            while (rs.next()) {
                ComponentInstLight component = new ComponentInstLight();
                component.setId(rs.getString(2) + Integer.toString(rs.getInt(1)));
                component.setOrderNum(rs.getInt(3));
                components.add(component);
            }
            arrayList = components;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close(rs, stmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ComponentInstLight> getAvailableComponentsInSpace(Connection con, int userId, String spaceId, String componentName) throws SQLException {
        ArrayList<ComponentInstLight> arrayList;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            ArrayList<ComponentInstLight> components = new ArrayList<ComponentInstLight>();
            String queryAvailableComponentIdsInSpace = " select distinct(c.id), c.componentName, c.ordernum from st_componentinstance c, st_userrole r, st_userrole_user_rel ur where c.spaceId = " + Integer.parseInt(spaceId);
            if (StringUtil.isDefined(componentName)) {
                queryAvailableComponentIdsInSpace = queryAvailableComponentIdsInSpace + " and c.componentName = '" + componentName + "'";
            }
            queryAvailableComponentIdsInSpace = queryAvailableComponentIdsInSpace + " and c.id=r.instanceId and c.componentstatus is null and r.id=ur.userroleid and r.objectId is null and ur.userId = " + userId;
            stmt = con.createStatement();
            rs = stmt.executeQuery(queryAvailableComponentIdsInSpace);
            while (rs.next()) {
                ComponentInstLight component = new ComponentInstLight();
                component.setId(rs.getString(2) + Integer.toString(rs.getInt(1)));
                component.setOrderNum(rs.getInt(3));
                components.add(component);
            }
            arrayList = components;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close(rs, stmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ComponentInstLight> getPublicComponentsInSpace(Connection con, String spaceId) throws SQLException {
        ArrayList<ComponentInstLight> arrayList;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            ArrayList<ComponentInstLight> components = new ArrayList<ComponentInstLight>();
            stmt = con.prepareStatement(queryPublicComponentIdsInSpace);
            stmt.setInt(1, Integer.parseInt(spaceId));
            rs = stmt.executeQuery();
            while (rs.next()) {
                ComponentInstLight component = new ComponentInstLight();
                component.setId(rs.getString(2) + Integer.toString(rs.getInt(1)));
                component.setOrderNum(rs.getInt(3));
                components.add(component);
            }
            arrayList = components;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close(rs, stmt);
        return arrayList;
    }
}

