/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin.dao;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.PaginationPage;
import com.stratelia.webactiv.beans.admin.SearchCriteria;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.silverpeas.admin.user.constant.UserAccessLevel;

public class GroupSearchCriteriaForDAO
implements SearchCriteria {
    private static final String QUERY = "select distinct {0} from {1} {2} order by name";
    private final StringBuilder filter = new StringBuilder();
    private final Set<String> tables = new HashSet<String>();
    private final List<String> domainIds = new ArrayList<String>();
    private PaginationPage page = null;

    public static GroupSearchCriteriaForDAO newCriteria() {
        return new GroupSearchCriteriaForDAO();
    }

    @Override
    public GroupSearchCriteriaForDAO and() {
        if (this.filter.length() > 0) {
            this.filter.append(" and ");
        }
        return this;
    }

    @Override
    public GroupSearchCriteriaForDAO or() {
        if (this.filter.length() > 0) {
            this.filter.append(" or ");
        }
        return this;
    }

    @Override
    public GroupSearchCriteriaForDAO onName(String name) {
        if (StringUtil.isDefined(name)) {
            this.tables.add("st_group");
            this.getFixedQuery().append("lower(st_group.name) like lower('").append(name).append("')");
        }
        return this;
    }

    @Override
    public GroupSearchCriteriaForDAO onGroupIds(String ... groupIds) {
        if (groupIds != ANY) {
            this.tables.add("st_group");
            StringBuilder[] sqlLists = this.asSQLList(groupIds);
            StringBuilder theQuery = this.getFixedQuery().append("(st_group.id in ").append((CharSequence)sqlLists[0]);
            for (int i = 1; i < sqlLists.length; ++i) {
                theQuery.append(" or st_group.id in ").append((CharSequence)sqlLists[i]);
            }
            theQuery.append(")");
        }
        return this;
    }

    @Override
    public GroupSearchCriteriaForDAO onDomainId(String domainId) {
        if (StringUtil.isDefined(domainId)) {
            this.domainIds.add(domainId);
            this.tables.add("st_group");
            this.getFixedQuery().append("st_group.domainId = ").append(Integer.valueOf(domainId));
        }
        return this;
    }

    @Override
    public GroupSearchCriteriaForDAO onAccessLevels(UserAccessLevel ... accessLevels) {
        if (accessLevels != null && accessLevels.length > 0) {
            this.tables.add("st_user");
            StringBuilder accessLevelsAsCodes = new StringBuilder();
            for (UserAccessLevel accessLevel : accessLevels) {
                if (accessLevelsAsCodes.length() > 0) {
                    accessLevelsAsCodes.append(",");
                }
                accessLevelsAsCodes.append("'");
                accessLevelsAsCodes.append(accessLevel.getCode());
                accessLevelsAsCodes.append("'");
            }
            this.getFixedQuery().append("(st_user.accessLevel in (").append(accessLevelsAsCodes.toString()).append("))");
        }
        return this;
    }

    public GroupSearchCriteriaForDAO onMixedDomainOronDomainId(String domainId) {
        if (StringUtil.isDefined(domainId)) {
            this.domainIds.add(domainId);
            this.tables.add("st_group");
            this.getFixedQuery().append("(st_group.domainId = ").append(Integer.valueOf(domainId)).append(" or st_group.domainId = ").append(Integer.valueOf("-1")).append(")");
        }
        return this;
    }

    @Override
    public SearchCriteria onUserIds(String ... userIds) {
        if (userIds != ANY) {
            this.tables.add("st_user");
            StringBuilder[] sqlLists = this.asSQLList(userIds);
            StringBuilder theQuery = this.getFixedQuery().append("(st_user.id in ").append((CharSequence)sqlLists[0]);
            for (int i = 1; i < sqlLists.length; ++i) {
                theQuery.append(" or st_user.id in ").append((CharSequence)sqlLists[i]);
            }
            theQuery.append(")");
        }
        return this;
    }

    @Override
    public SearchCriteria onRoleNames(String ... roleIds) {
        if (roleIds != null && roleIds.length > 0) {
            this.tables.add("st_group");
            this.tables.add("st_userrole_group_rel");
            StringBuilder[] sqlLists = this.asSQLList(roleIds);
            StringBuilder theQuery = this.getFixedQuery().append("(ST_Group.id = ST_UserRole_Group_Rel.groupId and (ST_UserRole_Group_Rel.userRoleId in ").append((CharSequence)sqlLists[0]);
            for (int i = 1; i < sqlLists.length; ++i) {
                theQuery.append(" or ST_UserRole_Group_Rel.userRoleId in ").append((CharSequence)sqlLists[i]);
            }
            theQuery.append("))");
        }
        return this;
    }

    public SearchCriteria onSuperGroupId(String superGroupId) {
        if (StringUtil.isDefined(superGroupId)) {
            this.tables.add("st_group");
            this.getFixedQuery().append("st_group.superGroupId = ").append(Integer.valueOf(superGroupId));
        }
        return this;
    }

    public SearchCriteria onAsRootGroup() {
        this.tables.add("st_group");
        this.getFixedQuery().append("st_group.superGroupId is null");
        return this;
    }

    public String toSQLQuery(String fields) {
        return MessageFormat.format(QUERY, fields, this.impliedTables(), this.queryFilter());
    }

    public String toString() {
        return this.toSQLQuery("*");
    }

    @Override
    public boolean isEmpty() {
        return this.filter.length() == 0;
    }

    public boolean isCriterionOnDomainIdSet() {
        return !this.domainIds.isEmpty();
    }

    public List<String> getCriterionOnDomainIds() {
        return this.domainIds;
    }

    private String impliedTables() {
        StringBuilder tablesUsedInCriteria = new StringBuilder();
        for (String aTable : this.tables) {
            tablesUsedInCriteria.append(aTable).append(", ");
        }
        return tablesUsedInCriteria.substring(0, tablesUsedInCriteria.length() - 2);
    }

    private String queryFilter() {
        String sqlFilter = "";
        if (this.filter.length() > 0) {
            sqlFilter = sqlFilter + " where " + this.filter;
        }
        return sqlFilter;
    }

    private GroupSearchCriteriaForDAO() {
        this.tables.add("st_group");
    }

    private StringBuilder getFixedQuery() {
        if (this.filter.length() > 0 && !this.filter.toString().endsWith(" and ") && !this.filter.toString().endsWith(" or ")) {
            this.filter.append(" and ");
        }
        return this.filter;
    }

    private StringBuilder[] asSQLList(String ... items) {
        StringBuilder[] lists = new StringBuilder[(int)Math.ceil(items.length / 1000) + 1];
        int count = 0;
        int i = 0;
        lists[i] = new StringBuilder("(");
        for (String anItem : items) {
            if (++count >= 1000) {
                lists[i].setCharAt(lists[i].length() - 1, ')');
                lists[++i] = new StringBuilder("(");
                count = 0;
            }
            lists[i].append(anItem).append(",");
        }
        if (lists[i].toString().endsWith(",")) {
            lists[i].setCharAt(lists[i].length() - 1, ')');
        } else {
            lists[i].append("null").append(")");
        }
        return lists;
    }

    @Override
    public SearchCriteria onComponentInstanceId(String instanceId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SearchCriteria onResourceId(String resourceId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SearchCriteria onPagination(PaginationPage page) {
        if (this.filter.toString().endsWith(" and ")) {
            this.filter.delete(this.filter.toString().lastIndexOf(" and "), this.filter.length());
        } else if (this.filter.toString().endsWith(" or ")) {
            this.filter.delete(this.filter.toString().lastIndexOf(" or "), this.filter.length());
        }
        this.page = page;
        return this;
    }

    public PaginationPage getPagination() {
        return this.page;
    }

    public boolean isPaginationSet() {
        return this.page != null;
    }
}

