/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin.dao;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.PaginationPage;
import com.stratelia.webactiv.beans.admin.SearchCriteria;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.silverpeas.admin.user.constant.UserAccessLevel;

public class UserSearchCriteriaForDAO
implements SearchCriteria {
    private static final String QUERY = "select {0} from {1} where state <> ''DELETED'' {2} {3}";
    private static final String ORDER_BY_LASTNAME = "order by lastName";
    private StringBuilder filter = new StringBuilder();
    private Set<String> tables = new HashSet<String>();
    private PaginationPage page = null;

    public static UserSearchCriteriaForDAO newCriteria() {
        return new UserSearchCriteriaForDAO();
    }

    @Override
    public UserSearchCriteriaForDAO and() {
        if (this.filter.length() > 0) {
            this.filter.append(" and ");
        }
        return this;
    }

    @Override
    public UserSearchCriteriaForDAO or() {
        if (this.filter.length() > 0) {
            this.filter.append(" or ");
        }
        return this;
    }

    @Override
    public UserSearchCriteriaForDAO onName(String name) {
        if (StringUtil.isDefined(name)) {
            this.tables.add("st_user");
            this.getFixedQuery().append("(lower(st_user.firstName) like lower('").append(name).append("') or lower(st_user.lastName) like lower('").append(name).append("'))");
        }
        return this;
    }

    @Override
    public UserSearchCriteriaForDAO onGroupIds(String ... groupIds) {
        this.tables.add("st_user");
        this.tables.add("st_group_user_rel");
        StringBuilder theQuery = this.getFixedQuery().append("(st_group_user_rel.userid = st_user.id");
        if (groupIds != ANY) {
            StringBuilder[] sqlLists = this.asSQLList(groupIds);
            theQuery.append(" and (st_group_user_rel.groupId in ").append((CharSequence)sqlLists[0]);
            for (int i = 1; i < sqlLists.length; ++i) {
                theQuery.append(" or st_group_user_rel.groupId in ").append((CharSequence)sqlLists[i]);
            }
            theQuery.append(")");
        }
        theQuery.append(")");
        return this;
    }

    @Override
    public UserSearchCriteriaForDAO onAccessLevels(UserAccessLevel ... accessLevels) {
        if (accessLevels != null && accessLevels.length > 0) {
            this.tables.add("st_user");
            StringBuilder accessLevelsAsCodes = new StringBuilder();
            for (UserAccessLevel accessLevel : accessLevels) {
                if (accessLevelsAsCodes.length() > 0) {
                    accessLevelsAsCodes.append(",");
                }
                accessLevelsAsCodes.append("'");
                accessLevelsAsCodes.append(accessLevel.getCode());
                accessLevelsAsCodes.append("'");
            }
            this.getFixedQuery().append("(st_user.accessLevel in (").append(accessLevelsAsCodes.toString()).append("))");
        }
        return this;
    }

    @Override
    public UserSearchCriteriaForDAO onDomainId(String domainId) {
        if (StringUtil.isDefined(domainId)) {
            this.tables.add("st_user");
            this.getFixedQuery().append("(st_user.domainId = ").append(Integer.valueOf(domainId)).append(" or st_user.accessLevel = 'A')");
        }
        return this;
    }

    @Override
    public SearchCriteria onUserIds(String ... userIds) {
        if (userIds != ANY) {
            this.tables.add("st_user");
            StringBuilder[] sqlLists = this.asSQLList(userIds);
            StringBuilder theQuery = this.getFixedQuery().append("(st_user.id in ").append((CharSequence)sqlLists[0]);
            for (int i = 1; i < sqlLists.length; ++i) {
                theQuery.append(" or st_user.id in ").append((CharSequence)sqlLists[i]);
            }
            theQuery.append(")");
        }
        return this;
    }

    public String toSQLQuery(String fields) {
        String ordering = ORDER_BY_LASTNAME;
        if (fields.toLowerCase().matches("(count|max|min)\\(.*\\)")) {
            ordering = "";
        }
        return MessageFormat.format(QUERY, fields, this.impliedTables(), this.queryFilter(), ordering);
    }

    public String toString() {
        return this.toSQLQuery("*");
    }

    @Override
    public boolean isEmpty() {
        return this.filter.length() == 0;
    }

    private String impliedTables() {
        StringBuilder tablesUsedInCriteria = new StringBuilder();
        for (String aTable : this.tables) {
            tablesUsedInCriteria.append(aTable).append(", ");
        }
        return tablesUsedInCriteria.substring(0, tablesUsedInCriteria.length() - 2);
    }

    private String queryFilter() {
        String sqlFilter = "";
        if (this.filter.length() > 0) {
            sqlFilter = sqlFilter + " and " + this.filter;
        }
        return sqlFilter;
    }

    private UserSearchCriteriaForDAO() {
        this.tables.add("st_user");
    }

    private StringBuilder getFixedQuery() {
        if (this.filter.length() > 0 && !this.filter.toString().endsWith(" and ") && !this.filter.toString().endsWith(" or ")) {
            this.filter.append(" and ");
        }
        return this.filter;
    }

    private StringBuilder[] asSQLList(String ... items) {
        StringBuilder[] lists = new StringBuilder[(int)Math.ceil(items.length / 1000) + 1];
        int count = 0;
        int i = 0;
        lists[i] = new StringBuilder("(");
        for (String anItem : items) {
            if (++count >= 1000) {
                lists[i].setCharAt(lists[i].length() - 1, ')');
                lists[++i] = new StringBuilder("(");
                count = 0;
            }
            lists[i].append(anItem).append(",");
        }
        if (lists[i].toString().endsWith(",")) {
            lists[i].setCharAt(lists[i].length() - 1, ')');
        } else {
            lists[i].append("null").append(")");
        }
        return lists;
    }

    @Override
    public SearchCriteria onRoleNames(String ... roleIds) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SearchCriteria onComponentInstanceId(String instanceId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SearchCriteria onResourceId(String resourceId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SearchCriteria onPagination(PaginationPage page) {
        if (this.filter.toString().endsWith(" and ")) {
            this.filter.delete(this.filter.toString().lastIndexOf(" and "), this.filter.length());
        } else if (this.filter.toString().endsWith(" or ")) {
            this.filter.delete(this.filter.toString().lastIndexOf(" or "), this.filter.length());
        }
        this.page = page;
        return this;
    }

    public PaginationPage getPagination() {
        return this.page;
    }

    public boolean isPaginationSet() {
        return this.page != null;
    }
}

