/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin.indexation;

import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.beans.admin.UserFull;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.silverpeas.search.indexEngine.model.FullIndexEntry;
import org.silverpeas.search.indexEngine.model.IndexEngineProxy;
import org.silverpeas.search.searchEngine.model.MatchingIndexEntry;
import org.silverpeas.search.searchEngine.model.ParseException;
import org.silverpeas.search.searchEngine.model.QueryDescription;
import org.silverpeas.search.searchEngine.model.WAIndexSearcher;

public class UserIndexation {
    private WAIndexSearcher searcher = new WAIndexSearcher();
    static final String COMPONENT_ID = "users";
    public static final String OBJECT_TYPE = "UserFull";

    public void indexUser(String userId) {
        try {
            UserFull user = UserFull.getById(userId);
            if (user != null) {
                FullIndexEntry indexEntry = new FullIndexEntry(COMPONENT_ID, OBJECT_TYPE, userId);
                indexEntry.setLastModificationDate(new Date());
                indexEntry.setTitle(user.getDisplayedName());
                indexEntry.setPreView(user.geteMail());
                indexEntry.addField("FirstName", user.getFirstName());
                indexEntry.addField("LastName", user.getLastName());
                indexEntry.addField("DomainId", user.getDomainId());
                indexEntry.addField("AccessLevel", user.getAccessLevel().code());
                String[] propertyNames = user.getPropertiesNames();
                StringBuilder extraValues = new StringBuilder(50);
                for (String propertyName : propertyNames) {
                    String extraValue = user.getValue(propertyName);
                    indexEntry.addField(propertyName, extraValue);
                    extraValues.append(extraValue);
                    extraValues.append(" ");
                }
                indexEntry.addTextContent(extraValues.toString());
                IndexEngineProxy.addIndexEntry(indexEntry);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getSimpleName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public void unindexUser(String userId) {
        FullIndexEntry indexEntry = new FullIndexEntry(COMPONENT_ID, OBJECT_TYPE, userId);
        IndexEngineProxy.removeIndexEntry(indexEntry.getPK());
    }

    public List<UserDetail> findUserFromQuery(QueryDescription queryDescription) {
        try {
            MatchingIndexEntry[] results;
            ArrayList<UserDetail> foundUsers = new ArrayList<UserDetail>();
            for (MatchingIndexEntry aResult : results = this.searcher.search(queryDescription)) {
                if (!OBJECT_TYPE.equals(aResult.getObjectType())) continue;
                foundUsers.add(this.toUserDetail(aResult));
            }
            return foundUsers;
        }
        catch (ParseException ex) {
            Logger.getLogger(UserIndexation.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private UserDetail toUserDetail(MatchingIndexEntry entry) {
        return UserDetail.getById(entry.getObjectId());
    }
}

