/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.organization;

import com.stratelia.webactiv.organization.AdminPersistenceException;
import com.stratelia.webactiv.organization.DomainRow;
import com.stratelia.webactiv.organization.OrganizationSchema;
import com.stratelia.webactiv.organization.Table;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class DomainTable
extends Table<DomainRow> {
    private static final String DOMAIN_COLUMNS = "id,name,description,propFileName,className,authenticationServer,theTimeStamp,silverpeasServerURL";
    private static final String SELECT_DOMAIN_BY_ID = "select id,name,description,propFileName,className,authenticationServer,theTimeStamp,silverpeasServerURL from ST_Domain where id = ?";
    private static final String SELECT_ALL_DOMAINS = "select id,name,description,propFileName,className,authenticationServer,theTimeStamp,silverpeasServerURL from ST_Domain where not id=-1 order by name asc";
    private static final String INSERT_DOMAIN = "INSERT INTO ST_Domain (id, name, description, propFileName, className, authenticationServer, theTimeStamp, silverpeasServerURL) VALUES  (? ,? ,?, ? ,?, ?, ?, ?)";
    private static final String UPDATE_DOMAIN = "update ST_Domain set name = ?, description = ?, propFileName = ?, className = ?, authenticationServer = ?, theTimeStamp = ?, silverpeasServerURL = ? where id = ?";
    private static final String DELETE_DOMAIN = "delete from ST_Domain where id = ?";

    public DomainTable(OrganizationSchema schema) {
        super(schema, "ST_Domain");
    }

    protected DomainRow fetchDomain(ResultSet rs) throws SQLException {
        DomainRow d = new DomainRow();
        d.id = rs.getInt(1);
        d.name = rs.getString(2);
        d.description = rs.getString(3);
        d.propFileName = rs.getString(4);
        d.className = rs.getString(5);
        d.authenticationServer = rs.getString(6);
        d.theTimeStamp = rs.getString(7);
        d.silverpeasServerURL = rs.getString(8);
        return d;
    }

    public DomainRow getDomain(int id) throws AdminPersistenceException {
        return (DomainRow)this.getUniqueRow(SELECT_DOMAIN_BY_ID, id);
    }

    public DomainRow[] getAllDomains() throws AdminPersistenceException {
        List<DomainRow> rows = this.getRows(SELECT_ALL_DOMAINS);
        return rows.toArray(new DomainRow[rows.size()]);
    }

    public void createDomain(DomainRow domain) throws AdminPersistenceException {
        this.insertRow(INSERT_DOMAIN, domain);
    }

    @Override
    protected void prepareInsert(String insertQuery, PreparedStatement insert, DomainRow row) throws SQLException {
        if (row.id == -1) {
            row.id = this.getNextId();
        }
        insert.setInt(1, row.id);
        insert.setString(2, DomainTable.truncate(row.name, 100));
        insert.setString(3, DomainTable.truncate(row.description, 400));
        insert.setString(4, DomainTable.truncate(row.propFileName, 100));
        insert.setString(5, DomainTable.truncate(row.className, 100));
        insert.setString(6, DomainTable.truncate(row.authenticationServer, 100));
        insert.setString(7, DomainTable.truncate(row.theTimeStamp, 100));
        insert.setString(8, DomainTable.truncate(row.silverpeasServerURL, 400));
    }

    public void updateDomain(DomainRow domain) throws AdminPersistenceException {
        this.updateRow(UPDATE_DOMAIN, domain);
    }

    @Override
    protected void prepareUpdate(String updateQuery, PreparedStatement update, DomainRow row) throws SQLException {
        update.setString(1, DomainTable.truncate(row.name, 100));
        update.setString(2, DomainTable.truncate(row.description, 400));
        update.setString(3, DomainTable.truncate(row.propFileName, 100));
        update.setString(4, DomainTable.truncate(row.className, 100));
        update.setString(5, DomainTable.truncate(row.authenticationServer, 100));
        update.setString(6, DomainTable.truncate(row.theTimeStamp, 100));
        update.setString(7, DomainTable.truncate(row.silverpeasServerURL, 400));
        update.setInt(8, row.id);
    }

    public void removeDomain(int id) throws AdminPersistenceException {
        DomainRow domain = this.getDomain(id);
        if (domain == null) {
            return;
        }
        this.updateRelation(DELETE_DOMAIN, id);
    }

    @Override
    protected DomainRow fetchRow(ResultSet rs) throws SQLException {
        return this.fetchDomain(rs);
    }
}

