/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util;

import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.exception.MultilangMessage;
import com.stratelia.webactiv.util.exception.UtilException;
import com.stratelia.webactiv.util.pool.ConnectionPool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DBUtil {
    private static DBUtil instance;
    private Connection connectionForTest;
    private volatile int textFieldLength = 1000;
    private volatile int textAreaLength = 2000;
    private volatile int textMaxiLength = 4000;
    private volatile int dateFieldLength = 10;
    private InitialContext ic = null;
    private static Map<String, DataSource> dsStock;

    public static int getDateFieldLength() {
        return DBUtil.getInstance().dateFieldLength;
    }

    public static int getTextMaxiLength() {
        return DBUtil.getInstance().textMaxiLength;
    }

    public static int getTextAreaLength() {
        return DBUtil.getInstance().textAreaLength;
    }

    public static int getTextFieldLength() {
        return DBUtil.getInstance().textFieldLength;
    }

    private DBUtil(Connection connectionForTest) {
        this.connectionForTest = connectionForTest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBUtil getInstance() {
        Class<DBUtil> clazz = DBUtil.class;
        synchronized (DBUtil.class) {
            if (instance == null) {
                instance = new DBUtil(null);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBUtil getInstanceForTest(Connection connectionForTest) {
        DBUtil.clearTestInstance();
        Class<DBUtil> clazz = DBUtil.class;
        synchronized (DBUtil.class) {
            if (connectionForTest != null) {
                instance = new DBUtil(connectionForTest);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearTestInstance() {
        Class<DBUtil> clazz = DBUtil.class;
        synchronized (DBUtil.class) {
            if (instance != null) {
                DBUtil.close(DBUtil.instance.connectionForTest);
            }
            instance = new DBUtil(null);
            dsStock.clear();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static Connection makeConnection(String dbName) {
        return DBUtil.getInstance().openConnection(dbName);
    }

    private synchronized Connection openConnection(String dbName) {
        SilverTrace.debug("util", "DBUtil makeConnection", "DBUtil : makeConnection : entree");
        DataSource ds = null;
        if (this.ic == null) {
            try {
                this.ic = new InitialContext();
            }
            catch (NamingException e) {
                throw new UtilException("DBUtil.makeConnection", "util.MSG_CANT_GET_INITIAL_CONTEXT", e);
            }
        }
        try {
            ds = dsStock.get(dbName);
            if (ds == null) {
                ds = (DataSource)this.ic.lookup(dbName);
                dsStock.put(dbName, ds);
            }
        }
        catch (NamingException e) {
            throw new UtilException("DBUtil.makeConnection", new MultilangMessage("util.MSG_BDD_REF_NOT_FOUND", dbName).toString(), e);
        }
        try {
            return ds.getConnection();
        }
        catch (SQLException e) {
            throw new UtilException("DBUtil.makeConnection", new MultilangMessage("util.MSG_BDD_REF_CANT_GET_CONNECTION", dbName).toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNextId(String tableName, String idName) throws UtilException {
        Connection privateConnection = null;
        boolean testingMode = false;
        try {
            Class<DBUtil> clazz = DBUtil.class;
            synchronized (DBUtil.class) {
                if (DBUtil.getInstance().connectionForTest != null) {
                    privateConnection = DBUtil.getInstance().connectionForTest;
                    testingMode = true;
                } else {
                    privateConnection = ConnectionPool.getConnection();
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                privateConnection.setAutoCommit(false);
                int n = DBUtil.getNextId(privateConnection, tableName, idName);
                return n;
            }
        }
        catch (Exception ex) {
            SilverTrace.debug("util", "DBUtil.getNextId", "impossible de recup\u00e9rer le prochain id", ex);
            if (privateConnection != null) {
                DBUtil.rollback(privateConnection);
            }
            throw new UtilException("DBUtil.getNextId", new MultilangMessage("util.MSG_CANT_GET_A_NEW_UNIQUE_ID", tableName, idName).toString(), ex);
        }
        finally {
            try {
                if (privateConnection != null && !testingMode) {
                    privateConnection.close();
                }
            }
            catch (SQLException e) {
                SilverTrace.error("util", "DBUtil.getNextId", "root.EX_CONNECTION_CLOSE_FAILED", e);
            }
        }
    }

    public static int getNextId(Connection connection, String tableName, String idName) throws SQLException {
        return DBUtil.getMaxId(connection, tableName, idName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int getMaxId(Connection privateConnection, String tableName, String idName) throws SQLException {
        SilverTrace.debug("util", "DBUtil.getNextId", "dBName = " + tableName);
        try {
            int max = DBUtil.updateMaxFromTable(privateConnection, tableName);
            privateConnection.commit();
            return max;
        }
        catch (Exception e) {
            int n;
            SilverTrace.debug("util", "DBUtil.getNextId", "impossible d'updater, if faut recuperer la valeur initiale", e);
            int max = DBUtil.getMaxFromTable(privateConnection, tableName, idName);
            PreparedStatement createStmt = null;
            try {
                String createStatement = "INSERT INTO UniqueId (maxId, tableName) VALUES (?, ?)";
                createStmt = privateConnection.prepareStatement(createStatement);
                createStmt.setInt(1, max);
                createStmt.setString(2, tableName.toLowerCase());
                createStmt.executeUpdate();
                privateConnection.commit();
                n = max;
            }
            catch (Exception e2) {
                try {
                    SilverTrace.debug("util", "DBUtil.getNextId", "impossible de creer, if faut reessayer l'update", e2);
                    DBUtil.rollback(privateConnection);
                }
                catch (Throwable throwable) {
                    DBUtil.close(createStmt);
                    throw throwable;
                }
                DBUtil.close(createStmt);
            }
            DBUtil.close(createStmt);
            return n;
            max = DBUtil.updateMaxFromTable(privateConnection, tableName);
            privateConnection.commit();
            return max;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int updateMaxFromTable(Connection connection, String tableName) throws SQLException {
        block9: {
            String table = tableName.toLowerCase(Locale.ROOT);
            int max = 0;
            PreparedStatement prepStmt = null;
            int count = 0;
            try {
                prepStmt = connection.prepareStatement("UPDATE UniqueId SET maxId = maxId + 1 WHERE tableName = ?");
                prepStmt.setString(1, table);
                count = prepStmt.executeUpdate();
                connection.commit();
            }
            catch (SQLException sqlex) {
                DBUtil.rollback(connection);
                throw sqlex;
            }
            finally {
                DBUtil.close(prepStmt);
            }
            if (count != 1) break block9;
            PreparedStatement selectStmt = null;
            ResultSet rs = null;
            try {
                selectStmt = connection.prepareStatement("SELECT maxId FROM UniqueId WHERE tableName = ?");
                selectStmt.setString(1, table);
                rs = selectStmt.executeQuery();
                if (!rs.next()) {
                    SilverTrace.error("util", "DBUtil.getNextId", "util.MSG_NO_RECORD_FOUND");
                    throw new RuntimeException("Erreur Interne DBUtil.getNextId()");
                }
                max = rs.getInt(1);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, selectStmt);
                throw throwable;
            }
            DBUtil.close(rs, selectStmt);
            return max;
        }
        throw new SQLException("Update impossible : Ligne non existante");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMaxFromTable(Connection con, String tableName, String idName) {
        if (!StringUtil.isDefined(tableName) || !StringUtil.isDefined(idName)) {
            return 1;
        }
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            int maxFromTable = 0;
            String nextPKStatement = "SELECT MAX(" + idName + ") " + "FROM " + tableName;
            prepStmt = con.prepareStatement(nextPKStatement);
            rs = prepStmt.executeQuery();
            if (rs.next()) {
                maxFromTable = rs.getInt(1);
            }
            int n = maxFromTable + 1;
            DBUtil.close(rs, prepStmt);
            return n;
        }
        catch (SQLException ex) {
            DBUtil.rollback(con);
            int n = 1;
            return n;
        }
        finally {
            DBUtil.close(rs, prepStmt);
        }
    }

    public static void close(ResultSet rs, Statement st) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                SilverTrace.error("util", "DBUtil.close", "util.CAN_T_CLOSE_RESULTSET", e);
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                SilverTrace.error("util", "DBUtil.close", "util.CAN_T_CLOSE_STATEMENT", e);
            }
        }
    }

    public static void close(Statement st) {
        DBUtil.close(null, st);
    }

    public static void close(ResultSet rs) {
        DBUtil.close(rs, null);
    }

    public static void close(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                SilverTrace.error("util", "DBUtil.close", "util.CAN_T_CLOSE_CONNECTION", e);
            }
        }
    }

    public static void rollback(Connection connection) {
        if (connection != null) {
            try {
                if (!connection.getAutoCommit() && !connection.isClosed()) {
                    connection.rollback();
                }
            }
            catch (SQLException e) {
                SilverTrace.error("util", "DBUtil.close", "util.CAN_T_ROLLBACK_CONNECTION", e);
            }
        }
    }

    static {
        dsStock = new HashMap<String, DataSource>(5);
    }
}

