/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util;

import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.GeneralPropertiesManager;
import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.fileFolder.FileFolderManager;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.search.indexEngine.IndexFileManager;
import org.silverpeas.util.UnitUtil;

public class FileRepositoryManager {
    static final String securityPath = GeneralPropertiesManager.getString("securityPath");
    static final String exportTemplatePath = GeneralPropertiesManager.getString("exportTemplatePath");
    static final String upLoadPath = GeneralPropertiesManager.getString("uploadsPath");
    static final String avatarPath = GeneralPropertiesManager.getString("avatar.path", upLoadPath + File.separatorChar + "avatar");
    static String tempPath = "";
    static String domainPropertiesFolderPath;
    static String domainAuthenticationPropertiesFolderPath;
    static final ResourceLocator uploadSettings;
    static final String unknownFileIcon;
    public static final String CONTEXT_TOKEN = ",";

    public static String getSecurityDirPath() {
        return securityPath + File.separator;
    }

    @Deprecated
    public static String getAbsolutePath(String sSpaceId, String sComponentId) {
        SilverTrace.debug("util", "FileRepositoryManager.getAbsolutePath", "concat: sSpaceId = " + sSpaceId + " sComponentId= " + sComponentId);
        return upLoadPath + File.separatorChar + sComponentId + File.separatorChar;
    }

    public static String getAbsolutePath(String sComponentId) {
        SilverTrace.debug("util", "FileRepositoryManager.getAbsolutePath", " sComponentId= " + sComponentId);
        return upLoadPath + File.separatorChar + sComponentId + File.separatorChar;
    }

    public static String getAvatarPath() {
        return avatarPath;
    }

    public static String getUploadPath() {
        return upLoadPath + File.separatorChar;
    }

    @Deprecated
    public static String getAbsolutePath(String spaceId, String componentId, String[] directoryName) {
        return FileRepositoryManager.getAbsolutePath(componentId, directoryName);
    }

    public static String getAbsolutePath(String componentId, String[] directoryName) {
        int lg = directoryName.length;
        String path = FileRepositoryManager.getAbsolutePath(componentId);
        for (int k = 0; k < lg; ++k) {
            SilverTrace.debug("util", "FileRepositoryManager.getAbsolutePath", "concat: path = " + path + " sDirectoryName[" + k + "]=" + directoryName[k]);
            path = path + directoryName[k] + File.separatorChar;
        }
        return path;
    }

    public static String getRelativePath(String ... directories) {
        return StringUtil.join((Object[])directories, (char)File.separatorChar) + File.separatorChar;
    }

    public static String getTemporaryPath() {
        return tempPath + File.separatorChar;
    }

    public static String getDomainPropertiesPath(String domainName) {
        return domainPropertiesFolderPath + "domain" + domainName + ".properties";
    }

    public static String getDomainAuthenticationPropertiesPath(String domainName) {
        return domainAuthenticationPropertiesFolderPath + "autDomain" + domainName + ".properties";
    }

    public static String getTemporaryPath(String sSpaceId, String sComponentId) {
        return tempPath + File.separatorChar;
    }

    public static String getComponentTemporaryPath(String sComponentId) {
        return FileRepositoryManager.getAbsolutePath(sComponentId) + "Temp" + File.separatorChar;
    }

    @Deprecated
    public static void createAbsolutePath(String spaceId, String componentId, String directoryName) {
        FileFolderManager.createFolder(FileRepositoryManager.getAbsolutePath(componentId) + directoryName);
    }

    public static void createAbsolutePath(String componentId, String directoryName) {
        FileFolderManager.createFolder(FileRepositoryManager.getAbsolutePath(componentId) + directoryName);
    }

    @Deprecated
    public static void createTempPath(String spaceId, String componentId, String directoryName) {
        FileFolderManager.createFolder(FileRepositoryManager.getAbsolutePath(componentId));
    }

    public static void createTempPath(String sComponentId, String sDirectoryName) {
        FileFolderManager.createFolder(FileRepositoryManager.getAbsolutePath(sComponentId));
    }

    public static void createGlobalTempPath(String sDirectoryName) {
        FileFolderManager.createFolder(FileRepositoryManager.getTemporaryPath() + sDirectoryName);
    }

    public static void createAbsoluteIndexPath(String particularSpace, String componentId) {
        FileFolderManager.createFolder(IndexFileManager.getAbsoluteIndexPath(particularSpace, componentId));
    }

    public static void deleteAbsolutePath(String sSpaceId, String sComponentId, String sDirectoryName) {
        FileFolderManager.deleteFolder(FileRepositoryManager.getAbsolutePath(sComponentId) + sDirectoryName);
    }

    public static void deleteTempPath(String sSpaceId, String sComponentId, String sDirectoryName) {
        FileFolderManager.deleteFolder(FileRepositoryManager.getAbsolutePath(sComponentId));
    }

    public static void deleteAbsoluteIndexPath(String particularSpace, String sComponentId) {
        FileFolderManager.deleteFolder(IndexFileManager.getAbsoluteIndexPath(particularSpace, sComponentId));
    }

    public static String getFileIcon(boolean small, String extension) {
        return FileRepositoryManager.getFileIcon(small, extension, false);
    }

    public static String getFileIcon(String extension) {
        return FileRepositoryManager.getFileIcon(false, extension);
    }

    public static String getFileIcon(String extension, boolean isReadOnly) {
        return FileRepositoryManager.getFileIcon(false, extension, isReadOnly);
    }

    public static String getFileIcon(boolean small, String filename, boolean isReadOnly) {
        String fileIcon;
        String path = URLManager.getApplicationURL() + uploadSettings.getString("FileIconsPath");
        String extension = FilenameUtils.getExtension((String)filename);
        if (!StringUtil.isDefined(extension)) {
            extension = filename;
        }
        if (extension == null) {
            extension = "";
        }
        if ((fileIcon = uploadSettings.getString(extension.toLowerCase(Locale.getDefault()))) == null) {
            fileIcon = unknownFileIcon;
        } else if (isReadOnly) {
            fileIcon = fileIcon.substring(0, fileIcon.lastIndexOf(".gif")) + "Lock.gif";
        }
        if (small && fileIcon != null) {
            String newFileIcon;
            fileIcon = newFileIcon = fileIcon.substring(0, fileIcon.lastIndexOf(".gif")) + "Small.gif";
        }
        return path + fileIcon;
    }

    public static String getFileExtension(String fileName) {
        return FilenameUtils.getExtension((String)fileName);
    }

    public static String formatFileSize(long lSize) {
        return UnitUtil.formatMemSize(lSize);
    }

    public static long getFileSize(String sourceFile) {
        return new File(sourceFile).length();
    }

    public static String getFileDownloadTime(long size) {
        int fileSizeReference = Integer.parseInt(uploadSettings.getString("FileSizeReference"));
        int theoricDownloadTime = Integer.parseInt(uploadSettings.getString("DownloadTime"));
        long fileDownloadEstimation = size * (long)theoricDownloadTime / (long)fileSizeReference / 60L;
        if (fileDownloadEstimation < 1L) {
            return "t < 1 min";
        }
        if (fileDownloadEstimation >= 1L && fileDownloadEstimation < 5L) {
            return "1 < t < 5 mins";
        }
        return " t > 5 mins";
    }

    public static void copyFile(String from, String to) throws IOException {
        FileUtils.copyFile((File)new File(from), (File)new File(to));
    }

    public static String formatFileUploadTime(long size) {
        String min = " m";
        String sec = " s";
        String ms = " ms";
        if (size < 1000L) {
            return Long.toString(size) + ms;
        }
        if (size < 120000L) {
            return Long.toString(size / 1000L) + sec;
        }
        return Long.toString(size / 60000L) + min;
    }

    public static String[] getAttachmentContext(String str) {
        String strAt = "Attachment ,";
        if (str != null) {
            strAt = strAt.concat(str);
        }
        StringTokenizer strToken = new StringTokenizer(strAt, CONTEXT_TOKEN);
        int nElt = strToken.countTokens();
        String[] context = new String[nElt];
        int k = 0;
        while (strToken.hasMoreElements()) {
            context[k] = ((String)strToken.nextElement()).trim();
            ++k;
        }
        return context;
    }

    public static String getExportTemplateRepository() {
        String path = exportTemplatePath;
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    private FileRepositoryManager() {
    }

    static {
        uploadSettings = new ResourceLocator("org.silverpeas.util.uploads.uploadSettings", "");
        unknownFileIcon = uploadSettings.getString("unknown");
        tempPath = GeneralPropertiesManager.getString("tempPath");
        if (!tempPath.endsWith(File.separator)) {
            tempPath = tempPath + File.separatorChar;
        }
        StringBuilder path = new StringBuilder(512);
        path.append(System.getenv("SILVERPEAS_HOME")).append(File.separatorChar).append("properties");
        path.append(File.separatorChar).append("org").append(File.separatorChar).append("silverpeas").append(File.separatorChar);
        domainPropertiesFolderPath = path.toString() + "domains" + File.separatorChar;
        domainAuthenticationPropertiesFolderPath = path.toString() + "authentication" + File.separatorChar;
    }
}

