/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util.fileFolder;

import com.silverpeas.util.FileUtil;
import com.silverpeas.util.ImageUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.exception.UtilException;
import edu.emory.mathcs.backport.java.util.Collections;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.comparator.NameFileComparator;

public class FileFolderManager {
    public static Collection<File> getAllSubFolder(String chemin) throws UtilException {
        ArrayList<File> resultat = new ArrayList<File>();
        File directory = new File(chemin);
        if (directory.isDirectory()) {
            File[] list;
            for (File file : list = directory.listFiles()) {
                if (!file.isDirectory()) continue;
                resultat.add(file);
            }
        } else {
            SilverTrace.error("util", "FileFolderManager.getAllSubFolder", "util.EX_NO_CHEMIN_REPOS", chemin);
            throw new UtilException("FileFolderManager.getAllSubFolder", "util.EX_NO_CHEMIN_REPOS", chemin);
        }
        return resultat;
    }

    public static Collection<File> getAllFile(String chemin) throws UtilException {
        ArrayList<File> resultat = new ArrayList<File>();
        File directory = new File(chemin);
        if (!directory.isDirectory()) {
            SilverTrace.error("util", "FileFolderManager.getAllFile", "util.EX_NO_CHEMIN_REPOS", chemin);
            throw new UtilException("FileFolderManager.getAllFile", "util.EX_NO_CHEMIN_REPOS", chemin);
        }
        resultat = new ArrayList(FileUtils.listFiles((File)directory, null, (boolean)false));
        Collections.sort(resultat, (Comparator)new NameFileComparator(IOCase.INSENSITIVE));
        return resultat;
    }

    public static Collection<File> getAllImages(String chemin) throws UtilException {
        File directory = new File(chemin);
        if (directory.isDirectory()) {
            return FileUtil.listFiles(directory, ImageUtil.IMAGE_EXTENTIONS, false, true);
        }
        SilverTrace.error("util", "FileFolderManager.getAllImages", "util.EX_NO_CHEMIN_REPOS", chemin);
        throw new UtilException("FileFolderManager.getAllImages", "util.EX_NO_CHEMIN_REPOS", chemin);
    }

    public static Collection<File> getAllWebPages(String chemin) throws UtilException {
        ArrayList<File> resultat = new ArrayList<File>();
        File directory = new File(chemin);
        if (directory.isDirectory()) {
            File[] list;
            for (File file : list = directory.listFiles()) {
                if (file.isFile()) {
                    resultat.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                String cheminRep = file.getAbsolutePath();
                Collection<File> fich = FileFolderManager.getAllWebPages(cheminRep);
                for (File page : fich) {
                    resultat.add(page);
                }
            }
        } else {
            SilverTrace.error("util", "FileFolderManager.getAllWebPages", "util.EX_NO_CHEMIN_REPOS", chemin);
            throw new UtilException("FileFolderManager.getAllWebPages", "util.EX_NO_CHEMIN_REPOS", chemin);
        }
        return resultat;
    }

    public static Collection<File> getAllWebPages2(String chemin) throws Exception {
        ArrayList<File> resultat = new ArrayList<File>();
        File directory = new File(chemin);
        if (directory.isDirectory()) {
            File[] list;
            for (File file : list = directory.listFiles()) {
                int indexPoint;
                String fichier;
                String type;
                if (!file.isFile() || !"htm".equals((type = (fichier = file.getName()).substring((indexPoint = fichier.lastIndexOf(".")) + 1)).toLowerCase()) && !"html".equals(type.toLowerCase())) continue;
                resultat.add(file);
            }
        } else {
            SilverTrace.error("util", "FileFolderManager.getAllWebPages2", "util.EX_NO_CHEMIN_REPOS", chemin);
            throw new UtilException("FileFolderManager.getAllWebPages2", "util.EX_NO_CHEMIN_REPOS", chemin);
        }
        return resultat;
    }

    public static void createFolder(String chemin) throws UtilException {
        SilverTrace.info("util", "FileFolderManager.createFolder", "root.MSG_GEN_PARAM_VALUE", "chemin=" + chemin);
        File directory = new File(chemin);
        if (directory == null || !directory.exists() || directory.isDirectory()) {
            FileFolderManager.createFolder(directory);
        }
    }

    public static void createFolder(File directory) throws UtilException {
        try {
            FileUtils.forceMkdir((File)directory);
        }
        catch (IOException ioex) {
            SilverTrace.error("util", "FileFolderManager.createFolder", "util.EX_REPOSITORY_CREATION", directory.getPath(), ioex);
            throw new UtilException("FileFolderManager.createFolder", "util.EX_REPOSITORY_CREATION", directory.getPath(), (Exception)ioex);
        }
    }

    public static void renameFolder(String cheminRep, String newCheminRep) throws UtilException {
        File directory = new File(cheminRep);
        if (directory.isDirectory()) {
            File newDirectory = new File(newCheminRep);
            if (!directory.renameTo(newDirectory)) {
                SilverTrace.error("util", "FileFolderManager.renameFolder", "util.EX_REPOSITORY_RENAME", cheminRep + " en " + newCheminRep);
                throw new UtilException("FileFolderManager.renameFolder", "util.EX_REPOSITORY_RENAME", cheminRep + " en " + newCheminRep);
            }
        } else {
            SilverTrace.error("util", "FileFolderManager.renameFolder", "util.EX_NO_CHEMIN_REPOS", cheminRep);
            throw new UtilException("FileFolderManager.renameFolder", "util.EX_NO_CHEMIN_REPOS", cheminRep);
        }
    }

    public static void deleteFolder(String chemin) {
        File directory = new File(chemin);
        FileUtils.deleteQuietly((File)directory);
    }

    public static void deleteFolder(String chemin, boolean throwException) throws UtilException {
        File directory = new File(chemin);
        boolean result = FileUtils.deleteQuietly((File)directory);
        if (!result) {
            SilverTrace.info("util", "FileFolderManager.deleteFolder", "util.EX_REPOSITORY_DELETE", chemin);
            if (throwException) {
                throw new UtilException("FileFolderManager.deleteFolder", "util.EX_REPOSITORY_DELETE", chemin);
            }
        }
    }

    public static void createFile(String cheminFichier, String nomFichier, String contenuFichier) throws UtilException {
        File directory = new File(cheminFichier);
        if (directory.isDirectory()) {
            try {
                File file = new File(directory, nomFichier);
                FileUtils.writeStringToFile((File)file, (String)contenuFichier, (String)"UTF-8");
            }
            catch (IOException e) {
                throw new UtilException("FileFolderManager.createFile", "util.EX_CREATE_FILE_ERROR", e);
            }
        } else {
            SilverTrace.error("util", "FileFolderManager.createFile", "util.EX_CREATE_FILE_ERROR", cheminFichier);
            throw new UtilException("FileFolderManager.createFile", "util.EX_CREATE_FILE_ERROR");
        }
    }

    public static void renameFile(String cheminRep, String name, String newName) throws UtilException {
        File file = new File(cheminRep, name);
        if (file.isFile()) {
            File newFile = new File(cheminRep, newName);
            if (!file.renameTo(newFile)) {
                SilverTrace.error("util", "FileFolderManager.renameFile", "util.EX_RENAME_FILE_ERROR", name + " en " + cheminRep + "\\" + newName);
                throw new UtilException("FileFolderManager.renameFile", "util.EX_RENAME_FILE_ERROR", name + " en " + cheminRep + "\\" + newName);
            }
        } else {
            SilverTrace.error("util", "FileFolderManager.renameFile", "util.EX_NO_CHEMIN_FINCHER", cheminRep + "\\" + name);
            throw new UtilException("fileFolderManager.renameFile", "util.EX_NO_CHEMIN_FINCHER", cheminRep + "\\" + name);
        }
    }

    public static void deleteFile(String chemin) throws UtilException {
        File directory = new File(chemin);
        boolean result = FileUtils.deleteQuietly((File)directory);
        if (!result) {
            SilverTrace.error("util", "FileFolderManager.deleteFile", "util.EX_DELETE_FILE_ERROR", chemin);
            throw new UtilException("fileFolderManager.deleteFile", "util.EX_DELETE_FILE_ERROR", chemin);
        }
    }

    public static String getCode(String cheminFichier, String nomFichier) throws UtilException {
        File directory = new File(cheminFichier);
        if (directory.isDirectory()) {
            try {
                File file = new File(directory, nomFichier);
                return FileUtils.readFileToString((File)file, (String)"UTF-8");
            }
            catch (IOException e) {
                SilverTrace.debug("util", "FileFolderManager.getCode", "result = null, fichier absent", e);
                return null;
            }
        }
        SilverTrace.error("util", "FileFolderManager.deleteFile", "util.util.EX_WRONG_CHEMLIN_SPEC", cheminFichier);
        throw new UtilException("fileFolderManager.getCode", "util.util.EX_WRONG_CHEMLIN_SPEC", cheminFichier);
    }

    private FileFolderManager() {
    }
}

