/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload.disk;

import com.stratelia.webactiv.util.FileRepositoryManager;
import java.io.File;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.io.FileCleaningTracker;

public class SilverpeasDiskFileItemFactory
extends DiskFileItemFactory {
    private static final int THRESHOLD_SIZE = 0x200000;

    public SilverpeasDiskFileItemFactory() {
        this.setSizeThreshold(0x200000);
        this.setRepository(new File(FileRepositoryManager.getTemporaryPath()));
        this.setFileCleaningTracker(new FileCleaningTracker());
    }

    public FileItem createItem(String fieldName, String contentType, boolean isFormField, String fileName) {
        DiskFileItem result = new DiskFileItem(fieldName, contentType, isFormField, fileName, this.getSizeThreshold(), this.getRepository());
        FileCleaningTracker tracker = this.getFileCleaningTracker();
        if (tracker != null) {
            tracker.track(result.getTempFile(), (Object)result);
        }
        return result;
    }
}

