/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.admin.domain.quota;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.Domain;
import com.stratelia.webactiv.beans.admin.UserDetail;
import org.silverpeas.quota.QuotaKey;
import org.silverpeas.quota.contant.QuotaType;
import org.silverpeas.quota.model.Quota;

public class UserDomainQuotaKey
implements QuotaKey {
    private final String resourceId;

    public static UserDomainQuotaKey from(UserDetail userDetail) {
        return new UserDomainQuotaKey(userDetail);
    }

    public static UserDomainQuotaKey from(Quota quota) {
        return new UserDomainQuotaKey(quota);
    }

    public static UserDomainQuotaKey from(Domain domain) {
        return new UserDomainQuotaKey(domain);
    }

    private UserDomainQuotaKey(UserDetail userDetail) {
        this.resourceId = userDetail.getDomainId();
    }

    private UserDomainQuotaKey(Quota quota) {
        this.resourceId = quota.getResourceId();
    }

    private UserDomainQuotaKey(Domain domain) {
        this.resourceId = domain.getId();
    }

    @Override
    public boolean isValid() {
        return StringUtil.isDefined(this.resourceId);
    }

    @Override
    public QuotaType getQuotaType() {
        return QuotaType.USERS_IN_DOMAIN;
    }

    @Override
    public String getResourceId() {
        return this.resourceId;
    }
}

