/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.admin.space.quota;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.PersonalSpaceController;
import com.stratelia.webactiv.beans.admin.SpaceInst;
import com.stratelia.webactiv.beans.admin.UserDetail;
import org.silverpeas.admin.space.quota.AbstractSpaceQuotaKey;
import org.silverpeas.core.admin.OrganisationController;
import org.silverpeas.core.admin.OrganisationControllerFactory;
import org.silverpeas.quota.contant.QuotaType;

public class DataStorageSpaceQuotaKey
extends AbstractSpaceQuotaKey {
    private final UserDetail user;

    public static DataStorageSpaceQuotaKey from(UserDetail user) {
        return new DataStorageSpaceQuotaKey(new PersonalSpaceController().getPersonalSpace(user.getId()), user);
    }

    public static DataStorageSpaceQuotaKey from(SpaceInst space) {
        return new DataStorageSpaceQuotaKey(space, space.isPersonalSpace() ? space.getCreator() : null);
    }

    public static DataStorageSpaceQuotaKey from(String componentInstanceId) {
        OrganisationControllerFactory.getFactory();
        OrganisationController organisationController = OrganisationControllerFactory.getOrganisationController();
        OrganisationControllerFactory.getFactory();
        SpaceInst space = organisationController.getSpaceInstById(OrganisationControllerFactory.getOrganisationController().getComponentInst(componentInstanceId).getDomainFatherId());
        return DataStorageSpaceQuotaKey.from(space);
    }

    private DataStorageSpaceQuotaKey(SpaceInst space, UserDetail user) {
        super(space);
        this.user = user;
    }

    @Override
    public boolean isValid() {
        return this.user != null && StringUtil.isDefined(this.user.getId()) || super.isValid();
    }

    @Override
    public QuotaType getQuotaType() {
        return this.user != null ? QuotaType.DATA_STORAGE_IN_USER_SPACE : QuotaType.DATA_STORAGE_IN_SPACE;
    }

    @Override
    public String getResourceId() {
        return this.user != null ? this.user.getId() : super.getResourceId();
    }

    public UserDetail getUser() {
        return this.user;
    }
}

